/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u0010!\u0001%B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003D\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011)\u0019!C\u00017\"A!\r\u0001B\u0001B\u0003%A\f\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001e\u0011!Y\u0007A!A!\u0002\u0013)\u0007\"\u00027\u0001\t\u0003i\u0007\u0002C;\u0001\u0011\u000b\u0007I\u0011\u0002<\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\bbCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA!\"a\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003}\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002C\u0005\u0002.\u0001\u0001\r\u0011\"\u0003\u00020!A\u00111\u0007\u0001!B\u0013\t\t\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u0011\u0005M\u0003\u0001\"\u0001!\u0003\u007fAa!!\u0016\u0001\t\u0013Y\bbBA,\u0001\u0011\u0005\u0011q\b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u00111\u0018\u0001\u0005\u0002\u0005u&aC,pe.l\u0015M\\1hKJT!!\t\u0012\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0012%\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002&M\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002O\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f\u0011\u0002\u001f7s\u0007>tg-[4\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0012\u0002\r\r|gNZ5h\u0013\tyDHA\u0005YYJ\u001cuN\u001c4jO\u0006Q\u0001\u0010\u001c:D_:4\u0017n\u001a\u0011\u0002\u0011)|'-U;fk\u0016,\u0012a\u0011\t\u0003\t\u0016k\u0011\u0001I\u0005\u0003\r\u0002\u0012\u0001BS8c#V,W/Z\u0001\nU>\u0014\u0017+^3vK\u0002\nQB[8c%\u0016\u0004xn]5u_JLX#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055\u0003\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\n\u0014\u0002\u000e\u0015>\u0014'+\u001a9pg&$xN]=\u0002\u001d)|'MU3q_NLGo\u001c:zA\u0005y1m\\7q_NLG/Z,pe.,'/F\u0001T!\t!v+D\u0001V\u0015\t1\u0006%A\u0004x_J\\WM]:\n\u0005a+&aD\"p[B|7/\u001b;f/>\u00148.\u001a:\u0002!\r|W\u000e]8tSR,wk\u001c:lKJ\u0004\u0013A\u0004:fY\u0016\f7/Z*feZL7-Z\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLI\u0001\bg\u0016\u0014h/[2f\u0013\t\tgL\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001fI,G.Z1tKN+'O^5dK\u0002\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\n\na!Y2u_J\u001c\u0018B\u00016h\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"rA\\8qcJ\u001cH\u000f\u0005\u0002E\u0001!)\u0001(\u0004a\u0001u!)\u0011)\u0004a\u0001\u0007\")\u0001*\u0004a\u0001\u0015\")\u0011+\u0004a\u0001'\")!,\u0004a\u00019\")1-\u0004a\u0001K\u0006yQ.\u0019=UQJ,\u0017\rZ:D_VtG/F\u0001x!\tY\u00030\u0003\u0002zY\t\u0019\u0011J\u001c;\u0002\u0015QD'/Z1e!>|G.F\u0001}!\ri\u0018\u0011B\u0007\u0002}*\u0019q0!\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B;uS2T!!a\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0017q(aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u001dQD'/Z1e!>|Gn\u0018\u0013fcR!\u0011\u0011CA\f!\rY\u00131C\u0005\u0004\u0003+a#\u0001B+oSRD\u0001\"!\u0007\u0011\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0014a\u0003;ie\u0016\fG\rU8pY\u0002\n!c\u001d5vi\u0012|wO\\%o!J|wM]3tgV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005@\u0002\r\u0005$x.\\5d\u0013\u0011\tY#!\n\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003Y\u0019\b.\u001e;e_^t\u0017J\u001c)s_\u001e\u0014Xm]:`I\u0015\fH\u0003BA\t\u0003cA\u0011\"!\u0007\u0014\u0003\u0003\u0005\r!!\t\u0002'MDW\u000f\u001e3po:Le\u000e\u0015:pOJ,7o\u001d\u0011)\u0007Q\t9\u0004E\u0002,\u0003sI1!a\u000f-\u0005!1x\u000e\\1uS2,\u0017AC5oSRL\u0017\r\\5{KR\u0011\u0011\u0011\u0003\u0015\u0004+\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u000bC:tw\u000e^1uS>t'BAA'\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t&a\u0012\u0003\u001bA{7\u000f^\"p]N$(/^2u\u00031\u0019H/\u0019:u)\"\u0014X-\u00193t\u000359W\r\u001e+ie\u0016\fG\rU8pY\u0006A1\u000f[;uI><h\u000eK\u0002\u0019\u00037\u0002B!!\u0012\u0002^%!\u0011qLA$\u0005)\u0001&/\u001a#fgR\u0014x._\u0001\u0011O\u0016$\u0018+^3vK\u0012$\u0016m]6JIN$B!!\u001a\u0002\u0002B1\u0011qMA;\u0003wrA!!\u001b\u0002rA\u0019\u00111\u000e\u0017\u000e\u0005\u00055$bAA8Q\u00051AH]8pizJ1!a\u001d-\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\r\u0019V\r\u001e\u0006\u0004\u0003gb\u0003\u0003BA4\u0003{JA!a \u0002z\t11\u000b\u001e:j]\u001eDq!a!\u001a\u0001\u0004\t))A\u0004sK2,\u0017m]3\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a##\u0003\u0019!w.\\1j]&!\u0011qRAE\u0005\u001d\u0011V\r\\3bg\u0016\fqA]3d_Z,'\u000f\u0006\u0003\u0002\u0012\u0005U\u0005bBAL5\u0001\u0007\u0011\u0011T\u0001\u0005i\u0006\u001c8\u000e\u0005\u0003\u0002\b\u0006m\u0015\u0002BAO\u0003\u0013\u0013A\u0001V1tW\u0006\t2-\u00198dK2\u0014Vm]3sm\u0016$'j\u001c2\u0015\t\u0005E\u00111\u0015\u0005\b\u0003K[\u0002\u0019AA>\u0003\u0019!\u0018m]6JI\u000611/\u001e2nSR$B!!\u0005\u0002,\"9\u0011Q\u0016\u000fA\u0002\u0005=\u0016a\u00016pEB\u0019A)!-\n\u0007\u0005M\u0006EA\u0002K_\n\fqA]3qY\u0006\u001cW\r\u0006\u0003\u0002\u0012\u0005e\u0006bBAW;\u0001\u0007\u0011qV\u0001\u0011C\n|'\u000f\u001e&pE\nKH+Y:l\u0013\u0012$B!!\u0005\u0002@\"9\u0011Q\u0015\u0010A\u0002\u0005m\u0004f\u0001\u0001\u0002DB!\u0011QYAj\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017AC:uKJ,w\u000e^=qK*!\u0011QZAh\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAAi\u0003\ry'oZ\u0005\u0005\u0003+\f9MA\u0005D_6\u0004xN\\3oi\u0002")
public class WorkManager
implements Logging {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final JobRepository jobRepository;
    private final CompositeWorker compositeWorker;
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;
    private ExecutorService threadPool;
    private volatile AtomicBoolean shutdownInProgress;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        return !this.bitmap$0 ? this.maxThreadsCount$lzycompute() : this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private void shutdownInProgress_$eq(AtomicBoolean x$1) {
        this.shutdownInProgress = x$1;
    }

    @PostConstruct
    public void initialize() {
        this.startThreads();
    }

    public void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.threadPool().execute(() -> {
            BooleanRef run = BooleanRef.create((boolean)true);
            while (run.elem && !this.shutdownInProgress().get()) {
                Some some;
                try {
                    some = new Some((Object)this.jobQueue().get((Function1<Job, Object>)(Function1 & Serializable)job -> BoxesRunTime.boxToBoolean((boolean)WorkManager.$anonfun$startThreads$3(this, job))));
                }
                catch (InterruptedException e) {
                    this.logger().info((Function0 & Serializable)() -> "Thread is being terminated by shutdown");
                    run.elem = false;
                    some = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Unhandled exception when getting task from the queue", (Function0 & Serializable)() -> e);
                    some = None$.MODULE$;
                }
                Some jobOption = some;
                jobOption.foreach((Function1 & Serializable)x0$1 -> {
                    WorkManager.$anonfun$startThreads$7(this, run, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorService getThreadPool() {
        void var1_1;
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        return this.xlrConfig().metrics().enabled() ? new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution") : var1_1;
    }

    @PreDestroy
    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.threadPool().shutdown();
            this.jobQueue().stopWorkerThreads(this.maxThreadsCount());
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$2 -> true);
        } else {
            this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
        }
    }

    public scala.collection.immutable.Set<String> getQueuedTaskIds(Release release) {
        Buffer taskIdsInProgress = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)WorkManager.$anonfun$getQueuedTaskIds$1(task)))).map((Function1 & Serializable)task -> Ids.getFolderlessId((String)task.getId()));
        return taskIdsInProgress.isEmpty() ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (scala.collection.immutable.Set)this.jobRepository().findQueuedTaskIdsByReleaseUid(release.getCiUid()).toSet().intersect((Set)taskIdsInProgress.toSet());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void recover(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Recovering task '").append(task.getId()).append("'").toString());
        Task task2 = task;
        if (task.isPreconditionInProgress()) {
            this.jobQueue().submit(new PreconditionJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFacetInProgress()) {
            this.jobQueue().submit(new FacetCheckJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFailureHandlerInProgress()) {
            this.jobQueue().submit(new FailureHandlerJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            if (task.isAbortScriptInProgress() || task.isInProgress()) {
                this.jobQueue().submit(new CustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), customScriptTask), (Duration)Duration$.MODULE$.Zero()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new ScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), scriptTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new CreateReleaseTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), createReleaseTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new NotificationTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), notificationTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Task '").append(task.getId()).append("' does not meet any criteria to recover").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void cancelReservedJob(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Cancelling reserved job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Aborting scheduled job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            boolean bl;
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                bl = taskJob.taskId().equals(taskId);
            } else {
                bl = false;
            }
            return bl;
        });
    }

    public static final /* synthetic */ boolean $anonfun$startThreads$3(WorkManager $this, Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            $this.releaseActorService().backpressureWait(taskJob.taskId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return !$this.shutdownInProgress().get();
    }

    public static final /* synthetic */ void $anonfun$startThreads$7(WorkManager $this, BooleanRef run$1, Job x0$1) {
        Job job = x0$1;
        if (job instanceof StopWorkerThread) {
            $this.logger().debug((Function0 & Serializable)() -> "Received StopWorkerThread, stopping");
            run$1.elem = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                try {
                    boxedUnit = (BoxedUnit)$this.compositeWorker().execute().apply((Object)job);
                }
                catch (Exception e) {
                    $this.logger().error((Function0 & Serializable)() -> new StringBuilder(40).append("Unhandled exception when executing task ").append(job).toString(), (Function0 & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                $this.jobQueue().finish(job);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getQueuedTaskIds$1(Task task) {
        return task.isInProgress() || task.isFailureHandlerInProgress() || task.isAbortScriptInProgress() || task.isPreconditionInProgress() || task.isFacetInProgress();
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, JobRepository jobRepository, CompositeWorker compositeWorker, ReleaseService releaseService, ReleaseActorService releaseActorService) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.jobRepository = jobRepository;
        this.compositeWorker = compositeWorker;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
        this.shutdownInProgress = new AtomicBoolean(false);
    }
}

