/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.Runner;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001\u0002\u0012$\u00011B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011=\u0003!Q1A\u0005\u0002AC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t1\u0002\u0011)\u0019!C\u00013\"A\u0001\r\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0015\r\u0011\"\u0001c\u0011!I\u0007A!A!\u0002\u0013\u0019\u0007\u0002\u00036\u0001\u0005\u000b\u0007I\u0011A6\t\u0011=\u0004!\u0011!Q\u0001\n1DQ\u0001\u001d\u0001\u0005\u0002ED!\"a\u0004\u0001\u0011\u000b\u0007I\u0011BA\t\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%I!a\u0007\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003\u007f\u0001\u0001\u0019!A!B\u0013\ti\u0002C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011\u0011\u000b\u0001!\u0002\u0013\t)\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0006C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0001\u0002r!9\u0011Q\u000f\u0001\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003s\u0002A\u0011BA\u000e\u0011\u001d\tY\b\u0001C\u0001\u0003cBq!! \u0001\t\u0003\ty\bC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011q\u0016\u0001\u0005\u0002\u0005E&aC,pe.l\u0015M\\1hKJT!\u0001J\u0013\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0014(\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002)S\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\tK_\n\u0014VmY8wKJLHj\\4jG\u0006I\u0001\u0010\u001c:D_:4\u0017nZ\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A(J\u0001\u0007G>tg-[4\n\u0005yZ$!\u0003-me\u000e{gNZ5h\u0003)AHN]\"p]\u001aLw\rI\u0001\tU>\u0014\u0017+^3vKV\t!\t\u0005\u00025\u0007&\u0011Ai\t\u0002\t\u0015>\u0014\u0017+^3vK\u0006I!n\u001c2Rk\u0016,X\rI\u0001\u000eU>\u0014'+\u001a9pg&$xN]=\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!aS\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002N\u0015\ni!j\u001c2SKB|7/\u001b;pef\faB[8c%\u0016\u0004xn]5u_JL\b%A\bd_6\u0004xn]5uK^{'o[3s+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+$\u0003\u001d9xN]6feNL!AV*\u0003\u001f\r{W\u000e]8tSR,wk\u001c:lKJ\f\u0001cY8na>\u001c\u0018\u000e^3X_J\\WM\u001d\u0011\u0002\u001dI,G.Z1tKN+'O^5dKV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^K\u000591/\u001a:wS\u000e,\u0017BA0]\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a-J\u0001\u0007C\u000e$xN]:\n\u0005!,'a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017\u0001\u0006:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007%A\tbGR|'oU=ti\u0016l\u0007j\u001c7eKJ,\u0012\u0001\u001c\t\u0003I6L!A\\3\u0003#\u0005\u001bGo\u001c:TsN$X-\u001c%pY\u0012,'/\u0001\nbGR|'oU=ti\u0016l\u0007j\u001c7eKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005sgR,ho\u001e=z!\t!\u0004\u0001C\u00038\u001f\u0001\u0007\u0011\bC\u0003A\u001f\u0001\u0007!\tC\u0003G\u001f\u0001\u0007\u0001\nC\u0003P\u001f\u0001\u0007\u0011\u000bC\u0003Y\u001f\u0001\u0007!\fC\u0003b\u001f\u0001\u00071\rC\u0003k\u001f\u0001\u0007A\u000e\u000b\u0002zwB\u0019A0a\u0003\u000e\u0003uT!A`@\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0002\u0005\r\u0011aB2p]R,\u0007\u0010\u001e\u0006\u0005\u0003\u000b\t9!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tI!A\u0002pe\u001eL1!!\u0004~\u0005\u0011a\u0015M_=\u0002\u001f5\f\u0007\u0010\u00165sK\u0006$7oQ8v]R,\"!a\u0005\u0011\u00079\n)\"C\u0002\u0002\u0018=\u00121!\u00138u\u0003)!\bN]3bIB{w\u000e\\\u000b\u0003\u0003;\u0001B!a\b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\n\u0002*\u0005!Q\u000f^5m\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003C\u0011q\"\u0012=fGV$xN]*feZL7-Z\u0001\u000fi\"\u0014X-\u00193Q_>dw\fJ3r)\u0011\t)$a\u000f\u0011\u00079\n9$C\u0002\u0002:=\u0012A!\u00168ji\"I\u0011Q\b\n\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0014a\u0003;ie\u0016\fG\rU8pY\u0002\n!c\u001d5vi\u0012|wO\\%o!J|wM]3tgV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)!\u00111JA\u0011\u0003\u0019\tGo\\7jG&!\u0011qJA%\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u00192\u000f[;uI><h.\u00138Qe><'/Z:tA\u00059!/\u001e8oKJ\u001cXCAA,!\u0019\tI&a\u0019\u0002h5\u0011\u00111\f\u0006\u0005\u0003;\ny&A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0005t&\u0001\u0006d_2dWm\u0019;j_:LA!!\u001a\u0002\\\t1!)\u001e4gKJ\u00042\u0001NA5\u0013\r\tYg\t\u0002\u0007%Vtg.\u001a:\u0002\u0011I,hN\\3sg\u0002\nQa\u001d;beR$\"!!\u000e\u0002\u0017I,7m\u001c<fe*{'m]\u0001\rgR\f'\u000f\u001e+ie\u0016\fGm]\u0001\u0005gR|\u0007/A\u0007hKR$\u0006N]3bIB{w\u000e\\\u0001\tg\",H\u000fZ8x]\u0006\t2-\u00198dK2\u0014Vm]3sm\u0016$'j\u001c2\u0015\t\u0005U\u0012\u0011\u0011\u0005\b\u0003\u0007s\u0002\u0019AAC\u0003\u0019!\u0018m]6JIB!\u0011qQAK\u001d\u0011\tI)!%\u0011\u0007\u0005-u&\u0004\u0002\u0002\u000e*\u0019\u0011qR\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019jL\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0015\u0011\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Mu&\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003k\ty\nC\u0004\u0002\"~\u0001\r!a)\u0002\u0007)|'\rE\u00025\u0003KK1!a*$\u0005\rQuNY\u0001\be\u0016\u0004H.Y2f)\u0011\t)$!,\t\u000f\u0005\u0005\u0006\u00051\u0001\u0002$\u0006\u0001\u0012MY8si*{'MQ=UCN\\\u0017\n\u001a\u000b\u0005\u0003k\t\u0019\fC\u0004\u0002\u0004\u0006\u0002\r!!\")\u0007\u0001\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\u0011\ti,a\u0001\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002B\u0006m&!C\"p[B|g.\u001a8u\u0001")
public class WorkManager
implements JobRecoveryLogic {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final JobRepository jobRepository;
    private final CompositeWorker compositeWorker;
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private ExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<Runner> runners;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    @Override
    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.maxThreadsCount$lzycompute() : this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<Runner> runners() {
        return this.runners;
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(35).append("Starting work manager with ").append(this.maxThreadsCount()).append(" threads").toString());
        this.stop();
        this.jobQueue().cancelIf(x$2 -> true);
        this.jobQueue().start();
        this.recoverJobs();
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
        ClusterMode clusterMode = this.xlrConfig().cluster().mode();
        if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
            this.recoverAllJobs();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.recoverJobs(this.nodeId());
            this.recoverJobs(null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        this.runners().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            Runner runner = new Runner(this.jobQueue(), this.compositeWorker());
            this.runners().$plus$eq((Object)runner);
            this.threadPool().execute(runner);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private void stop() {
        this.runners().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.runners().clear();
        this.jobQueue().stop();
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorService getThreadPool() {
        void var1_1;
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        return this.xlrConfig().metrics().enabled() ? new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution") : var1_1;
    }

    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.stop();
            this.threadPool().shutdown();
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$4 -> true);
            this.shutdownInProgress().set(false);
        } else {
            this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
        }
    }

    public void cancelReservedJob(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Cancelling reserved job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Aborting scheduled job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            boolean bl;
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                bl = taskJob.taskId().equals(taskId);
            } else {
                bl = false;
            }
            return bl;
        });
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, JobRepository jobRepository, CompositeWorker compositeWorker, ReleaseService releaseService, ReleaseActorService releaseActorService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.jobRepository = jobRepository;
        this.compositeWorker = compositeWorker;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.runners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

