/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import com.xebialabs.xlrelease.views.converters.TeamViewConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TeamFacade {
    private PermissionChecker permissions;
    private TeamService teamService;
    private TeamViewConverter teamViewConverter;
    private TeamMemberViewConverter teamMemberViewConverter;
    private ReleaseActorService releaseActorService;
    private static final List<String> SYSTEM_TEAMS = Arrays.asList("Folder Owner", "Release Admin", "Template Owner");

    @Autowired
    public TeamFacade(PermissionChecker permissions, TeamService teamService, TeamViewConverter teamViewConverter, TeamMemberViewConverter teamMemberViewConverter, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.teamService = teamService;
        this.teamViewConverter = teamViewConverter;
        this.teamMemberViewConverter = teamMemberViewConverter;
        this.releaseActorService = releaseActorService;
    }

    public List<TeamView> getTeams(String containerId) {
        this.permissions.checkViewTeams(containerId);
        return this.teamService.getEffectiveTeams(containerId).stream().map(team -> this.teamViewConverter.toView((Team)team)).collect(Collectors.toList());
    }

    public List<TeamView> setTeams(String containerId, List<TeamView> teamsToUpdate) {
        List<Team> updatedTeams;
        Checks.checkNotNull(teamsToUpdate, (String)"No teams submitted for update.");
        List<com.xebialabs.xlrelease.views.TeamView> otherTeamViews = teamsToUpdate.stream().map(teamView -> new com.xebialabs.xlrelease.views.TeamView(this.teamViewConverter.toTeam((TeamView)teamView), this.teamMemberViewConverter)).collect(Collectors.toList());
        this.permissions.checkEditTeams(containerId, otherTeamViews);
        this.checkPermissions(teamsToUpdate);
        List<Team> submittedTeams = teamsToUpdate.stream().map(teamView -> this.teamViewConverter.toTeam((TeamView)teamView)).collect(Collectors.toList());
        if (Ids.isReleaseId((String)containerId)) {
            updatedTeams = this.releaseActorService.updateTeams(containerId, submittedTeams);
        } else {
            if (Ids.isInRootFolder((String)containerId) || teamsToUpdate.size() > 0) {
                this.checkSystemTeamsArePresent(teamsToUpdate);
            }
            updatedTeams = this.teamService.saveTeamsToPlatform(containerId, submittedTeams);
        }
        return updatedTeams.stream().map(team -> this.teamViewConverter.toView((Team)team)).collect(Collectors.toList());
    }

    private void checkSystemTeamsArePresent(List<TeamView> teamsToUpdate) {
        ArrayList<String> missingSystemTeams = new ArrayList<String>(SYSTEM_TEAMS);
        List updateTeams = teamsToUpdate.stream().map(TeamView::getTeamName).collect(Collectors.toList());
        missingSystemTeams.removeAll(updateTeams);
        Checks.checkArgument((boolean)missingSystemTeams.isEmpty(), (String)"Cannot update teams with the following system teams missing: %s", (Object[])new Object[]{missingSystemTeams});
    }

    private void checkPermissions(List<TeamView> teamsToUpdate) {
        TreeSet unknownPermissions = new TreeSet();
        teamsToUpdate.forEach(t -> unknownPermissions.addAll(t.getPermissions().stream().filter(p -> Permission.find((String)p) == null).collect(Collectors.toList())));
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{unknownPermissions.stream().collect(Collectors.joining(", "))});
    }
}

