/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NextCustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.ChangeJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.ChangeNodeAndStatus;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005i4q!\u0004\b\u0011\u0002\u0007\u0005q\u0003C\u0003+\u0001\u0011\u00051\u0006C\u00030\u0001\u0019\u0005\u0001\u0007C\u00035\u0001\u0019\u0005Q\u0007C\u0003=\u0001\u0019\u0005Q\bC\u0003E\u0001\u0019\u0005Q\tC\u0003M\u0001\u0019\u0005Q\nC\u0003R\u0001\u0011E1\u0006C\u0003S\u0001\u0011E1\u000bC\u0003b\u0001\u0011%!\rC\u0003p\u0001\u0011%\u0001\u000fC\u0003s\u0001\u0011%1\u000fC\u0003w\u0001\u0011%qO\u0001\tK_\n\u0014VmY8wKJLHj\\4jG*\u0011q\u0002E\u0001\ng\u000eDW\rZ;mKJT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001D\b\u0014\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\tyB%D\u0001!\u0015\t\t#%A\u0003tY\u001a$$NC\u0001$\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0013!\u0005\u001daunZ4j]\u001e\u0004\"a\n\u0015\u000e\u00039I!!\u000b\b\u0003\r9{G-Z%e\u0003\u0019!\u0013N\\5uIQ\tA\u0006\u0005\u0002\u001a[%\u0011aF\u0007\u0002\u0005+:LG/\u0001\u0005k_\n\fV/Z;f+\u0005\t\u0004CA\u00143\u0013\t\u0019dB\u0001\u0005K_\n\fV/Z;f\u00035QwN\u0019*fa>\u001c\u0018\u000e^8ssV\ta\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:\u001d\u0005Q!/\u001a9pg&$xN]=\n\u0005mB$!\u0004&pEJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001?!\ty$)D\u0001A\u0015\t\t\u0005#\u0001\u0004bGR|'o]\u0005\u0003\u0007\u0002\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\faB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001G!\t9%*D\u0001I\u0015\tI\u0005#A\u0004tKJ4\u0018nY3\n\u0005-C%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0012C\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014X#\u0001(\u0011\u0005}z\u0015B\u0001)A\u0005E\t5\r^8s'f\u001cH/Z7I_2$WM]\u0001\u000fe\u0016\u001cwN^3s\u00032d'j\u001c2t\u0003-\u0011XmY8wKJTuNY:\u0015\u00051\"\u0006\"B+\t\u0001\u00041\u0016A\u00028pI\u0016LE\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033ji\u0011A\u0017\u0006\u00037Z\ta\u0001\u0010:p_Rt\u0014BA/\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uS\u0012a\u00034j]\u0012\fE\u000e\u001c&pEN$\u0012a\u0019\t\u0004I&dgBA3h\u001d\tIf-C\u0001\u001c\u0013\tA'$A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'aA*fc*\u0011\u0001N\u0007\t\u0003O5L!A\u001c\b\u0003\r){'MU8x\u0003=1\u0017N\u001c3K_\n\u001chi\u001c:O_\u0012,GCA2r\u0011\u0015)&\u00021\u0001W\u0003e1\u0017-\u001b7PeJ+7m\u001c<fe\u0006\u0013\u0017M\u001c3p]\u0016$'j\u001c2\u0015\u00051\"\b\"B;\f\u0001\u0004a\u0017a\u00016pE\u00069!/Z2pm\u0016\u0014HC\u0001\u0017y\u0011\u0015IH\u00021\u0001m\u0003=QwN\u0019*poR{'+Z2pm\u0016\u0014\b")
public interface JobRecoveryLogic
extends Logging,
NodeId {
    public JobQueue jobQueue();

    public JobRepository jobRepository();

    public ReleaseActorService releaseActorService();

    public ReleaseService releaseService();

    @Override
    public ActorSystemHolder actorSystemHolder();

    public static /* synthetic */ void recoverAllJobs$(JobRecoveryLogic $this) {
        $this.recoverAllJobs();
    }

    default public void recoverAllJobs() {
        Seq<JobRow> foundJobs = this.findAllJobs();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Found ").append(foundJobs.size()).append(" jobs, that should be failed or recovered").toString());
        foundJobs.foreach((Function1 & Serializable)job -> {
            this.failOrRecoverAbandonedJob(job);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void recoverJobs$(JobRecoveryLogic $this, String nodeId) {
        $this.recoverJobs(nodeId);
    }

    default public void recoverJobs(String nodeId) {
        Seq<JobRow> foundJobs = this.findJobsForNode(nodeId);
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(67).append("Found ").append(foundJobs.size()).append(" jobs assigned to node = ").append(nodeId).append(", that should be failed or recovered").toString());
        foundJobs.foreach((Function1 & Serializable)job -> {
            this.failOrRecoverAbandonedJob(job);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Seq<JobRow> findAllJobs() {
        void var2_2;
        JobFilters filters = new JobFilters();
        filters.node_$eq(null);
        filters.withoutNode_$eq(false);
        List jobs = CollectionConverters$.MODULE$.ListHasAsScala(this.jobRepository().findAll(filters, Pageable.unpaged()).toList()).asScala().toList();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<JobRow> findJobsForNode(String nodeId) {
        void var3_3;
        JobFilters filters = new JobFilters();
        filters.node_$eq(nodeId);
        if (nodeId == null) {
            filters.withoutNode_$eq(true);
        }
        List jobs = CollectionConverters$.MODULE$.ListHasAsScala(this.jobRepository().findAll(filters, Pageable.unpaged()).toList()).asScala().toList();
        return var3_3;
    }

    private void failOrRecoverAbandonedJob(JobRow job) {
        block6: {
            try {
                boolean bl = false;
                JobStatus jobStatus = null;
                JobStatus jobStatus2 = job.status();
                if (((Object)((Object)JobStatus.QUEUED)).equals((Object)jobStatus2)) {
                    this.recover(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (((Object)((Object)JobStatus.RESERVED)).equals((Object)jobStatus2)) {
                    bl = true;
                    jobStatus = jobStatus2;
                    JobType jobType = job.jobType();
                    JobType jobType2 = JobType.NEXT_CUSTOM_SCRIPT_TASK;
                    if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
                        this.recover(job);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                }
                if (bl) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(59).append("Failing abandoned task ").append(job.taskId()).append(" of type ").append((Object)job.jobType()).append(", that was launched at ").append(job.startTime()).append(" on ").append(job.node()).toString());
                    this.releaseActorService().failTaskWithRetry(job.taskId(), "Task failed. It was interrupted by a server restart.", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$, job.executionId());
                    this.jobRepository().deleteByTaskIdAndExecutionId(job.taskId(), job.executionId());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(60).append("Unable to recover job ").append(job).append(". Please inspect it in 'Task Manager'.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(29).append("Error during recovery of job ").append(job).toString(), (Function0 & Serializable)() -> t);
                Try$.MODULE$.apply((Function0 & Serializable)() -> this.jobRepository().change(new ChangeJobStatus(job, JobStatus.FAILED)));
            }
        }
    }

    private void recover(JobRow jobRowToRecover) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Recovering task '").append(jobRowToRecover.taskId()).append("'").toString());
        Option<JobRow> option = this.jobRepository().change(new ChangeNodeAndStatus(jobRowToRecover, this.nodeId(), JobStatus.QUEUED));
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(91).append("Unable to re-assign abandoned job ").append(jobRowToRecover).append(" to myself [").append(this.nodeId()).append("], maybe it was already taken by another node").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            JobRow jobRow = (JobRow)some2.value();
            JobType jobType = jobRow.jobType();
            if (((Object)((Object)JobType.PRECONDITION)).equals((Object)jobType)) {
                some = new Some((Object)new PreconditionJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.FACET_CHECK)).equals((Object)jobType)) {
                some = new Some((Object)new FacetCheckJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.FAILURE_HANDLER)).equals((Object)jobType)) {
                some = new Some((Object)new FailureHandlerJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
                some = new Some((Object)new CustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.NEXT_CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
                some = new Some((Object)new NextCustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()), jobRow.scheduledStartTime()));
            } else if (((Object)((Object)JobType.SCRIPT_TASK)).equals((Object)jobType)) {
                some = new Some((Object)new ScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.CREATE_RELEASE_TASK)).equals((Object)jobType)) {
                some = new Some((Object)new CreateReleaseTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else if (((Object)((Object)JobType.NOTIFICATION_TASK)).equals((Object)jobType)) {
                some = new Some((Object)new NotificationTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid())));
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Task '").append(jobRow.taskId()).append("' does not meet any criteria to recover").toString());
                some = None$.MODULE$;
            }
            Some jobToQueue = some;
            jobToQueue.foreach((Function1 & Serializable)job -> {
                JobRecoveryLogic.$anonfun$recover$4(this, jobRow, job);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static /* synthetic */ void $anonfun$recover$4(JobRecoveryLogic $this, JobRow jobRow$1, TaskJob job) {
        job.version_$eq(jobRow$1.version());
        job.id_$eq(jobRow$1.id());
        $this.jobQueue().submitExisting(job);
    }

    public static void $init$(JobRecoveryLogic $this) {
    }
}

