/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.events.ReleaseVariablesUpdateOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ExecuteNextCustomScriptPath;
import com.xebialabs.xlrelease.service.PostAction;
import com.xebialabs.xlrelease.utils.PythonScriptCiHelper;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScriptResultsService {
    public static final String OUTPUT_TOO_LONG_MESSAGE = "This value was too long and has been cut off at the end. ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScriptVariables scriptVariables;
    private final CiIdService ciIdService;

    @Autowired
    public ScriptResultsService(ScriptVariables scriptVariables, CiIdService ciIdService) {
        this.scriptVariables = scriptVariables;
        this.ciIdService = ciIdService;
    }

    public Changes resolveScriptTaskResults(Task task, DefaultScriptService.BaseScriptTaskResults baseScriptTaskResults) {
        if (task instanceof CustomScriptTask && baseScriptTaskResults instanceof DefaultScriptService.CustomScriptTaskResults) {
            return this.customScriptTask((CustomScriptTask)task, (DefaultScriptService.CustomScriptTaskResults)baseScriptTaskResults);
        }
        if (baseScriptTaskResults instanceof DefaultScriptService.ScriptTaskResults) {
            return this.task(task, (DefaultScriptService.ScriptTaskResults)baseScriptTaskResults);
        }
        throw new IllegalArgumentException("oh snap! :(");
    }

    private Changes task(Task task, DefaultScriptService.ScriptTaskResults scriptTaskResults) {
        Changes.VariablesChanges releaseVariablesChanges = scriptTaskResults.getReleaseVariablesChanges();
        Changes.VariablesChanges folderVariablesChanges = scriptTaskResults.getFolderVariablesChanges();
        Changes.VariablesChanges globalVariablesChanges = scriptTaskResults.getGlobalVariablesChanges();
        this.scriptVariables.processReleaseVariablesChanges(task.getRelease(), releaseVariablesChanges);
        this.scriptVariables.processFolderVariablesChanges(folderVariablesChanges);
        this.scriptVariables.processGlobalVariablesChanges(globalVariablesChanges);
        ArrayList allOperationsExceptReleaseVariables = new ArrayList();
        allOperationsExceptReleaseVariables.addAll(globalVariablesChanges.getOperations());
        allOperationsExceptReleaseVariables.addAll(folderVariablesChanges.getOperations());
        Changes changes = new Changes();
        changes.addOperations(allOperationsExceptReleaseVariables);
        return changes;
    }

    private Changes customScriptTask(CustomScriptTask task, DefaultScriptService.CustomScriptTaskResults results) {
        task.setNextScriptPath(results.getNextScriptPath());
        task.setStatusLine(results.getStatusLine());
        task.setInterval(results.getInterval());
        if (!task.isStillExecutingScript(results.getScriptExecutionId())) {
            this.logger.debug("Will not save script results of task: '{}' : it has been aborted.", (Object)task.getId());
            return new Changes();
        }
        Changes changes = this.processCustomScriptTaskResults(task, results.getOutputVariables());
        changes.update((ConfigurationItem)task);
        if (task.getNextScriptPath() != null) {
            changes.addPostAction((PostAction)new ExecuteNextCustomScriptPath(task));
        }
        return changes;
    }

    private Changes processCustomScriptTaskResults(CustomScriptTask task, Map<String, Object> outputAttributes) {
        this.setTransitionalProperties(task, outputAttributes);
        return this.setOutputPropertiesAndVariables(task, outputAttributes);
    }

    private void setTransitionalProperties(CustomScriptTask task, Map<String, Object> outputAttributes) {
        task.getPythonScript().getTransitionalProperties().forEach(propertyDescriptor -> {
            String propertyName = propertyDescriptor.getName();
            Object value = outputAttributes.get(propertyName);
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)task.getId(), (Object)propertyDescriptor.getName());
            } else {
                task.getPythonScript().setProperty(propertyName, value);
            }
        });
    }

    private Changes setOutputPropertiesAndVariables(CustomScriptTask task, Map<String, Object> outputAttributes) {
        Changes changes = new Changes();
        Release release = task.getRelease();
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        HashMap<String, Object> newVariableValues = new HashMap<String, Object>();
        HashMap<String, Object> newPasswordVariableValues = new HashMap<String, Object>();
        String taskId = task.getId();
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            String variableName = null;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (propertyValue instanceof String && VariableHelper.containsOnlyVariable((String)((String)propertyValue))) {
                variableName = (String)propertyValue;
            }
            if (task.getVariableMapping().containsKey(fqPropertyName)) {
                variableName = (String)task.getVariableMapping().get(fqPropertyName);
                if (!task.hasNextScriptToExecute()) {
                    task.getVariableMapping().remove(fqPropertyName);
                }
            }
            Object value = outputAttributes.get(propertyName);
            if (task.isKeepPreviousOutputPropertiesOnRetry() && !PythonScriptCiHelper.isEmpty((Object)task.getPythonScript().getProperty(propertyName))) {
                value = task.getPythonScript().getProperty(propertyName);
                if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                    value = VariableHelper.withoutVariableSyntax((String)((String)value));
                }
            }
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                value = this.truncateValue(task, propertyDescriptor.getLabel(), value.toString(), changes);
            }
            task.getPythonScript().setProperty(propertyName, value);
            if (Strings.isNullOrEmpty((String)variableName)) {
                this.logger.debug("Missing output variable on Python script task {} for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.isPassword()) {
                newPasswordVariableValues.put(variableName, value);
                continue;
            }
            newVariableValues.put(variableName, value);
        }
        List oldVariables = CiCloneHelper.cloneCis(release.getVariables());
        release.setVariableValues(newVariableValues);
        release.setPasswordVariableValues(newPasswordVariableValues);
        VariablePersistenceHelper.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        changes.addOperation((XLReleaseOperation)new ReleaseVariablesUpdateOperation(oldVariables, release.getVariables(), true));
        return changes;
    }

    private String truncateValue(CustomScriptTask task, String propertyLabel, String value, Changes changes) {
        int maxOutputPropertySize = task.getPythonScript().getMaxOutputPropertySize();
        if (value.length() > maxOutputPropertySize) {
            value = OUTPUT_TOO_LONG_MESSAGE.concat(value.substring(0, maxOutputPropertySize));
            this.logger.warn("The content of the output property '{}' from task '{}' has been truncated to {} characters", new Object[]{propertyLabel, task.getName(), maxOutputPropertySize});
            changes.addComment((Task)task, String.format("*Warning*: the value for property '%s' has been truncated because it was too large", propertyLabel));
        }
        return value;
    }
}

