/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015!\u0006\u0001\"\u0015V\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u00159\u0007\u0001\"\u0003i\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u00151\b\u0001\"\u0003x\u0011\u0015I\b\u0001\"\u0003{\u0011\u0015a\b\u0001\"\u0003~\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00020\u0001!I!!\r\u0003GI+G.Z1tK*+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ss*\u0011!dG\u0001\u0006U\u0016$H/\u001f\u0006\u00039u\taa]3sm\u0016\u0014(B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\n\t\u0003MIj\u0011a\n\u0006\u00035!R!!\u000b\u0016\u0002\u0011\u0015l'-\u001a3eK\u0012T!a\u000b\u0017\u0002\u0007],'M\u0003\u0002.]\u0005!!m\\8u\u0015\ty\u0003'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\t\u0014aA8sO&\u00111g\n\u0002\u001d\u0015\u0016$H/_*feZdW\r^,fEN+'O^3s\r\u0006\u001cGo\u001c:z\u0003M\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8o+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d \u0003!!W\r\u001d7ps&$\u0018BA\u001e9\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003Q\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8oA\u0005I\u0001\u0010\u001c:D_:4\u0017nZ\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)H\u0001\u0007G>tg-[4\n\u0005\u0011\u000b%!\u0003-me\u000e{gNZ5h\u0003)AHN]\"p]\u001aLw\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!S5\n\u0005\u0002J\u00015\t\u0011\u0004C\u00035\u000b\u0001\u0007a\u0007C\u0003>\u000b\u0001\u0007q(\u0001\rjgJ+w-[:uKJ$UMZ1vYR\u001cVM\u001d<mKR$\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\b\u0005>|G.Z1o\u0003a\u0001xn\u001d;Qe>\u001cWm]:XK\n\f\u0005\u000f]\"p]R,\u0007\u0010\u001e\u000b\u0003-f\u0003\"aT,\n\u0005a\u0003&\u0001B+oSRDQAW\u0004A\u0002m\u000b1bY8oi\u0016DHOU8piB\u0011ALY\u0007\u0002;*\u0011alX\u0001\u0007o\u0016\u0014\u0017\r\u001d9\u000b\u0005i\u0001'BA11\u0003\u001d)7\r\\5qg\u0016L!aY/\u0003\u001b]+'-\u00119q\u0007>tG/\u001a=u\u0003)\u0019X\r^;q\u0015\u0016$H/\u001f\u000b\u0003-\u001aDQA\u0017\u0005A\u0002m\u000b!c]3ukBdun\u001a2bG.4\u0015\u000e\u001c;feR\u0011a+\u001b\u0005\u00065&\u0001\raW\u0001\fg\u0016$X\u000f]*qe&tw\r\u0006\u0002WY\")!L\u0003a\u00017\u0006q1/\u001a;va\u0006\u001b7-Z:t\u0019><GC\u0001,p\u0011\u0015Q6\u00021\u0001\\\u0003=\u0019X\r^;q\u0007>\u00148OR5mi\u0016\u0014HC\u0001,s\u0011\u0015QF\u00021\u0001\\\u0003u\u0019X\r^;q1N\u001c8+Z2ve&$\u0018\u0010S3bI\u0016\u00148OR5mi\u0016\u0014HC\u0001,v\u0011\u0015QV\u00021\u0001\\\u00039\u0019X\r^;q+Jdg)\u001b7uKJ$\"A\u0016=\t\u000bis\u0001\u0019A.\u0002'M,G/\u001e9TY><Hm\\<o\r&dG/\u001a:\u0015\u0005Y[\b\"\u0002.\u0010\u0001\u0004Y\u0016!E:fiV\u0004X\t\u001f;f]NLwN\\!qSR\u0011aK \u0005\u00065B\u0001\raW\u0001\u0015g\u0016$X\u000f\u001d,feNLwN\\#oM>\u00148-\u001a:\u0015\u0007Y\u000b\u0019\u0001C\u0003[#\u0001\u00071,A\ttKR,\bOU3rk\u0016\u001cH\u000fT8dC2$2AVA\u0005\u0011\u0015Q&\u00031\u0001\\\u0003Q)g.\u00192mKJ+7o\\;sG\u0016\u001c8)Y2iKR\u0019a+a\u0004\t\u000bi\u001b\u0002\u0019A.\u0002#\u0015t\u0017M\u00197f\u000fjL\u0007\u000fS1oI2,'\u000fF\u0002W\u0003+AQA\u0017\u000bA\u0002m\u000b\u0011C\\3x'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u0015RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000fM,7o]5p]*\u0011AdX\u0005\u0005\u0003O\tyB\u0001\bTKN\u001c\u0018n\u001c8IC:$G.\u001a:\u00023\u0015t\u0017M\u00197f\u0013:\u001cHO];nK:$X\r\u001a%b]\u0012dWM\u001d\u000b\u0004-\u00065\u0002\"\u0002.\u0017\u0001\u0004Y\u0016!E:fiB\u0013x\u000e]3sifLeMT;mYR)a+a\r\u0002N!9\u0011QG\fA\u0002\u0005]\u0012aA6fsB!\u0011\u0011HA$\u001d\u0011\tY$a\u0011\u0011\u0007\u0005u\u0002+\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u0005U\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0003\u000bC\u0004\u0002P]\u0001\r!a\u000e\u0002\u000bY\fG.^3")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        block2: {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(false);
            errorHandler.setShowServlet(false);
            contextRoot.setSessionHandler(this.newSessionHandler());
            contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
            contextRoot.setErrorHandler(errorHandler);
            if (this.xlrConfig().metrics().enabled()) {
                this.enableInstrumentedHandler(contextRoot);
            }
            if (this.xlrConfig().server_http_gzip_enabled()) {
                this.enableGzipHandler(contextRoot);
            }
            if (!this.xlrConfig().server_http_cache_enabled() || !Environment.isProduction()) break block2;
            this.enableResourcesCache(contextRoot);
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
        }
        contextRoot.getInitParams().put("resteasy.scan.resources", "true");
        contextRoot.getInitParams().put("resteasy.scan.providers", "true");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        block0: {
            if (!this.xlrConfig().api_corsEnabled()) break block0;
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        block0: {
            long slowDownInMs;
            if (!Environment.isDevelopment() || (slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis()) <= 0L) break block0;
            this.logger.warn((Object)new StringBuilder(48).append("Configuring slow down filter with ").append(slowDownInMs).append(" milliseconds.").toString());
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        block0: {
            if (Environment.isDevelopment()) break block0;
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    /*
     * WARNING - void declaration
     */
    private SessionHandler newSessionHandler() {
        void var1_1;
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)new StringBuilder(38).append("Setting up Secure Cookie Enabled to - ").append(this.serverConfiguration().isSecureCookieEnabled()).toString());
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return var1_1;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        block1: {
            block2: {
                if (value == null) break block1;
                if (System.getProperty(key) != null) break block2;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)new StringBuilder(26).append("Setting system property - ").append(key).toString());
                }
                System.setProperty(key, value);
                break block1;
            }
            if (!this.logger.isDebugEnabled()) break block1;
            this.logger.debug((Object)new StringBuilder(51).append("Not overriding already specified system property - ").append(key).toString());
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
    }
}

