/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$IdExtensions$;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;

public final class VariablePersistenceHelper$ {
    public static final VariablePersistenceHelper$ MODULE$ = new VariablePersistenceHelper$();

    public List<Variable> scanAndBuildNewVariables(Release release, VisitableItem updatedItem, CiIdService ciIdService) {
        List newVariables = release.scanAndAddNewVariables(updatedItem);
        this.fixUpVariableIds(release.getId(), release.getVariables(), ciIdService);
        return newVariables;
    }

    public void fixUpVariableIds(String parentId, List<Variable> variables, CiIdService ciIdService) {
        SortedSet ids = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Object)Ordering.String$.MODULE$);
        variables.forEach(v -> {
            if (v.getId() == null || v.getId().isEmpty()) {
                String id = ciIdService.getUniqueId(Type.valueOf(Variable.class), parentId);
                while (ids.contains((Object)id)) {
                    id = ciIdService.getUniqueId(Type.valueOf(Variable.class), parentId);
                }
                ids.add((Object)id);
                v.setId(id);
            } else {
                v.setId(new StringBuilder(1).append(parentId).append("/").append(Ids.getName((String)v.getId())).toString());
            }
            MODULE$.fixUpValueProviderConfigurationId((Variable)v);
            MODULE$.fixUpExternalVariableIds((Variable)v);
        });
    }

    public void fixUpValueProviderConfigurationId(Variable v) {
        ValueProviderConfiguration provider = v.getValueProvider();
        if (provider != null && (VariablePersistenceHelper$IdExtensions$.MODULE$.isNullId$extension(this.IdExtensions(provider.getId())) || VariablePersistenceHelper$IdExtensions$.MODULE$.isNotValueProviderId$extension(this.IdExtensions(provider.getId())) || VariablePersistenceHelper$IdExtensions$.MODULE$.containsNull$extension(this.IdExtensions(provider.getId())))) {
            provider.setId(new StringBuilder(1).append(v.getId()).append("/").append(ValueProviderConfiguration.CONFIGURATION_ID).toString());
            return;
        }
    }

    public void fixUpExternalVariableIds(Variable v) {
        if (!(v instanceof PasswordStringVariable)) {
            return;
        }
        PasswordStringVariable passwordStringVariable = (PasswordStringVariable)v;
        ExternalVariableValue externalVariableValue = passwordStringVariable.getExternalVariableValue();
        if (externalVariableValue == null) {
            return;
        }
        if (VariablePersistenceHelper$IdExtensions$.MODULE$.isNullId$extension(this.IdExtensions(externalVariableValue.getId())) || VariablePersistenceHelper$IdExtensions$.MODULE$.isNotValueProviderId$extension(this.IdExtensions(externalVariableValue.getId())) || VariablePersistenceHelper$IdExtensions$.MODULE$.containsNull$extension(this.IdExtensions(externalVariableValue.getId()))) {
            externalVariableValue.setId(new StringBuilder(22).append(v.getId()).append("/").append("externalVariableValue").toString());
            return;
        }
    }

    public void fixUpGlobalVariable(Variable v, CiIdService ciIdService) {
        Option option = Option$.MODULE$.apply((Object)v.getId());
        if (option instanceof Some) {
        } else if (None$.MODULE$.equals(option)) {
            v.setId(ciIdService.getUniqueId(Type.valueOf(Variable.class), GlobalVariables.GLOBAL_VARIABLES_ID));
        } else {
            throw new MatchError((Object)option);
        }
        this.fixUpVariableState(v, (Option<String>)new Some((Object)"global"), false);
    }

    public void fixUpFolderVariable(Variable v, CiIdService ciIdService) {
        Option option = Option$.MODULE$.apply((Object)v.getId());
        if (option instanceof Some) {
        } else if (None$.MODULE$.equals(option)) {
            v.setId(Ids.getName((String)ciIdService.getUniqueId(Type.valueOf(Variable.class), "")));
        } else {
            throw new MatchError((Object)option);
        }
        this.fixUpVariableState(v, (Option<String>)new Some((Object)"folder"), false);
    }

    public void fixUpReleaseVariable(Variable v, String releaseId, CiIdService ciIdService) {
        Option option = Option$.MODULE$.apply((Object)v.getId());
        if (option instanceof Some) {
        } else if (None$.MODULE$.equals(option)) {
            v.setId(ciIdService.getUniqueId(Type.valueOf(Variable.class), releaseId));
        } else {
            throw new MatchError((Object)option);
        }
        this.fixUpVariableState(v, (Option<String>)None$.MODULE$, true);
    }

    public void fixUpPrefix(Variable v, String prefix) {
        v.setKey(v.getKey().replaceFirst(new StringBuilder(4).append("(?i)").append(prefix).toString(), prefix));
    }

    private void fixUpVariableState(Variable v, Option<String> maybePrefix, boolean releaseFields) {
        v.setFolderId(null);
        Option<String> option = maybePrefix;
        if (option instanceof Some) {
            Some some = (Some)option;
            String prefix = (String)some.value();
            this.fixUpPrefix(v, prefix);
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        if (!releaseFields) {
            v.setShowOnReleaseStart(false);
            v.setRequiresValue(false);
        }
        Option$.MODULE$.apply((Object)v.getValueProvider()).foreach((Function1 & Serializable)provider -> {
            VariablePersistenceHelper$.$anonfun$fixUpVariableState$1(v, provider);
            return BoxedUnit.UNIT;
        });
        this.fixUpExternalVariableIds(v);
    }

    private String IdExtensions(String id) {
        return id;
    }

    public void checkSameType(Variable variable, Variable existing) {
        if (!variable.getType().equals((Object)existing.getType())) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Cannot change type of variable ").append(existing.getId()).append(" from ").append(variable.getType()).append(" to ").append(existing.getType()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$fixUpVariableState$1(Variable v$1, ValueProviderConfiguration provider) {
        provider.setVariable(v$1);
        provider.setId(new StringBuilder(1).append(v$1.getId()).append("/").append(ValueProviderConfiguration.CONFIGURATION_ID).toString());
    }

    private VariablePersistenceHelper$() {
    }
}

