/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.SupportService;
import com.xebialabs.deployit.core.rest.api.SupportAcceleratorConfiguration;
import com.xebialabs.deployit.core.rest.api.SupportResource;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.support.report.SystemInformationService;
import com.xebialabs.xlrelease.support.report.TaskManagerInformationService;
import com.xebialabs.xlrelease.support.tools.SupportUtilities;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Controller
@Path(value="/support")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u0007\u000f\u0001]A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u00021\u0001\t\u0003\n\u0007\"B7\u0001\t\u0003q\u0007bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003#\u0002A\u0011AA*\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a#\u0001\t\u0003\tiI\u0001\nYYJ\u001cV\u000f\u001d9peR\u0014Vm]8ve\u000e,'BA\b\u0011\u0003\u001d\u0019X\u000f\u001d9peRT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001\u0004\n\t\u00033\tj\u0011A\u0007\u0006\u00037q\t1!\u00199j\u0015\tib$\u0001\u0003sKN$(BA\u0010!\u0003\u0011\u0019wN]3\u000b\u0005\u0005\u0012\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\rR\"aD*vaB|'\u000f\u001e*fg>,(oY3\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013!B:mMRR'\"A\u0015\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u000b\u0014\u0003\u000f1{wmZ5oO\u0006q1/\u001e9q_J$8+\u001a:wS\u000e,\u0007C\u0001\u00181\u001b\u0005y#BA\u000e\u001f\u0013\t\ttF\u0001\bTkB\u0004xN\u001d;TKJ4\u0018nY3\u0002!M,\b\u000f]8siV#\u0018\u000e\\5uS\u0016\u001c\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u000f\u0003\u0015!xn\u001c7t\u0013\tATG\u0001\tTkB\u0004xN\u001d;Vi&d\u0017\u000e^5fg\u0006A2/_:uK6LeNZ8s[\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0011A\u0002:fa>\u0014H/\u0003\u0002@y\tA2+_:uK6LeNZ8s[\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002?M,\b\u000f]8si\u0006\u001b7-\u001a7fe\u0006$xN]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001a\u0005&\u00111I\u0007\u0002 'V\u0004\bo\u001c:u\u0003\u000e\u001cW\r\\3sCR|'oQ8oM&<WO]1uS>t\u0017!\b;bg.l\u0015M\\1hKJLeNZ8s[\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005m2\u0015BA$=\u0005u!\u0016m]6NC:\fw-\u001a:J]\u001a|'/\\1uS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0004K\u00196su\n\u0015\t\u0003\u0017\u0002i\u0011A\u0004\u0005\u0006Y\u0019\u0001\r!\f\u0005\u0006e\u0019\u0001\ra\r\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0005\u0006\t\u001a\u0001\r!\u0012\u0015\u0003\rI\u0003\"a\u00150\u000e\u0003QS!!\u0016,\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002X1\u00069a-Y2u_JL(BA-[\u0003\u0015\u0011W-\u00198t\u0015\tYF,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005i\u0016aA8sO&\u0011q\f\u0016\u0002\n\u0003V$xn^5sK\u0012\f!cZ3oKJ\fG/Z*vaB|'\u000f\u001e.jaR\t!\r\u0005\u0002dW6\tAM\u0003\u0002 K*\u0011amZ\u0001\u0003eNT!\u0001[5\u0002\u0005]\u001c(\"\u00016\u0002\u000b)\fg/\u0019=\n\u00051$'\u0001\u0003*fgB|gn]3\u0002)\u001d,GoU=ti\u0016l\u0017J\u001c4pe6\fG/[8o)\u0011\u0011w.a\u0003\t\u000bAD\u0001\u0019A9\u0002\u000fI,\u0007o\u001c:ugB\u0011!o\u001f\b\u0003gf\u0004\"\u0001^<\u000e\u0003UT!A\u001e\f\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0018!B:dC2\f\u0017B\u0001>x\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i<\bFB8\u0000\u0003\u000f\tI\u0001\u0005\u0003\u0002\u0002\u0005\rQ\"A3\n\u0007\u0005\u0015QM\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\fQA^1mk\u0016\f\u0013\u0001\u001d\u0005\b\u0003\u001bA\u0001\u0019AA\b\u0003\u001d\u0011X-];fgR\u00042aYA\t\u0013\r\t\u0019\u0002\u001a\u0002\b%\u0016\fX/Z:uQ\u0011\tY!a\u0006\u0011\u0007\r\fI\"C\u0002\u0002\u001c\u0011\u0014qaQ8oi\u0016DH\u000fK\u0004\t\u0003?\t9!!\n\u0011\t\u0005\u0005\u0011\u0011E\u0005\u0004\u0003G)'\u0001\u0003)s_\u0012,8-Z:-\t\u0005\u001d\u00121F\u0011\u0003\u0003S\t\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8\"\u0005\u00055\u0012!\u0003;fqR|\u0003\u000e^7mQ\u001dA\u0011\u0011GA\u0004\u0003o\u0001B!!\u0001\u00024%\u0019\u0011QG3\u0003\tA\u000bG\u000f[\u0011\u0003\u0003s\t1cL:zgR,W.L5oM>\u0014X.\u0019;j_:D3\u0001CA\u001f!\u0011\t\t!a\u0010\n\u0007\u0005\u0005SMA\u0002H\u000bR\u000b1\"Y2dKB$8OS:p]R!\u0011qIA(!\u0011\tI%a\u0013\u000e\u0003]L1!!\u0014x\u0005\u001d\u0011un\u001c7fC:Dq!!\u0004\n\u0001\u0004\ty!A\be_^tGn\\1e%\u0016dW-Y:f)\r\u0011\u0017Q\u000b\u0005\u0007\u0003/R\u0001\u0019A9\u0002\u0013I,G.Z1tK&#\u0007\u0006CA+\u00037\n9!!\u0019\u0011\t\u0005\u0005\u0011QL\u0005\u0004\u0003?*'!\u0003)bi\"\u0004\u0016M]1nC\t\t9\u0006K\u0004\u000b\u0003?\t9!!\u001a-\u0005\u0005\u001d\u0014EAA5\u0003a\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80_\u000e$X\r^\u0017tiJ,\u0017-\u001c\u0015\b\u0015\u0005E\u0012qAA7C\t\ty'\u0001\u00130e\u0016dW-Y:fg>Z(/\u001a7fCN,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&\u0018\u0016~Q\rQ\u0011QH\u0001\u000eI\u0016dW\r^3SK2,\u0017m]3\u0015\t\u0005]\u0014Q\u0010\t\u0005\u0003\u0013\nI(C\u0002\u0002|]\u0014A!\u00168ji\"1\u0011qK\u0006A\u0002ED\u0003\"! \u0002\\\u0005\u001d\u0011\u0011\r\u0015\b\u0017\u0005E\u0012qAA7Q\rY\u0011Q\u0011\t\u0005\u0003\u0003\t9)C\u0002\u0002\n\u0016\u0014a\u0001R#M\u000bR+\u0015\u0001E;qI\u0006$X\rV1tWN#\u0018\r^;t)\u0019\t9(a$\u0002\u0018\"1\u0011\u0011\u0013\u0007A\u0002E\fa\u0001^1tW&#\u0007\u0006CAH\u00037\n9!!&\"\u0005\u0005E\u0005bBAM\u0019\u0001\u0007\u00111T\u0001\n]\u0016<8\u000b^1ukN\u0004B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0004ti\u0006$Xo\u001d\u0006\u0004\u0003K\u0003\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002*\u0006}%A\u0003+bg.\u001cF/\u0019;vg\":\u0011qS@\u0002\b\u00055\u0016EAAMQ\u001da\u0011\u0011GA\u0004\u0003c\u000b#!a-\u00027=\"\u0018m]6t_m$\u0018m]6JIjr#\u0006V1tWnsv&\u0018\u0016~Q\ra\u0011q\u0017\t\u0005\u0003\u0003\tI,C\u0002\u0002<\u0016\u0014A\u0001U(T)\":\u0001!!\r\u0002\b\u0005}\u0016EAAa\u0003!y3/\u001e9q_J$\bf\u0001\u0001\u0002FB!\u0011qYAg\u001b\t\tIMC\u0002\u0002Lj\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ty-!3\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class XlrSupportResource
extends SupportResource
implements Logging {
    private final SupportUtilities supportUtilities;
    private final SystemInformationService systemInformationService;
    private final TaskManagerInformationService taskManagerInformationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XlrSupportResource xlrSupportResource = this;
        synchronized (xlrSupportResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Response generateSupportZip() {
        this.checkPermission(PlatformPermissions.ADMIN);
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.systemInformationService.writeSystemInformationReport()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate system information report due to error", (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        });
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.systemInformationService.writeThreadDump()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate thread dump due to error", (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(), $anonfun$applyOrElse$4(java.lang.Throwable )}, serializedLambda);
            }
        });
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.taskManagerInformationService.writeTaskManagerReport()).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ XlrSupportResource $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to generate task manager information report due to error", (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(), $anonfun$applyOrElse$6(java.lang.Throwable )}, serializedLambda);
            }
        });
        return super.generateSupportZip();
    }

    @GET
    @Path(value="/system-information")
    @Produces(value={"application/json", "text/html"})
    public Response getSystemInformation(@QueryParam(value="reports") String reports, @Context Request request) {
        Seq requestedReports;
        this.checkPermission(PlatformPermissions.ADMIN);
        Seq seq = requestedReports = reports != null ? ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])reports.toLowerCase().split(","))) : (Seq)package$.MODULE$.Seq().empty();
        if (this.acceptsJson(request)) {
            return Response.ok(this.systemInformationService.generateJsonReport((Seq<String>)requestedReports), (String)"application/json").build();
        }
        return Response.ok((Object)this.systemInformationService.generateHtmlReport((Seq<String>)requestedReports), (String)"text/html").build();
    }

    public boolean acceptsJson(Request request) {
        List variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE}).build();
        Variant variant = request.selectVariant(variants);
        return variant != null && variant.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Path(value="/releases/{releaseId:.*Release[^/]*}")
    @Produces(value={"application/octet-stream"})
    public Response downloadRelease(@PathParam(value="releaseId") String releaseId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        String content = this.supportUtilities.getReleaseContent(releaseId);
        StreamingOutput output = outputStream -> {
            WorkDirContext.initWorkdir((String)"download");
            try {
                outputStream.write(content.getBytes("UTF-8"));
            }
            finally {
                WorkDirContext.get().delete();
                WorkDirContext.clear();
            }
        };
        String fileName = new StringBuilder(5).append(Ids.getName((String)releaseId)).append(".json").toString();
        return ResponseHelper.streamFile(fileName, output, "application/json");
    }

    @DELETE
    @Path(value="/releases/{releaseId:.*Release[^/]*}")
    public void deleteRelease(@PathParam(value="releaseId") String releaseId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Checks.checkTrue((boolean)Ids.isReleaseId((String)releaseId), (String)new StringBuilder(29).append("ID ").append(releaseId).append(" is not a valid release ID").toString(), (Object[])new Object[0]);
        this.supportUtilities.deleteRelease(releaseId);
    }

    @POST
    @Path(value="/tasks/{taskId:.*Task[^/]*}")
    public void updateTaskStatus(@PathParam(value="taskId") String taskId, @QueryParam(value="newStatus") TaskStatus newStatus) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Checks.checkTrue((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(26).append("ID ").append(taskId).append(" is not a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkTrue((Ids.releaseIdFrom((String)taskId) != null ? 1 : 0) != 0, (String)new StringBuilder(35).append("ID ").append(taskId).append(" does not contain the release ID").toString(), (Object[])new Object[0]);
        this.supportUtilities.updateTaskStatus(taskId, newStatus);
    }

    @Autowired
    public XlrSupportResource(SupportService supportService, SupportUtilities supportUtilities, SystemInformationService systemInformationService, SupportAcceleratorConfiguration supportAcceleratorConfiguration, TaskManagerInformationService taskManagerInformationService) {
        this.supportUtilities = supportUtilities;
        this.systemInformationService = systemInformationService;
        this.taskManagerInformationService = taskManagerInformationService;
        super(supportService, supportAcceleratorConfiguration);
        Logging.$init$((Logging)this);
    }
}

