/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.converters.DependencyNodeFactory;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependencyNodeConverter {
    private ReleaseService releaseService;
    private ReleaseViewConverter releaseViewConverter;

    @Autowired
    public DependencyNodeConverter(ReleaseService releaseService, ReleaseViewConverter releaseViewConverter) {
        this.releaseService = releaseService;
        this.releaseViewConverter = releaseViewConverter;
    }

    public List<DependencyNode> toDependencyNodes(List<String> planItemIds, List<String> properties, List<String> extensions) {
        return planItemIds.stream().map(node -> this.toDependencyNode((String)node, properties, extensions)).collect(Collectors.toList());
    }

    private DependencyNode toDependencyNode(String planItemId, List<String> properties, List<String> extensions) {
        DependencyNode dependency = DependencyNodeFactory.fromTargetId(planItemId);
        if (!properties.isEmpty() || !extensions.isEmpty()) {
            Task task;
            String releaseId = Ids.releaseIdFrom((String)planItemId);
            Release release = this.releaseService.findById(releaseId);
            dependency.setRelease(this.releaseViewConverter.toOverviewView(release, properties, extensions, 3));
            if (Ids.isTaskId((String)planItemId) && (task = release.getTask(planItemId)) instanceof CustomScriptTask) {
                PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
                dependency.setTaskColor(pythonScript.getTaskColor());
                dependency.setTaskIconClass(pythonScript.getIconClass());
                dependency.setTaskIconLocation(pythonScript.getIconLocation());
            }
        }
        return dependency;
    }
}

