/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.license;

import com.xebialabs.license.License;
import com.xebialabs.license.service.LicenseInstallServiceImpl;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.license.LicenseRenewEvent;
import com.xebialabs.xlrelease.repository.LicenseRepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%4AAC\u0006\u0001)!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011!1\u0003A!A!\u0002\u00139\u0003\"B\u0017\u0001\t\u0003q\u0003\"B\"\u0001\t\u0003\"\u0005\"\u0002-\u0001\t\u0003I\u0006\"B.\u0001\t\u0003a\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00023\u0001\t\u0003)'\u0001\u0007-M%2K7-\u001a8tK&s7\u000f^1mYN+'O^5dK*\u0011A\"D\u0001\bY&\u001cWM\\:f\u0015\tqq\"A\u0005yYJ,G.Z1tK*\u0011\u0001#E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AE\u0001\u0004G>l7\u0001A\n\u0003\u0001U\u0001\"A\u0006\u000e\u000e\u0003]Q!\u0001G\r\u0002\u000fM,'O^5dK*\u0011AbD\u0005\u00037]\u0011\u0011\u0004T5dK:\u001cX-\u00138ti\u0006dGnU3sm&\u001cW-S7qY\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003=\u0001j\u0011a\b\u0006\u000315I!!I\u0010\u0003!\t\u0013x.\u00193dCN$8+\u001a:wS\u000e,\u0017A\u00047jG\u0016t7/Z*feZL7-\u001a\t\u0003-\u0011J!!J\f\u0003\u001d1K7-\u001a8tKN+'O^5dK\u0006\tB.[2f]N,'+\u001a9pg&$xN]=\u0011\u0005!ZS\"A\u0015\u000b\u0005)j\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A&\u000b\u0002\u0012\u0019&\u001cWM\\:f%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u00030cI\u001a\u0004C\u0001\u0019\u0001\u001b\u0005Y\u0001\"\u0002\u000f\u0005\u0001\u0004i\u0002\"\u0002\u0012\u0005\u0001\u0004\u0019\u0003\"\u0002\u0014\u0005\u0001\u00049\u0003F\u0001\u00036!\t1\u0014)D\u00018\u0015\tA\u0014(\u0001\u0006b]:|G/\u0019;j_:T!AO\u001e\u0002\u000f\u0019\f7\r^8ss*\u0011A(P\u0001\u0006E\u0016\fgn\u001d\u0006\u0003}}\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\t;$!C!vi><\u0018N]3e\u0003EIgn\u001d;bY2tUm\u001e'jG\u0016t7/\u001a\u000b\u0003\u000b&\u0003\"AR$\u000e\u0003eI!\u0001S\r\u0003\u000f1K7-\u001a8tK\")!*\u0002a\u0001\u0017\u0006YA.[2f]N,G+\u001a=u!\taUK\u0004\u0002N'B\u0011a*U\u0007\u0002\u001f*\u0011\u0001kE\u0001\u0007yI|w\u000e\u001e \u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)F\u000bq!\u001b8ti\u0006dG\u000e\u0006\u0002F5\")!J\u0002a\u0001\u0017\u00069\"M]8bI\u000e\f7\u000f\u001e'jG\u0016t7/\u001a*f]\u0016<\u0018\r\u001c\u000b\u0002;B\u0011alX\u0007\u0002#&\u0011\u0001-\u0015\u0002\u0005+:LG/A\u0005ti>\u0014X-\u00138E\u0005R\u0011Ql\u0019\u0005\u0006\u0015\"\u0001\raS\u0001\u0010M&tG\rT5dK:\u001cX-\u00138E\u0005R\ta\rE\u0002_O.K!\u0001[)\u0003\r=\u0003H/[8o\u0001")
public class XLRLicenseInstallService
extends LicenseInstallServiceImpl {
    private final BroadcastService broadcastService;
    private final LicenseRepository licenseRepository;

    public License installNewLicense(String licenseText) {
        License lic = this.install(licenseText);
        this.storeInDB(licenseText);
        this.broadcastLicenseRenewal();
        return lic;
    }

    public License install(String licenseText) {
        License license = super.installNewLicense(licenseText);
        return license;
    }

    public void broadcastLicenseRenewal() {
        this.broadcastService.broadcast(new LicenseRenewEvent(), false);
    }

    public void storeInDB(String licenseText) {
        this.licenseRepository.createOrUpdate(licenseText);
    }

    public Option<String> findLicenseInDB() {
        return this.licenseRepository.find();
    }

    @Autowired
    public XLRLicenseInstallService(BroadcastService broadcastService, LicenseService licenseService, LicenseRepository licenseRepository) {
        this.broadcastService = broadcastService;
        this.licenseRepository = licenseRepository;
        super(XlrConfig$.MODULE$.getInstance().license_location(), licenseService);
    }
}

