/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalAndFolderVariablesDecorator;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.builder.PhaseBuilder;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.PhaseCopiedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.PhaseRestart;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.MovementIndexes;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhaseService {
    public static final String DEFAULT_TITLE = "New Phase";
    private CiIdService ciIdService;
    private ReleaseRepository releaseRepository;
    private PhaseRepository phaseRepository;
    private XLReleaseEventBus eventBus;
    private PhaseRestart phaseRestart;
    private InternalMetadataDecoratorService decoratorService;
    private ReleaseActorService releaseActorService;

    @Autowired
    public PhaseService(CiIdService ciIdService, ReleaseRepository releaseRepository, PhaseRepository phaseRepository, XLReleaseEventBus eventBus, PhaseRestart phaseRestart, InternalMetadataDecoratorService decoratorService, ReleaseActorService releaseActorService) {
        this.ciIdService = ciIdService;
        this.releaseRepository = releaseRepository;
        this.phaseRepository = phaseRepository;
        this.eventBus = eventBus;
        this.phaseRestart = phaseRestart;
        this.decoratorService = decoratorService;
        this.releaseActorService = releaseActorService;
    }

    @Timed
    public Phase create(String parentId) {
        Release release = this.releaseRepository.findById(parentId);
        Phase newPhase = this.buildInPosition(release, PhaseBuilder.newPhase().withTitle(DEFAULT_TITLE).build(), null);
        return this.create(release, newPhase);
    }

    @Timed
    public Phase create(String parentId, Phase phaseTemplate, Integer position) {
        Release release = this.releaseRepository.findById(parentId);
        this.checkPosition(release, position);
        Phase newPhase = this.buildInPosition(release, phaseTemplate, position);
        return this.create(release, newPhase);
    }

    public Phase build(Release release, Phase phaseTemplate, Integer position) {
        this.checkPosition(release, position);
        return this.buildInPosition(release, phaseTemplate, position);
    }

    private void checkPosition(Release release, Integer position) {
        if (position != null) {
            Preconditions.checkArgument((position >= 0 && position <= release.getPhases().size() ? 1 : 0) != 0, (Object)"Phase index out of bounds");
            if (position < release.getPhases().size()) {
                Phase phaseAfterPosition = (Phase)release.getPhases().get(position);
                Preconditions.checkArgument((boolean)phaseAfterPosition.isPlanned(), (Object)"Can't add a phase before a phase that is active or done");
            }
        }
    }

    private Phase buildInPosition(Release release, Phase phaseTemplate, Integer position) {
        Phase releasePhase = phaseTemplate != null ? phaseTemplate : PhaseBuilder.newPhase().withTitle(DEFAULT_TITLE).build();
        Preconditions.checkArgument((boolean)release.isUpdatable(), (Object)"You can't add a phase to finished release");
        Phase newPhase = PhaseBuilder.newPhase().withId(this.getUniqueId(release.getId())).withTitle(Optional.ofNullable(releasePhase.getTitle()).orElse(DEFAULT_TITLE)).withStatus(PhaseStatus.PLANNED).withColor(releasePhase.getColor()).withDescription(releasePhase.getDescription()).withDueDate(releasePhase.getDueDate()).withPlannedDuration(releasePhase.getPlannedDuration()).withScheduledStartDate(releasePhase.getScheduledStartDate()).withRelease(release).withCiAttributes(releasePhase.get$ciAttributes()).build();
        release.addPhase(newPhase, position != null ? position.intValue() : release.getPhases().size());
        VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)newPhase, this.ciIdService);
        return newPhase;
    }

    private Phase create(Release release, Phase newPhase) {
        Phase createdPhase = this.phaseRepository.create(release, newPhase);
        this.eventBus.publish((XLReleaseEvent)new PhaseCreatedEvent(createdPhase));
        return createdPhase;
    }

    private String getUniqueId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Phase.class), parentId);
    }

    @Timed
    public Phase findById(String phaseId) {
        return this.phaseRepository.findById(phaseId);
    }

    public Phase findByIdWithoutDecorators(String phaseId) {
        return this.phaseRepository.findByIdWithoutDecorators(phaseId);
    }

    @Timed
    public void delete(String phaseId) {
        Phase phase = this.findByIdWithoutDecorators(phaseId);
        Preconditions.checkArgument((boolean)phase.isPlanned(), (Object)"Only planned phases can be deleted");
        Release release = phase.getRelease();
        release.deletePhase(phase);
        this.phaseRepository.delete(release, phase);
        this.eventBus.publish((XLReleaseEvent)new PhaseDeletedEvent(phase));
    }

    @Timed
    public Phase update(String phaseId, Phase toUpdate) {
        Phase updated = this.findByIdWithoutDecorators(phaseId);
        Preconditions.checkArgument((boolean)updated.isUpdatable(), (String)"The phase '%s' can't be updated because it has finished.", (Object)updated.getTitle());
        Preconditions.checkArgument((boolean)this.isScheduledStartDateUpdatable(updated, toUpdate), (String)"The start date of '%s' can't be updated because this phase has already started.", (Object)updated.getTitle());
        Phase original = CiCloneHelper.cloneCi(updated);
        if (toUpdate.getTitle() != null) {
            Preconditions.checkArgument((!toUpdate.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Phase title is required.");
            updated.setTitle(toUpdate.getTitle());
        }
        updated.setDescription(toUpdate.getDescription());
        updated.setColor(toUpdate.getColor());
        updated.updateDates(toUpdate.getScheduledStartDate(), toUpdate.getDueDate(), toUpdate.getPlannedDuration());
        VariablePersistenceHelper.scanAndBuildNewVariables(updated.getRelease(), (VisitableItem)updated, this.ciIdService);
        Phase savedPhase = this.phaseRepository.update(updated.getRelease(), original, updated);
        this.eventBus.publish((XLReleaseEvent)new PhaseUpdatedEvent(original, savedPhase));
        return savedPhase;
    }

    @Timed
    public Phase copyPhase(Release release, String originPhaseId, int targetPosition) {
        Preconditions.checkArgument((targetPosition >= 0 ? 1 : 0) != 0, (Object)"Target position must be greater or equal to 0.");
        Preconditions.checkArgument((targetPosition <= release.getPhases().size() ? 1 : 0) != 0, (String)"Target position must be between 0 and %s.", (int)release.getPhases().size());
        Phase originPhase = release.getPhase(originPhaseId);
        if (originPhase == null) {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{originPhaseId});
        }
        Preconditions.checkArgument((boolean)originPhase.isUpdatable(), (String)"Cannot copy phase '%s' because it is %s.", (Object)originPhase.getTitle(), (Object)originPhase.getStatus());
        if (targetPosition < release.getPhases().size()) {
            Phase phaseAtPosition = release.getPhase(Integer.valueOf(targetPosition));
            Preconditions.checkArgument((boolean)phaseAtPosition.isUpdatable(), (String)"Can't copy '%s' to targetPosition %s because it will move a phase with status %s to the right. A copied phase must be positioned after an ACTIVE phase.", (Object)originPhase.getTitle(), (Object)targetPosition, (Object)phaseAtPosition.getStatus());
            Preconditions.checkArgument((!phaseAtPosition.isActive() ? 1 : 0) != 0, (String)"Can't copy '%s' to targetPosition %s because it will move an ACTIVE phase to the right.", (Object)originPhase.getTitle(), (int)targetPosition);
        }
        String newPhaseId = this.getUniqueId(release.getId());
        Phase newPhase = CiCloneHelper.cloneCi(originPhase);
        newPhase.resetToPlanned();
        CiHelper.eraseTokens((ConfigurationItem)newPhase);
        CiHelper.rewriteWithNewId((ConfigurationItem)newPhase, (String)newPhaseId);
        newPhase.setTitle(newPhase.getTitle() + " (copy)");
        release.getPhases().add(targetPosition, newPhase);
        Phase savedPhase = this.phaseRepository.create(release, newPhase);
        this.eventBus.publish((XLReleaseEvent)new PhaseCopiedEvent(savedPhase));
        return savedPhase;
    }

    @Timed
    public Phase duplicatePhase(String originPhaseId) {
        Phase originPhase = this.findByIdWithoutDecorators(originPhaseId);
        Release release = originPhase.getRelease();
        Preconditions.checkArgument((boolean)originPhase.isUpdatable(), (String)"Can't duplicate phase '%s' because it is %s.", (Object)originPhase.getTitle(), (Object)originPhase.getStatus());
        String newPhaseId = this.getUniqueId(release.getId());
        Phase duplicatedPhase = CiCloneHelper.cloneCi(originPhase);
        duplicatedPhase.resetToPlanned();
        CiHelper.eraseTokens((ConfigurationItem)duplicatedPhase);
        CiHelper.rewriteWithNewId((ConfigurationItem)duplicatedPhase, (String)newPhaseId);
        duplicatedPhase.setOriginId(null);
        release.addBelow(originPhaseId, duplicatedPhase);
        Phase savedDuplicatedPhase = this.phaseRepository.create(release, duplicatedPhase);
        this.eventBus.publish((XLReleaseEvent)new PhaseDuplicatedEvent(savedDuplicatedPhase));
        return savedDuplicatedPhase;
    }

    @Timed
    public Phase movePhase(Release release, MovementIndexes movementIndexes) {
        Phase movedPhase = release.movePhase(movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        Phase savedPhase = this.phaseRepository.move(release, movedPhase);
        this.eventBus.publish((XLReleaseEvent)new PhaseMovedEvent(savedPhase, movementIndexes.getOriginIndex().intValue(), movementIndexes.getTargetIndex().intValue()));
        return savedPhase;
    }

    @Timed
    public PhaseRestart.RestartPhaseResult restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease, Release release) {
        PhaseRestart.RestartPhaseResult restartPhaseResult = this.phaseRestart.restartPhases(releaseId, phaseId, taskId, phaseVersion, resumeRelease, release);
        this.decoratorService.decorate((ConfigurationItem)restartPhaseResult.release(), Arrays.asList(ReleaseGlobalAndFolderVariablesDecorator.GLOBAL_AND_FOLDER_VARIABLES(), ReleaseServerUrlDecorator.SERVER_URL()));
        return restartPhaseResult;
    }

    @Timed
    public Release restartPhase(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion) {
        return this.restartPhase(releaseId, phaseId, taskId, phaseVersion, false);
    }

    @Timed
    public Release restartPhase(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        PhaseRestart.RestartPhaseResult restartPhaseResult = this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion, resumeRelease);
        this.phaseRestart.updateGatesReferencingPhases(restartPhaseResult.release(), restartPhaseResult.phaseIdsToRestore(), restartPhaseResult.restoredPhaseIds());
        return restartPhaseResult.release();
    }

    @Timed
    public String getTitle(String id) {
        return this.phaseRepository.getTitle(id);
    }

    private boolean isScheduledStartDateUpdatable(Phase original, Phase updated) {
        return original.isPlanned() || Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate());
    }
}

