/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\r\u001b\u0001\rB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tq\u0001\u0011\t\u0011)A\u0005i!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!Q1A\u0005\u0002%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006#\u0002!\tA\u0015\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019)\b\u0001)A\u0005S\"9a\u000f\u0001b\u0001\n\u00139\bB\u0002@\u0001A\u0003%\u0001\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0002\u0001C\u0001\u0003\u0003Bq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAd\u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\ty\r\u0001C\u0005\u0003\u0003Bq!!5\u0001\t\u0013\t\tE\u0001\rBe\u000eD\u0017N^5oON\u001b\u0007.\u001a3vY\u0016\u001cVM\u001d<jG\u0016T!a\u0007\u000f\u0002\u000fM,'O^5dK*\u0011QDH\u0001\nq2\u0014X\r\\3bg\u0016T!a\b\u0011\u0002\u0013a,'-[1mC\n\u001c(\"A\u0011\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nQa\u001d7gi)T\u0011aL\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0007\f\u0002\b\u0019><w-\u001b8h\u0003A\t'o\u00195jm&twmU3sm&\u001cW-F\u00015!\t)d'D\u0001\u001b\u0013\t9$D\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\u0012M]2iSZLgnZ*feZL7-\u001a\u0011\u0002\u001f\u0005\u00148\r[5wS:<7i\u001c8gS\u001e,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}q\taaY8oM&<\u0017B\u0001!>\u0005a\t%o\u00195jm&twmU3ui&twm]'b]\u0006<WM]\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cuN\u001c4jO\u0002\nAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,W#\u0001#\u0011\u0005U*\u0015B\u0001$\u001b\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N9\u0005Q!/\u001a9pg&$xN]=\n\u0005=c%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/\u001a7fCN,'+\u001a9pg&$xN]=!\u0003\u0019a\u0014N\\5u}Q)1\u000bV+W/B\u0011Q\u0007\u0001\u0005\u0006e%\u0001\r\u0001\u000e\u0005\u0006s%\u0001\ra\u000f\u0005\u0006\u0005&\u0001\r\u0001\u0012\u0005\u0006\u0011&\u0001\rA\u0013\u0015\u0003\u0013e\u0003\"AW3\u000e\u0003mS!\u0001X/\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002_?\u00069a-Y2u_JL(B\u00011b\u0003\u0015\u0011W-\u00198t\u0015\t\u00117-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0017aA8sO&\u0011am\u0017\u0002\n\u0003V$xn^5sK\u0012\f\u0011#[:DC:\u001cW\r\u001c*fcV,7\u000f^3e+\u0005I\u0007C\u00016t\u001b\u0005Y'B\u00017n\u0003\u0019\tGo\\7jG*\u0011an\\\u0001\u000bG>t7-\u001e:sK:$(B\u00019r\u0003\u0011)H/\u001b7\u000b\u0003I\fAA[1wC&\u0011Ao\u001b\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002%%\u001c8)\u00198dK2\u0014V-];fgR,G\rI\u0001\u0016CJ\u001c\u0007.\u001b<f\u0013:\u0004&o\\4sKN\u001cHj\\2l+\u0005A\bCA=}\u001b\u0005Q(BA>r\u0003\u0011a\u0017M\\4\n\u0005uT(AB(cU\u0016\u001cG/\u0001\fbe\u000eD\u0017N^3J]B\u0013xn\u001a:fgNdunY6!\u0003m9W\r^!sG\"Lg/\u001b8h\u0015>\u00147I]8o'\u000eDW\rZ;mKV\u0011\u00111\u0001\t\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005=\u0001cAA\u0005M5\u0011\u00111\u0002\u0006\u0004\u0003\u001b\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0012\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\tM\u00051\u0002O]8dKN\u001cX\t\u001f9je\u0016$'+\u001a7fCN,7\u000f\u0006\u0003\u0002\u001e\u0005\r\u0002cA\u0013\u0002 %\u0019\u0011\u0011\u0005\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Ky\u0001\u0019AA\u0014\u0003M\u0011X\r\\3bg\u0016\fu-\u001a+p\u0003J\u001c\u0007.\u001b<f!\rI\u0018\u0011F\u0005\u0004\u0003WQ(aB%oi\u0016<WM\u001d\u0015\u0004\u001f\u0005=\u0002\u0003BA\u0019\u0003{i!!a\r\u000b\u0007q\u000b)D\u0003\u0003\u00028\u0005e\u0012aB7fiJL7m\u001d\u0006\u0004\u0003w\u0001\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005}\u00121\u0007\u0002\u0006)&lW\r\u001a\u000b\u0003\u0003;A3\u0001EA\u0018\u0003\u00012\u0017N\u001c3B]\u0012\u0004&o\\2fgN\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z:\u0015\u0011\u0005%\u0013QMA9\u0003w\"B!a\u0013\u0002RA\u0019Q%!\u0014\n\u0007\u0005=cEA\u0002J]RDq!a\u0015\u0012\u0001\u0004\t)&\u0001\u0004bGRLwN\u001c\t\bK\u0005]\u00131AA.\u0013\r\tIF\n\u0002\n\rVt7\r^5p]F\u0002b!!\u0018\u0002b\u0005uQBAA0\u0015\t\u0001h%\u0003\u0003\u0002d\u0005}#a\u0001+ss\"9\u0011qM\tA\u0002\u0005%\u0014\u0001\u00023bi\u0016\u0004B!a\u001b\u0002n5\tq.C\u0002\u0002p=\u0014A\u0001R1uK\"9\u00111O\tA\u0002\u0005U\u0014A\u0005:v]N#\u0018M\u001d;US6,W*\u001b7mSN\u00042!JA<\u0013\r\tIH\n\u0002\u0005\u0019>tw\rC\u0004\u0002~E\u0001\r!a \u0002\u0017\u001d,GOU3mK\u0006\u001cXm\u001d\t\nK\u0005\u0005\u0015\u0011NA&\u0003\u000bK1!a!'\u0005%1UO\\2uS>t'\u0007\u0005\u0004\u0002\b\u0006E\u00151\u0001\b\u0005\u0003\u0013\u000biI\u0004\u0003\u0002\n\u0005-\u0015\"A\u0014\n\u0007\u0005=e%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0015Q\u0013\u0002\u0004'\u0016\f(bAAHM\u0005y\u0001O]8dKN\u001c(+\u001a7fCN,7\u000f\u0006\u0005\u0002\u001c\u0006\u0015\u0016qVA])\u0011\ti*a)\u0011\u0007\u0015\ny*C\u0002\u0002\"\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002TI\u0001\r!!\u0016\t\u000f\u0005\u001d&\u00031\u0001\u0002*\u0006Q!/\u001a7fCN,\u0017\nZ:\u0011\r\u0005\u001d\u00151VA\u0002\u0013\u0011\ti+!&\u0003\u0011%#XM]1cY\u0016Dq!!-\u0013\u0001\u0004\t\u0019,A\u0003d_VtG\u000fE\u0002k\u0003kK1!a.l\u00055\tEo\\7jG&sG/Z4fe\"9\u00111\u000f\nA\u0002\u0005U\u0014aF1sG\"Lg/Z\"p[BdW\r^3e%\u0016dW-Y:f)\u0011\tY&a0\t\u000f\u0005\u00057\u00031\u0001\u0002\u0004\u0005I!/\u001a7fCN,\u0017\nZ\u0001\u0012O\u0016$8+Z1sG\"\u0004\u0016mZ3TSj,WCAA&\u00035\u0019H.Z3q\u0013\u001atU-\u001a3fI\u0006Q!/\u00198U_>duN\\4\u0015\t\u0005u\u0015Q\u001a\u0005\b\u0003g2\u0002\u0019AA;\u0003\rygMZ\u0001\u000baJ,G)Z:ue>L\bf\u0001\r\u0002VB!\u0011q[Ap\u001b\t\tINC\u0002]\u00037T!!!8\u0002\u000b)\fg/\u0019=\n\t\u0005\u0005\u0018\u0011\u001c\u0002\u000b!J,G)Z:ue>L\bf\u0001\u0001\u0002fB!\u0011q]Aw\u001b\t\tIOC\u0002\u0002l\u0006\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ty/!;\u0003\u000fM+'O^5dK\u0002")
public class ArchivingScheduleService
implements Logging {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final ReleaseSearchService releaseSearchService;
    private final ReleaseRepository releaseRepository;
    private final AtomicBoolean isCancelRequested;
    private final Object archiveInProgressLock;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingScheduleService archivingScheduleService = this;
        synchronized (archivingScheduleService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object archiveInProgressLock() {
        return this.archiveInProgressLock;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    @Timed
    public void processExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            LocalDateTime now = LocalDateTime.now();
            Date expirationDate = now.minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            Date expirationDateWithGrace = now.minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).minusMinutes(15).toDate();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(70).append("Processing completed releases older than ").append(releaseAgeToArchive).append(" hours (completed before ").append(expirationDate).append(")...").toString());
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                long runStartTimeMillis = System.currentTimeMillis();
                int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, runStartTimeMillis, (Function2<Date, Object, Seq<String>>)(Function2 & Serializable)(date, pageSize) -> ArchivingScheduleService.$anonfun$processExpiredReleases$2(this, date, BoxesRunTime.unboxToInt((Object)pageSize)), (Function1<String, Try<BoxedUnit>>)(Function1 & Serializable)releaseId -> {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(20).append("Archiving release [").append((String)releaseId).append("]").toString());
                    return this.archiveCompletedRelease((String)releaseId);
                });
                IntRef deletedReleaseCount = IntRef.create((int)0);
                if (!this.ranTooLong(runStartTimeMillis)) {
                    deletedReleaseCount.elem = this.findAndProcessArchivableReleases(expirationDateWithGrace, runStartTimeMillis, (Function2<Date, Object, Seq<String>>)(Function2 & Serializable)(date, pageSize) -> ArchivingScheduleService.$anonfun$processExpiredReleases$5(this, date, BoxesRunTime.unboxToInt((Object)pageSize)), (Function1<String, Try<BoxedUnit>>)(Function1 & Serializable)releaseId -> {
                        this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Deleting release [").append((String)releaseId).append("] marked do not archive").toString());
                        return this.archiveCompletedRelease((String)releaseId);
                    });
                }
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Archived ").append(archivedReleasesCount).append(" and deleted ").append(deletedReleaseCount$1.elem).append(" releases in ").append(System.currentTimeMillis() - runStartTimeMillis).append(" ms").toString());
            }
            return;
        }
        this.logger().warn((Function0 & Serializable)() -> "Archiving is not enabled.");
    }

    @Timed
    public void processExpiredReleases() {
        this.processExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private int findAndProcessArchivableReleases(Date date, long runStartTimeMillis, Function2<Date, Object, Seq<String>> getReleases, Function1<String, Try<BoxedUnit>> action) {
        AtomicInteger count;
        block3: {
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(55).append("Fetching ").append(archivingPageSize).append(" completed or aborted releases from repository").toString());
                Seq releaseIds = (Seq)getReleases.apply((Object)date, (Object)BoxesRunTime.boxToInteger((int)archivingPageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Archiving releases that completed before ").append(date).toString());
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable)() -> new StringBuilder(58).append("Archived only ").append(releaseIds.size()).append(" finished releases on this page: we're done.").toString());
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(61).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).append(", fetching the next ").append(archivingPageSize).toString());
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).toString());
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, Try<BoxedUnit>> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, object, action, count, runStartTimeMillis, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long s = System.currentTimeMillis();
            this.archivingService().archiveRelease(releaseId);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Archived release [").append(releaseId).append("] in ").append(System.currentTimeMillis() - s).append(" ms").toString());
        }).recoverWith((PartialFunction)new Serializable(this, releaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable)() -> new StringBuilder(30).append("Could not archive release [").append($this.releaseId$3).append("]: ").append(exception.getMessage()).toString(), (Function0 & Serializable)() -> exception);
                    return (B1)new Failure((Throwable)exception);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof Exception;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$3 = releaseId$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$3 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0) {
            return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize());
        }
        return 20;
    }

    private void sleepIfNeeded() {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) > 0) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(55).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds before archiving the next release").toString());
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds was interrupted").toString());
            }
            return;
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0) {
            return System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000);
        }
        return false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ Seq $anonfun$processExpiredReleases$2(ArchivingScheduleService $this, Date date, int pageSize) {
        return $this.archivingService().findArchivableReleaseIds(date, pageSize);
    }

    public static final /* synthetic */ Seq $anonfun$processExpiredReleases$5(ArchivingScheduleService $this, Date date, int pageSize) {
        return $this.releaseSearchService().findNonArchivedExpiredReleaseIds(date, pageSize);
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, Object nonLocalReturnKey1$1, Function1 action$1, AtomicInteger count$2, long runStartTimeMillis$2, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        $this.sleepIfNeeded();
        ((Try)action$1.apply((Object)releaseId)).foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)count$2.incrementAndGet()));
        if ($this.ranTooLong(runStartTimeMillis$2)) {
            $this.logger().warn((Function0 & Serializable)() -> new StringBuilder(95).append("Archiving paused because it ran for more than ").append($this.archivingConfig().getMaxSecondsPerRun()).append(" seconds. ").append("Archiving will continue in the next run").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivingScheduleService(ArchivingService archivingService, ArchivingSettingsManager archivingConfig, ReleaseSearchService releaseSearchService, ReleaseRepository releaseRepository) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        this.releaseSearchService = releaseSearchService;
        this.releaseRepository = releaseRepository;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.archiveInProgressLock = new Object();
    }
}

