package com.xebialabs.xlrelease.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.codahale.metrics.annotation.Timed;

import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;

@Service
public class PrincipalInfoResolver {

    private UserInfoResolver userInfoResolver;
    private PrincipalDataProvider principalDataProvider;

    @Autowired
    public PrincipalInfoResolver(UserInfoResolver userInfoResolver, PrincipalDataProvider principalDataProvider) {
        this.userInfoResolver = userInfoResolver;
        this.principalDataProvider = principalDataProvider;
    }

    @Timed
    public String getNotificationEmailOf(String principalName) {
        String maybeInternalOrExternalUserEmail = userInfoResolver.getNotificationEmailOf(principalName);
        if (maybeInternalOrExternalUserEmail != null) {
            return maybeInternalOrExternalUserEmail;
        }
        return principalDataProvider.getGroupEmail(principalName);
    }

}
