/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.features.JobSchedulerFeature$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u0010!\u0001%B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\"Aa\n\u0001B\u0001B\u0003%\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001da\u0006A1A\u0005\nuCq!a\u0002\u0001A\u0003%a\fC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011\u0011\u0006\u0001\u0005F\u0005-\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003\u0007\u0004A\u0011IAc\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002V\u0002!\t%a6\t\u000f\u0005m\u0007\u0001\"\u0011\u0002^\"9\u0011q\u001c\u0001\u0005B\u0005u\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003K\u0004A\u0011IAt\u0011\u001d\ty\u000f\u0001C\u0005\u0003;Dq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0002x\u0002!I!!?\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\n92)\u00199bE&d\u0017\u000e^=Bo\u0006\u0014XMS8c#V,W/\u001a\u0006\u0003C\t\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\r\"\u0013!\u0003=me\u0016dW-Y:f\u0015\t)c%A\u0005yK\nL\u0017\r\\1cg*\tq%A\u0002d_6\u001c\u0001a\u0005\u0004\u0001UA\"tG\u000f\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0012T\"\u0001\u0011\n\u0005M\u0002#\u0001\u0003&pEF+X-^3\u0011\u0005E*\u0014B\u0001\u001c!\u00059\u0011VO\u001c8feJ+w-[:uef\u0004\"!\r\u001d\n\u0005e\u0002#a\u0003&pEB\u0013xN^5eKJ\u0004\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u000bMdg\r\u000e6\u000b\u0003}\n\u0001b\u001a:jujdW\rZ\u0005\u0003\u0003r\u0012q\u0001T8hO&tw-\u0001\u0005k_\n\fV/Z;f!\t\tD)\u0003\u0002FA\tyA)\u001a4bk2$(j\u001c2Rk\u0016,X-A\nk_\n\u0014VO\u001c8feJ+\u0007o\\:ji>\u0014\u00180F\u0001I!\tIE*D\u0001K\u0015\tY%%\u0001\u0006sKB|7/\u001b;pefL!!\u0014&\u0003'){'MU;o]\u0016\u0014(+\u001a9pg&$xN]=\u0002))|'MU;o]\u0016\u0014(+\u001a9pg&$xN]=!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\t\tF+D\u0001S\u0015\t\u0019&%\u0001\u0004bGR|'o]\u0005\u0003+J\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003\u0002-Z5n\u0003\"!\r\u0001\t\u000b\t+\u0001\u0019A\"\t\u000b\u0019+\u0001\u0019\u0001%\t\u000b=+\u0001\u0019\u0001)\u0002\u0019I,hN\\3s#V,W/Z:\u0016\u0003y\u0003Ra\u00184i\u0003\u0003i\u0011\u0001\u0019\u0006\u0003C\n\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0019G-\u0001\u0003vi&d'\"A3\u0002\t)\fg/Y\u0005\u0003O\u0002\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tIWP\u0004\u0002ku:\u00111n\u001e\b\u0003YVt!!\u001c;\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9)\u0003\u0019a$o\\8u}%\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0003m\n\naA];o]\u0016\u0014\u0018B\u0001=z\u0003\u0019!w.\\1j]*\u0011aOI\u0005\u0003wr\fq\u0001]1dW\u0006<WM\u0003\u0002ys&\u0011ap \u0002\t%Vtg.\u001a:JI*\u00111\u0010 \t\u0004c\u0005\r\u0011bAA\u0003A\tq!j\u001c2Sk:tWM])vKV,\u0017!\u0004:v]:,'/U;fk\u0016\u001c\b%A\tsK\u001eL7\u000f^3s\u0015>\u0014'+\u001e8oKJ$B!!\u0004\u0002\u0014A\u00191&a\u0004\n\u0007\u0005EAF\u0001\u0003V]&$\bbBA\u000b\u0011\u0001\u0007\u0011qC\u0001\nU>\u0014'+\u001e8oKJ\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004m\u0006u!B\u0001=#\u0013\u0011\t\t#a\u0007\u0003\u0013){'MU;o]\u0016\u0014\u0018aE;oe\u0016<\u0017n\u001d;fe*{'MU;o]\u0016\u0014H\u0003BA\u0007\u0003OAq!!\u0006\n\u0001\u0004\t9\"A\u0002hKR$B!!\f\u0002:A)1&a\f\u00024%\u0019\u0011\u0011\u0007\u0017\u0003\r=\u0003H/[8o!\r\t\u0014QG\u0005\u0004\u0003o\u0001#a\u0001&pE\"1\u00111\b\u0006A\u0002!\f\u0001B];o]\u0016\u0014\u0018\n\u001a\u0015\u0004\u0015\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015C&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002D\t9A/Y5me\u0016\u001c\u0017A\u00043fY\u0006LxJ\u001d*fg\u0016\u0014h/\u001a\u000b\u0007\u0003[\ty%a\u001d\t\u000f\u0005E3\u00021\u0001\u0002T\u0005\u0019!n\u001c21\t\u0005U\u0013q\f\t\u0006c\u0005]\u00131L\u0005\u0004\u00033\u0002#a\u0002+bg.TuN\u0019\t\u0005\u0003;\ny\u0006\u0004\u0001\u0005\u0019\u0005\u0005\u0014qJA\u0001\u0002\u0003\u0015\t!a\u0019\u0003\u0007}#\u0013'\u0005\u0003\u0002f\u0005-\u0004cA\u0016\u0002h%\u0019\u0011\u0011\u000e\u0017\u0003\u000f9{G\u000f[5oOB!\u0011QNA8\u001b\t\ti\"\u0003\u0003\u0002r\u0005u!\u0001\u0002+bg.Da!a\u000f\f\u0001\u0004A\u0017A\u0003:fg\u0016\u0014h/\u001a&pER1\u0011QFA=\u0003{Bq!a\u001f\r\u0001\u0004\t\u0019$A\u0006q_N\u001c\u0018N\u00197f\u0015>\u0014\u0007BBA\u001e\u0019\u0001\u0007\u0001.A\u0004sKN,'O^3\u0015\r\u0005M\u00121QAC\u0011\u001d\tY(\u0004a\u0001\u0003gAa!a\u000f\u000e\u0001\u0004A\u0017aB2p]\u001aL'/\u001c\u000b\u0007\u0003\u0017\u000b\t*a%\u0011\u0007-\ni)C\u0002\u0002\u00102\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002<9\u0001\r\u0001\u001b\u0005\b\u0003+s\u0001\u0019AAL\u0003\u0015QwNY%e!\rI\u0017\u0011T\u0005\u0004\u00037{(!\u0002&pE&#\u0017AF8gM\u0016\u0014Hk\u001c&pEJ+hN\\3s#V,W/Z:\u0015\t\u00055\u0011\u0011\u0015\u0005\b\u0003#z\u0001\u0019AA\u001a\u0003e\u0011X-\\8wK\u001a\u0013x.\u001c&pEJ+hN\\3s#V,W/Z:\u0015\t\u00055\u0011q\u0015\u0005\b\u0003S\u0003\u0002\u0019AAV\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004\u0002.\u0006M\u00161G\u0007\u0003\u0003_S1!!-c\u0003!1WO\\2uS>t\u0017\u0002BA[\u0003_\u0013\u0011\u0002\u0015:fI&\u001c\u0017\r^3\u0002\rM,(-\\5u)\u0011\ti!a/\t\u000f\u0005E\u0013\u00031\u0001\u00024\u0005q1/\u001e2nSR,\u00050[:uS:<G\u0003BA\u0007\u0003\u0003Dq!!\u0015\u0013\u0001\u0004\t\u0019$A\ttk\nl\u0017\u000e\u001e\"s_\u0006$7-Y:uK\u0012$B!!\u0004\u0002H\"9\u0011\u0011K\nA\u0002\u0005M\u0012a\u0002:fa2\f7-\u001a\u000b\u0005\u0003\u001b\ti\rC\u0004\u0002RQ\u0001\r!a\r\u0002\r\u0019Lg.[:i)\u0011\ti!a5\t\u000f\u0005UU\u00031\u0001\u0002\u0018\u0006A1-\u00198dK2Le\r\u0006\u0003\u0002\u000e\u0005e\u0007bBAU-\u0001\u0007\u00111V\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003\u001b\tAa\u001d;pa\u0006I\u0011n\u001d*v]:Lgn\u001a\u000b\u0003\u0003\u0017\u000bAa]5{KR\u0011\u0011\u0011\u001e\t\u0004W\u0005-\u0018bAAwY\t\u0019\u0011J\u001c;\u0002%I,w-[:uKJTuN\u0019*v]:,'o]\u0001\u0012GJ,\u0017\r^3Sk:tWM])vKV,G\u0003BA\u0007\u0003kDaA\u001e\u000fA\u0002\u0005]\u0011!\u0005:f[>4XMU;o]\u0016\u0014\u0018+^3vKR!\u0011QBA~\u0011\u00191X\u00041\u0001\u0002\u0018\u0005!R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d'j]\u0016$B!!\u0004\u0003\u0002!9\u0011\u0011\u000b\u0010A\u0002\u0005M\u0002f\u0001\u0001\u0003\u0006A!!q\u0001B\u000b\u001b\t\u0011IA\u0003\u0003\u0003\f\t5\u0011AC:uKJ,w\u000e^=qK*!!q\u0002B\t\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001B\n\u0003\ry'oZ\u0005\u0005\u0005/\u0011IAA\u0005D_6\u0004xN\\3oi\"\u001a\u0001Aa\u0007\u0011\t\tu!QE\u0007\u0003\u0005?QA!!\u0012\u0003\")!!1\u0005B\u0007\u0003\u001d\u0019wN\u001c;fqRLAAa\n\u0003 \t9\u0001K]5nCJL\b")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public void registerJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
        this.createRunnerQueue(jobRunner);
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Job possibleJob = (Job)some2.value();
                Job job = possibleJob;
                if (job instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job;
                    return new Some((Object)stopWorkerThread);
                }
                if (job instanceof FailJob) {
                    FailJob failJob = (FailJob)job;
                    return new Some((Object)failJob);
                }
                if (job instanceof TaskJob) {
                    TaskJob taskJob = (TaskJob)job;
                    Option<Job> reservedJob = this.delayOrReserve(taskJob, runnerId);
                    Option<Job> option3 = reservedJob;
                    if (None$.MODULE$.equals(option3)) continue;
                    return option3;
                }
                throw new MatchError((Object)job);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    public Option<Job> delayOrReserve(TaskJob<? extends Task> job, String runnerId) {
        Either<Job, Job> maybeDelayed = JobSchedulerFeature$.MODULE$.strategy().schedule(job);
        Either<Job, Job> either = maybeDelayed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Job delayedTaskJob = (Job)left.value();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replace(delayedTaskJob)).recover((PartialFunction)new Serializable(this, delayedTaskJob){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ CapabilityAwareJobQueue $outer;
                private final Job delayedTaskJob$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.$outer.logger().error((Function0 & Serializable)() -> "Unable to replace job " + $this.delayedTaskJob$1, (Function0 & Serializable)() -> A1);
                    return (B1)BoxedUnit.UNIT;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.delayedTaskJob$1 = delayedTaskJob$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.CapabilityAwareJobQueue$$anonfun$delayOrReserve$2 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            });
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Job job2 = (Job)right.value();
            return this.reserveJob(job2, runnerId);
        }
        throw new MatchError(either);
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        this.jobQueue.finish(jobId);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet());
        this.runnerQueues().put(runner.getId(), runnerQueue);
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

