/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivedReleaseDeserialization;
import com.xebialabs.xlrelease.service.ArchivedReleaseReader;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u0011=w!\u0002$H\u0011\u0003\u0001f!\u0002*H\u0011\u0003\u0019\u0006\"\u00022\u0002\t\u0003\u0019\u0007\"\u00023\u0002\t\u0003)g\u0001\u0002*H\u0001uD!\"a\u0001\u0005\u0005\u000b\u0007I\u0011AA\u0003\u0011)\t\u0019\u0002\u0002B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003+!!\u0011!Q\u0001\n\u0005]\u0001BCA\u000f\t\t\u0005\t\u0015!\u0003\u0002 !Q\u0011Q\u0005\u0003\u0003\u0006\u0004%\t!a\n\t\u0015\u0005eBA!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002<\u0011\u0011\t\u0011)A\u0005\u0003{A!\"a\u0011\u0005\u0005\u0003\u0005\u000b\u0011BA#\u0011)\ty\u0005\u0002B\u0001B\u0003%\u0011\u0011\u000b\u0005\u000b\u0003/\"!\u0011!Q\u0001\n\u0005e\u0003BCA3\t\t\u0005\t\u0015!\u0003\u0002h!Q\u0011Q\u000e\u0003\u0003\u0002\u0003\u0006I!a\u001c\t\u0015\u0005UDA!A!\u0002\u0013\t9\b\u0003\u0006\u0002~\u0011\u0011\t\u0011)A\u0005\u0003\u007fB!\"!\"\u0005\u0005\u0003\u0005\u000b\u0011BAD\u0011\u0019\u0011G\u0001\"\u0001\u0002\u000e\"I\u0011Q\u0019\u0003C\u0002\u0013\u0005\u0011q\u0019\u0005\t\u00033$\u0001\u0015!\u0003\u0002J\"9\u00111\u001c\u0003\u0005\u0002\u0005u\u0007bBA\u007f\t\u0011\u0005\u0011q \u0005\b\u0005\u0017!A\u0011\u0001B\u0007\u0011\u001d\u0011\t\u0003\u0002C\u0005\u0005GAqAa\n\u0005\t\u0013\u0011I\u0003C\u0004\u0003.\u0011!IAa\f\t\u000f\tMB\u0001\"\u0001\u00036!9!\u0011\b\u0003\u0005\n\tm\u0002\"\u0003B$\tE\u0005I\u0011\u0002B%\u0011%\u0011i\u0006BI\u0001\n\u0013\u0011I\u0005C\u0004\u0003`\u0011!IA!\u0019\t\u000f\t\u0015D\u0001\"\u0003\u0003h!9!1\u000e\u0003\u0005\n\t5\u0004b\u0002B:\t\u0011%!Q\u000f\u0005\b\u0005s\"A\u0011\u0002B>\u0011\u001d\u0011y\b\u0002C\u0005\u0005\u0003CqA!\"\u0005\t\u0003\u00119\tC\u0004\u0003\f\u0012!\tA!$\t\u000f\t-E\u0001\"\u0001\u0003\u0012\"9!1\u0014\u0003\u0005\u0002\tu\u0005b\u0002BR\t\u0011\u0005!Q\u0015\u0005\b\u0005g#A\u0011\u0001B[\u0011\u001d\u0011\u0019\r\u0002C\u0001\u0005\u000bDqA!7\u0005\t\u0003\u0011Y\u000eC\u0004\u0003d\u0012!\tA!:\t\u000f\t-H\u0001\"\u0001\u0003n\"9!Q\u001f\u0003\u0005\u0002\t]\bb\u0002B\u0000\t\u0011\u00051\u0011\u0001\u0005\b\u0007\u001b!A\u0011AB\b\u0011\u001d\u0019Y\u0002\u0002C\u0001\u0007;Aqaa\u0007\u0005\t\u0003\u0019I\u0005C\u0004\u0004^\u0011!\taa\u0018\t\u0013\rMF!%A\u0005\u0002\rU\u0006\"CB]\tE\u0005I\u0011AB[\u0011\u001d\u0019Y\f\u0002C\u0001\u0007{Cqaa7\u0005\t\u0003\u0019i\u000eC\u0004\u0004d\u0012!\ta!:\t\u000f\reH\u0001\"\u0001\u0004|\"9A1\u0001\u0003\u0005\u0002\u0011\u0015\u0001b\u0002C\u0006\t\u0011\u0005AQ\u0002\u0005\b\t'!A\u0011\u0001C\u000b\u0011\u001d\u0019Y\u0002\u0002C\u0005\tGAq\u0001b\u000b\u0005\t\u0003!i\u0003C\u0004\u00056\u0011!\t\u0001b\u000e\t\u000f\u0011%C\u0001\"\u0003\u0005L!9A\u0011\u0010\u0003\u0005\n\u0011m\u0004b\u0002CA\t\u0011%A1Q\u0001\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016T!\u0001S%\u0002\u000fM,'O^5dK*\u0011!jS\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001T'\u0002\u0013a,'-[1mC\n\u001c(\"\u0001(\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005E\u000bQ\"A$\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,7cA\u0001U5B\u0011Q\u000bW\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n1\u0011I\\=SK\u001a\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\u000bMdg\r\u000e6\u000b\u0003}\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003Cr\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002!\u0006aq-\u001a;N_:$\b.W3beR\u0011a-\u001d\t\u0003O:t!\u0001\u001b7\u0011\u0005%4V\"\u00016\u000b\u0005-|\u0015A\u0002\u001fs_>$h(\u0003\u0002n-\u00061\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tig\u000bC\u0003s\u0007\u0001\u00071/A\u0005ti\u0006\u0014H\u000fR1uKB\u0011Ao_\u0007\u0002k*\u0011ao^\u0001\u0005i&lWM\u0003\u0002ys\u0006!!n\u001c3b\u0015\u0005Q\u0018aA8sO&\u0011A0\u001e\u0002\t\t\u0006$X\rV5nKN!A\u0001\u0016@[!\t\tv0C\u0002\u0002\u0002\u001d\u0013Q#\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a*fC\u0012,'/\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB%\u0002\u0005\u0011\u0014\u0017\u0002BA\t\u0003\u0017\u0011\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%\u0001\fbe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i!\u0011\tI!!\u0007\n\t\u0005m\u00111\u0002\u0002\u0017\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\u001cV-\u0019:dQ\u0006q\u0012M]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM\u001d\t\u0004#\u0006\u0005\u0012bAA\u0012\u000f\nq\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM]5bY&TXM]\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014XCAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t!B]3q_NLGo\u001c:z\u0015\r\t\u0019dS\u0001\tI\u0016\u0004Hn\\=ji&!\u0011qGA\u0017\u0005E\u0011V\r]8tSR|'/_!eCB$XM]\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b%\u0001\u0010d_6\u0004H.\u001a;fIJ+G.Z1tKN,\u0005\u0010]8siN+'O^5dKB\u0019\u0011+a\u0010\n\u0007\u0005\u0005sIA\u000fD_6\u0004H.\u001a;fIJ+G.Z1tK\u0016C\bo\u001c:u'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u000f\nY%\u0004\u0002\u0002J)\u0019\u0011qF%\n\t\u00055\u0013\u0011\n\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002H\u0005M\u0013\u0002BA+\u0003\u0013\u0012A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0013*\u0001\u0004bGR|'o]\u0005\u0005\u0003G\niFA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0011\t\u0005\u001d\u0013\u0011N\u0005\u0005\u0003W\nIE\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002\u0015M,7-\u001e:fI\u000eK7\u000f\u0005\u0003\u0002H\u0005E\u0014\u0002BA:\u0003\u0013\u0012!bU3dkJ,GmQ5t\u0003m\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011qIA=\u0013\u0011\tY(!\u0013\u00037I+G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z\u0003E\u0019w.\\7f]R\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u000f\n\t)\u0003\u0003\u0002\u0004\u0006%#!E\"p[6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0006Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s!\u0011\t9%!#\n\t\u0005-\u0015\u0011\n\u0002\u001a\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000f\u0006\u000f\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0011\u0005E#\u0001bBA\u0002)\u0001\u0007\u0011q\u0001\u0005\b\u0003+!\u0002\u0019AA\f\u0011\u001d\ti\u0002\u0006a\u0001\u0003?Aq!!\n\u0015\u0001\u0004\tI\u0003C\u0004\u0002<Q\u0001\r!!\u0010\t\u000f\u0005\rC\u00031\u0001\u0002F!9\u0011q\n\u000bA\u0002\u0005E\u0003bBA,)\u0001\u0007\u0011\u0011\f\u0005\b\u0003K\"\u0002\u0019AA4\u0011\u001d\ti\u0007\u0006a\u0001\u0003_Bq!!\u001e\u0015\u0001\u0004\t9\bC\u0004\u0002~Q\u0001\r!a \t\u000f\u0005\u0015E\u00031\u0001\u0002\b\"\u001aA#!,\u0011\t\u0005=\u0016\u0011Y\u0007\u0003\u0003cSA!a-\u00026\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005]\u0016\u0011X\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\tY,!0\u0002\u000b\t,\u0017M\\:\u000b\u0007\u0005}\u00160A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\t\u0019-!-\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!\u0004:fiJLH+Z7qY\u0006$X-\u0006\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017aB:vaB|'\u000f\u001e\u0006\u0005\u0003'\fi,A\u0003sKR\u0014\u00180\u0003\u0003\u0002X\u00065'!\u0004*fiJLH+Z7qY\u0006$X-\u0001\bsKR\u0014\u0018\u0010V3na2\fG/\u001a\u0011\u0002\u001d\u0005\u00148\r[5wKJ+G.Z1tKR!\u0011q\\As!\r)\u0016\u0011]\u0005\u0004\u0003G4&\u0001B+oSRDa!a:\u0018\u0001\u00041\u0017!\u0003:fY\u0016\f7/Z%eQ\r9\u00121\u001e\t\u0005\u0003[\fI0\u0004\u0002\u0002p*!\u00111WAy\u0015\u0011\t\u00190!>\u0002\u000f5,GO]5dg*\u0019\u0011q_'\u0002\u0011\r|G-\u00195bY\u0016LA!a?\u0002p\n)A+[7fI\u00069B-\u001a7fi\u0016\u0004&/Z!sG\"Lg/\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0005\u0003\u00119\u0001E\u0002V\u0005\u0007I1A!\u0002W\u0005\u001d\u0011un\u001c7fC:Da!a:\u0019\u0001\u00041\u0007f\u0001\r\u0002l\u0006\t\u0002O]3Be\u000eD\u0017N^3SK2,\u0017m]3\u0015\t\u0005}'q\u0002\u0005\b\u0005#I\u0002\u0019\u0001B\n\u0003\u001d\u0011X\r\\3bg\u0016\u0004BA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0004\u00053I\u0015A\u00023p[\u0006Lg.\u0003\u0003\u0003\u001e\t]!a\u0002*fY\u0016\f7/\u001a\u0015\u00043\u0005-\u0018\u0001E:fe&\fG.\u001b>f%\u0016dW-Y:f)\r1'Q\u0005\u0005\b\u0005#Q\u0002\u0019\u0001B\n\u0003U\u0019XM]5bY&TX-Q2uSZLG/\u001f'pON$2A\u001aB\u0016\u0011\u001d\u0011\tb\u0007a\u0001\u0005'\ta\u0002\u001e:z%\u0016\fGMU3mK\u0006\u001cX\r\u0006\u0003\u0003\u0014\tE\u0002BBAt9\u0001\u0007a-A\tf]N,(/\u001a)sK\u0006\u00138\r[5wK\u0012$B!a8\u00038!9!\u0011C\u000fA\u0002\tM\u0011a\u00043fG>\u0014\u0018\r^3SK2,\u0017m]3\u0015\u0011\u0005}'Q\bB \u0005\u0007BqA!\u0005\u001f\u0001\u0004\u0011\u0019\u0002C\u0005\u0003By\u0001\n\u00111\u0001\u0003\u0002\u0005aq/\u001b;i\u0007>lW.\u001a8ug\"I!Q\t\u0010\u0011\u0002\u0003\u0007!\u0011A\u0001\u000fo&$\b.\u0012=uK:\u001c\u0018n\u001c8t\u0003e!WmY8sCR,'+\u001a7fCN,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-#\u0006\u0002B\u0001\u0005\u001bZ#Aa\u0014\u0011\t\tE#\u0011L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g3\u0016\u0002\u0002B.\u0005'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e!WmY8sCR,'+\u001a7fCN,G\u0005Z3gCVdG\u000fJ\u001a\u0002%\u0005\u00148\r[5wK\u0006#H/Y2i[\u0016tGo\u001d\u000b\u0005\u0003?\u0014\u0019\u0007C\u0004\u0003\u0012\u0005\u0002\rAa\u0005\u0002'\u0005\u00148\r[5wK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005}'\u0011\u000e\u0005\b\u0005#\u0011\u0003\u0019\u0001B\n\u0003U\t'o\u00195jm\u0016\u0014V\r\\3bg\u0016\fe\u000e\u001a'pON$b!a8\u0003p\tE\u0004BBAtG\u0001\u0007a\rC\u0004\u0003\u0012\r\u0002\rAa\u0005\u0002/\u0005\u00148\r[5wKJ+\u0007o\u001c:uS:<'+Z2pe\u0012\u001cH\u0003BAp\u0005oBqA!\u0005%\u0001\u0004\u0011\u0019\"A\u0007eK2,G/\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0003?\u0014i\b\u0003\u0004\u0002h\u0016\u0002\rAZ\u0001\u000f[\u0006\u00148.Q:Be\u000eD\u0017N^3e)\u0011\tyNa!\t\r\u0005\u001dh\u00051\u0001g\u00035\u0019\bn\\;mI\u0006\u00138\r[5wKR!!\u0011\u0001BE\u0011\u001d\u0011\tb\na\u0001\u0005'\t!bZ3u%\u0016dW-Y:f)\u0011\u0011\u0019Ba$\t\r\u0005\u001d\b\u00061\u0001g)\u0019\u0011\u0019Ba%\u0003\u0016\"1\u0011q]\u0015A\u0002\u0019DqAa&*\u0001\u0004\u0011\t!\u0001\nj]\u000edW\u000fZ3Qe\u0016\f%o\u00195jm\u0016$\u0007fA\u0015\u0002l\u0006yq-\u001a;SK2,\u0017m]3USRdW\rF\u0002g\u0005?Ca!a:+\u0001\u00041\u0007f\u0001\u0016\u0002l\u0006Aq-\u001a;QQ\u0006\u001cX\r\u0006\u0003\u0003(\n5\u0006\u0003\u0002B\u000b\u0005SKAAa+\u0003\u0018\t)\u0001\u000b[1tK\"1!qV\u0016A\u0002\u0019\fq\u0001\u001d5bg\u0016LE\rK\u0002,\u0003W\fqaZ3u)\u0006\u001c8\u000e\u0006\u0003\u00038\nu\u0006\u0003\u0002B\u000b\u0005sKAAa/\u0003\u0018\t!A+Y:l\u0011\u0019\u0011y\f\fa\u0001M\u00061A/Y:l\u0013\u0012D3\u0001LAv\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\t\u001d'1\u001b\t\u0005\u0005\u0013\u0014y-\u0004\u0002\u0003L*!!Q\u001aB\f\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003R\n-'\u0001\u0003,be&\f'\r\\3\t\r\tUW\u00061\u0001g\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0004[\u0005-\u0018AB3ySN$8\u000f\u0006\u0003\u0003\u0002\tu\u0007B\u0002Bp]\u0001\u0007a-\u0001\u0003dS&#\u0007f\u0001\u0018\u0002l\u0006\tR\r_5tiN\u0004&/Z!sG\"Lg/\u001a3\u0015\t\t\u0005!q\u001d\u0005\u0007\u0005?|\u0003\u0019\u00014)\u0007=\nY/\u0001\u0007fq&\u001cHo\u001d\"z\u001d\u0006lW\r\u0006\u0003\u0003\u0002\t=\bB\u0002Bya\u0001\u0007a-A\u0006sK2,\u0017m]3OC6,\u0007f\u0001\u0019\u0002l\u0006\u0001\u0012\r\u001e;bG\"lWM\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0005\u0003\u0011I\u0010\u0003\u0004\u0003|F\u0002\rAZ\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\u0015\u0004c\u0005-\u0018!D4fi\u0006#H/Y2i[\u0016tG\u000f\u0006\u0003\u0004\u0004\r%\u0001\u0003\u0002B\u000b\u0007\u000bIAaa\u0002\u0003\u0018\tQ\u0011\t\u001e;bG\"lWM\u001c;\t\r\tm(\u00071\u0001gQ\r\u0011\u00141^\u0001\u0014O\u0016$\u0018\t\u001e;bG\"lWM\u001c;PaRLwN\u001c\u000b\u0005\u0007#\u00199\u0002E\u0003V\u0007'\u0019\u0019!C\u0002\u0004\u0016Y\u0013aa\u00149uS>t\u0007B\u0002B~g\u0001\u0007a\rK\u00024\u0003W\fab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0003\u0004 \r=\u0002CBB\u0011\u0007W\u0011\u0019\"\u0004\u0002\u0004$)!1QEB\u0014\u0003\u0011)H/\u001b7\u000b\u0005\r%\u0012\u0001\u00026bm\u0006LAa!\f\u0004$\t!A*[:u\u0011\u001d\u0019\t\u0004\u000ea\u0001\u0007g\tqAZ5mi\u0016\u00148\u000f\u0005\u0003\u00046\r\rSBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\u000b\u0019|'/\\:\u000b\t\ru2qH\u0001\u0003mFR1a!\u0011J\u0003\r\t\u0007/[\u0005\u0005\u0007\u000b\u001a9DA\bSK2,\u0017m]3t\r&dG/\u001a:tQ\r!\u00141\u001e\u000b\t\u0007?\u0019Ye!\u0014\u0004X!91\u0011G\u001bA\u0002\rM\u0002bBB(k\u0001\u00071\u0011K\u0001\u0006Y&l\u0017\u000e\u001e\t\u0004+\u000eM\u0013bAB+-\n!Aj\u001c8h\u0011\u001d\u0019I&\u000ea\u0001\u0007#\naa\u001c4gg\u0016$\bfA\u001b\u0002l\u0006\u0011d-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\u0006\u0006\u0004b\r%5qTBV\u0007_\u0003baa\u0019\u0004n\rEd\u0002BB3\u0007Sr1![B4\u0013\u00059\u0016bAB6-\u00069\u0001/Y2lC\u001e,\u0017\u0002BB\u0017\u0007_R1aa\u001bW!\u001d)61OB<\u0007\u0007K1a!\u001eW\u0005\u0019!V\u000f\u001d7feA!1\u0011PB@\u001b\t\u0019YH\u0003\u0003\u0004~\t]\u0011!B;uS2\u001c\u0018\u0002BBA\u0007w\u0012\u0011#\u00113baRLg/\u001a*fY\u0016\f7/Z%e!\r)6QQ\u0005\u0004\u0007\u000f3&aA!os\"91\u0011\u0007\u001cA\u0002\r-\u0005CBB2\u0007\u001b\u001b\t*\u0003\u0003\u0004\u0010\u000e=$aA*fcB!11SBN\u001b\t\u0019)J\u0003\u0003\u00042\r]%bABM\u0013\u00069!/\u001a9peR\u001c\u0018\u0002BBO\u0007+\u0013ABU3q_J$h)\u001b7uKJDqa!)7\u0001\u0004\u0019\u0019+A\u0003pe\u0012,'\u000fE\u0003V\u0007'\u0019)\u000b\u0005\u0003\u00046\r\u001d\u0016\u0002BBU\u0007o\u0011\u0001CU3mK\u0006\u001cXm\u0014:eKJlu\u000eZ3\t\u0013\r=c\u0007%AA\u0002\r5\u0006#B+\u0004\u0014\rE\u0003\"CB-mA\u0005\t\u0019ABWQ\r1\u00141^\u0001=M&tGm\u00155peR\u0014V\r\\3bg\u0016LEm],ji\"4u\u000e\u001c3fe:\u000bW.Z!oI>\u0013H-\u001a:De&$XM]5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u00048*\"1Q\u0016B'\u0003q2\u0017N\u001c3TQ>\u0014HOU3mK\u0006\u001cX-\u00133t/&$\bNR8mI\u0016\u0014h*Y7f\u0003:$wJ\u001d3fe\u000e\u0013\u0018\u000e^3sS>tG\u0005Z3gCVdG\u000f\n\u001b\u0002+\r|WO\u001c;SK2,\u0017m]3t\u0005f\u001cF/\u0019;vgR!1qXBl!\u001d97\u0011YBc\u0007#L1aa1q\u0005\ri\u0015\r\u001d\t\u0005\u0007\u000f\u001ci-\u0004\u0002\u0004J*!11\u001aB\f\u0003\u0019\u0019H/\u0019;vg&!1qZBe\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019Qka5\n\u0007\rUgKA\u0002J]RDqa!\r:\u0001\u0004\u0019\u0019\u0004K\u0002:\u0003W\fQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB`\u0007?Dqa!\r;\u0001\u0004\u0019Y\tK\u0002;\u0003W\f\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u00199o!;\u0004tB)11MBGM\"911^\u001eA\u0002\r5\u0018\u0001\u00023bi\u0016\u0004Ba!\t\u0004p&!1\u0011_B\u0012\u0005\u0011!\u0015\r^3\t\u000f\rU8\b1\u0001\u0004R\u0006A\u0001/Y4f'&TX\rK\u0002<\u0003W\faCZ5oIB+(oZ1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0007O\u001cipa@\t\u000f\r-H\b1\u0001\u0004n\"91Q\u001f\u001fA\u0002\rE\u0007f\u0001\u001f\u0002l\u0006!\u0002/\u001e:hK\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016$B!a8\u0005\b!1\u0011q]\u001fA\u0002\u0019D3!PAv\u0003y\t'o\u00195jm\u0016\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002`\u0012=\u0001BBAt}\u0001\u0007a\rK\u0002?\u0003W\f!bZ3u\u00032dG+Y4t)\u0011!9\u0002\"\b\u0011\u000b\r\u0005B\u0011\u00044\n\t\u0011m11\u0005\u0002\u0004'\u0016$\bb\u0002C\u0010\u007f\u0001\u00071\u0011[\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fK\u0002@\u0003W$\u0002ba\b\u0005&\u0011\u001dB\u0011\u0006\u0005\b\u0007c\u0001\u0005\u0019AB\u001a\u0011\u001d\u0019y\u0005\u0011a\u0001\u0007[Cqa!\u0017A\u0001\u0004\u0019i+\u0001\u000etK\u0006\u00148\r\u001b*fY\u0016\f7/Z:CsJ+G.Z1tK&#7\u000f\u0006\u0003\u00050\u0011E\u0002CBB2\u0007\u001b\u0013\u0019\u0002C\u0004\u00054\u0005\u0003\raa:\u0002\u0015I,G.Z1tK&#7/\u0001\u0012tK\u0006\u00148\r\u001b*fY\u0016\f7/Z:CCNL7-\u0012=u\u0005f\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0005\ts!9\u0005\u0005\u0004\u0004d\r5E1\b\t\u0005\t{!\u0019%\u0004\u0002\u0005@)!A\u0011IA%\u0003\u0015\tX/\u001a:z\u0013\u0011!)\u0005b\u0010\u0003'I+G.Z1tK\n\u000b7/[2ECR\fW\t\u001f;\t\u000f\u0011M\"\t1\u0001\u0004h\u0006qq-\u001a;SK2,\u0017m]3Ji\u0016lW\u0003\u0002C'\t/\"B\u0001b\u0014\u0005vQ!A\u0011\u000bC5!\u0015)61\u0003C*!\u0011!)\u0006b\u0016\r\u0001\u00119A\u0011L\"C\u0002\u0011m#!\u0001+\u0012\t\u0011uC1\r\t\u0004+\u0012}\u0013b\u0001C1-\n9aj\u001c;iS:<\u0007\u0003\u0002B\u000b\tKJA\u0001b\u001a\u0003\u0018\tA\u0001\u000b\\1o\u0013R,W\u000eC\u0004\u0005l\r\u0003\r\u0001\"\u001c\u0002\u000f\u001d,G/\u0013;f[B9Q\u000bb\u001c\u0003\u0014\u0011M\u0014b\u0001C9-\nIa)\u001e8di&|g.\r\t\u0007+\u0012=d\rb\u0015\t\r\u0011]4\t1\u0001g\u0003\u0019IG/Z7JI\u0006\tr-\u001a;WCJL\u0017M\u00197f\u001fB$\u0018n\u001c8\u0015\t\u0011uDq\u0010\t\u0006+\u000eM!q\u0019\u0005\u0007\u0005+$\u0005\u0019\u00014\u0002=\u0005\u00148\r[5wK\u0006cGnT;uO>Lgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BAp\t\u000bCqA!\u0005F\u0001\u0004\u0011\u0019\u0002K\n\u0005\t\u0013#9\n\"'\u0005\u001e\u0012}E\u0011\u0016CV\tk#9\f\u0005\u0003\u0005\f\u0012MUB\u0001CG\u0015\u0011\t\u0019\fb$\u000b\t\u0011E\u0015QX\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0005\u0016\u00125%!\u0004+sC:\u001c\u0018m\u0019;j_:\fG.A\u0003wC2,X-\t\u0002\u0005\u001c\u0006Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\f1\u0002\u001d:pa\u0006<\u0017\r^5p]\u0012\u0012A\u0011U\u0005\u0005\tG#)+\u0001\u0005S\u000bF+\u0016JU#E\u0015\u0011!9\u000b\"$\u0002\u0017A\u0013x\u000e]1hCRLwN\\\u0001\nSN|G.\u0019;j_:$#\u0001\",\n\t\u0011=F\u0011W\u0001\u000f%\u0016\u000bEiX\"P\u001b6KE\u000bV#E\u0015\u0011!\u0019\f\"$\u0002\u0013%\u001bx\u000e\\1uS>t\u0017a\u0003:pY2\u0014\u0017mY6G_Jd#\u0001\"/$\u0005\u0011m\u0006\u0003BB2\t{KA\u0001b0\u0004p\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0015\u0004\t\u0011\r\u0007\u0003\u0002Cc\t\u0017l!\u0001b2\u000b\t\u0011%\u0017QX\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002Cg\t\u000f\u0014qaU3sm&\u001cW\r")
public class ArchivingService
implements ArchivedReleaseReader {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentRepository commentRepository;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final RetryTemplate retryTemplate;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime startDate) {
        return ArchivingService$.MODULE$.getMonthYear(startDate);
    }

    @Override
    public Option<Release> getReleaseOption(String releaseId, boolean includePreArchived, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseReader.getReleaseOption$(this, releaseId, includePreArchived, ciConverter);
    }

    @Override
    public boolean getReleaseOption$default$2() {
        return ArchivedReleaseReader.getReleaseOption$default$2$(this);
    }

    @Override
    public ConfigurationItemConverter getReleaseOption$default$3() {
        return ArchivedReleaseReader.getReleaseOption$default$3$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeArchivedRelease(String releaseJson, RepositoryAdapter repository, ConfigurationItemConverter ciConverter) {
        return ArchivedReleaseDeserialization.deserializeArchivedRelease$(this, releaseJson, repository, ciConverter);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public RepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public RetryTemplate retryTemplate() {
        return this.retryTemplate;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = this.tryReadRelease(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> "Release [" + releaseId + "] cannot be read from active database, proceeding to archive release and remove from active database");
            this.deleteRelease(releaseId);
            this.markAsArchived(releaseId);
            return;
        }
        if (!this.shouldArchive(release)) {
            this.logger().debug((Function0 & Serializable)() -> "Removing non archive-able release [" + releaseId + "] from active database");
            this.deleteRelease(releaseId);
            return;
        }
        if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            this.logger().warn((Function0 & Serializable)() -> "Received request to archive release [" + releaseId + "] with invalid status [" + release.getStatus() + "], proceeding to archive release and remove from active database");
            release.abort("Aborting release due to invalid status " + release.getStatus() + " on archival");
            this.archiveAttachments(release);
            this.archiveDependencies(release);
            this.deleteRelease(releaseId);
            this.markAsArchived(releaseId);
            return;
        }
        this.ensurePreArchived(release);
        this.decorateRelease(release, this.decorateRelease$default$2(), this.decorateRelease$default$3());
        this.archiveAttachments(release);
        this.archiveDependencies(release);
        this.archiveReleaseAndLogs(releaseId, release);
        this.deleteRelease(releaseId);
        this.markAsArchived(releaseId);
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> "Release [" + release.getId() + "] is already pre-archived, nothing to do");
            return;
        }
        this.decorateRelease(release, false, false);
        String serializedRelease = this.serializeRelease(release);
        if (this.shouldArchive(release)) {
            this.logger().debug((Function0 & Serializable)() -> "Copying release [" + release.getId() + "] to archive database, marking as pre-archived");
            this.archivedReleases().insert(release, serializedRelease, "", true);
            this.archiveReportingRecords(release);
            this.releaseRepository.setPreArchived(release.getId(), true);
        }
        this.logger().debug((Function0 & Serializable)() -> "Running release [" + release.getId() + "] through export hooks");
        this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
    }

    private String serializeRelease(Release release) {
        String string;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter()));
        if (try_ instanceof Success) {
            String serialized;
            Success success = (Success)try_;
            string = serialized = (String)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to serialize " + release + ", continuing without original JSON", (Function0 & Serializable)() -> e);
            string = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)ReleaseBuilder.newRelease().withId(release.getId()).withTitle(release.getTitle()).withStartDate(release.getStartDate()).withEndDate(release.getEndDate()).withStatus(release.getStatus()).withDescription("Non-recoverable exception serializing release: " + e.getMessage()).build());
        } else {
            throw new MatchError((Object)try_);
        }
        String releaseJson = string;
        return releaseJson;
    }

    private String serializeActivityLogs(Release release) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String activityLogsJson = (String)success.value();
            return activityLogsJson;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable to serialize activity logs of " + release + ", continuing without logs", (Function0 & Serializable)() -> e);
            return "";
        }
        throw new MatchError((Object)try_);
    }

    private Release tryReadRelease(String releaseId) {
        return (Release)Try$.MODULE$.apply((Function0 & Serializable)() -> (Release)this.repositoryAdapter().read(releaseId)).recover((PartialFunction)new Serializable(this, releaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingService $outer;
            private final String releaseId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to read release [" + $this.releaseId$2 + "] from active database", (Function0 & Serializable)() -> A12);
                    return null;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$2 = releaseId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingService$$anonfun$tryReadRelease$2 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        }).get();
    }

    public void ensurePreArchived(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Checking release [" + release.getId() + "] is pre-archived");
        try {
            this.preArchiveRelease(release);
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to pre-archive " + release + ", proceeding to archive release", (Function0 & Serializable)() -> e);
        }
    }

    private void decorateRelease(Release release, boolean withComments, boolean withExtensions) {
        this.logger().debug((Function0 & Serializable)() -> "Decorating release [" + release.getId() + "]");
        try {
            Object object = withExtensions ? this.releaseExtensionsRepository.decorate(release) : BoxedUnit.UNIT;
            Object object2 = withComments ? this.commentRepository.decorate(release) : BoxedUnit.UNIT;
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$decorateRelease$3(task, x$1)))).asJava()));
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to decorate " + release + ", proceeding to archive release as-is", (Function0 & Serializable)() -> e);
        }
    }

    private boolean decorateRelease$default$2() {
        return true;
    }

    private boolean decorateRelease$default$3() {
        return true;
    }

    private void archiveAttachments(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Archiving attachments for [" + release.getId() + "]");
        Option previousWorkDirContext = Option$.MODULE$.apply((Object)WorkDirContext.get());
        WorkDirContext.initWorkdir();
        try {
            try {
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
                    ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to archive attachments of " + release, (Function0 & Serializable)() -> e);
            }
        }
        finally {
            Option$.MODULE$.apply((Object)WorkDirContext.get()).foreach((Function1 & Serializable)x$2 -> {
                x$2.delete();
                return BoxedUnit.UNIT;
            });
            WorkDirContext.clear();
            previousWorkDirContext.foreach((Function1 & Serializable)x$1 -> {
                ArchivingService.$anonfun$archiveAttachments$8(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void archiveDependencies(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Archiving dependencies for [" + release.getId() + "]");
        try {
            this.retryTemplate().execute(context -> {
                ArchivingService.$anonfun$archiveDependencies$2(this, release, context);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to archive dependencies of " + release, (Function0 & Serializable)() -> e);
        }
    }

    private void archiveReleaseAndLogs(String releaseId, Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Archiving activity logs and release JSON for [" + releaseId + "]");
        String releaseJson = this.serializeRelease(release);
        String activityLogsJson = this.serializeActivityLogs(release);
        try {
            if (!this.archivedReleases().update(releaseId, releaseJson, activityLogsJson)) {
                this.logger().warn((Function0 & Serializable)() -> "Could not update archived release JSON [" + releaseId + "]");
            }
            this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(release.getTeams()).asScala().toSeq());
        }
        catch (Throwable e) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to update " + release + " in archive", (Function0 & Serializable)() -> e);
        }
    }

    private void archiveReportingRecords(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Archiving reporting records for [" + release.getId() + "]");
        scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
        ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveReportingRecords$2(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet)).recover((PartialFunction)new Serializable(this, (Facet)liveFacet){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingService $outer;
            private final Facet liveFacet$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.logger().warn((Function0 & Serializable)() -> "Unable to pre-archive reporting record [" + $this.liveFacet$1.getId() + "]", (Function0 & Serializable)() -> A12);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.liveFacet$1 = liveFacet$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(com.xebialabs.xlrelease.service.ArchivingService$$anonfun$$nestedInanonfun$archiveReportingRecords$4$1 ), $anonfun$applyOrElse$4(java.lang.Throwable )}, serializedLambda);
            }
        }));
    }

    private void deleteRelease(String releaseId) {
        if (this.releaseRepository.exists(releaseId)) {
            this.logger().debug((Function0 & Serializable)() -> "Deleting [" + releaseId + "] from active database");
            this.releaseRepository.delete(releaseId, false);
            return;
        }
    }

    private void markAsArchived(String releaseId) {
        this.archivedReleases().setPreArchived(releaseId, false);
    }

    public boolean shouldArchive(Release release) {
        return !release.isTutorial() && release.isArchiveRelease();
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived, this.getReleaseOption$default$3()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived release [" + releaseId + "]", new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived release [" + releaseId + "]", new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$3 -> (Function1 & Serializable)x$1 -> x$3.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived release [" + Ids.releaseIdFrom((String)phaseId) + "]", new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived release [" + Ids.releaseIdFrom((String)taskId) + "]", new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived release [" + Ids.releaseIdFrom((String)variableId) + "]", new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        if (Ids.isReleaseId((String)ciId)) {
            return this.archivedReleases().exists(ciId);
        }
        if (Ids.isPhaseId((String)ciId)) {
            return this.getReleaseItem(ciId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getPhase(x$1)).isDefined();
        }
        if (Ids.isTaskId((String)ciId)) {
            return this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getTask(x$1)).isDefined();
        }
        if (Ids.isVariableId((String)ciId)) {
            return this.getVariableOption(ciId).isDefined();
        }
        return false;
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        if (Ids.isReleaseId((String)ciId)) {
            return this.archivedReleases().existsPreArchived(ciId);
        }
        return false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find archived attachment [" + attachmentId + "]", new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, pageSize);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findPurgableReleaseIds(Date date, int pageSize) {
        return this.archivedReleases().findPurgableReleaseIds(date, pageSize);
    }

    @Timed
    public void purgeArchivedRelease(String releaseId) {
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)new .colon.colon((Object)releaseId, (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> this.deserializeArchivedRelease((String)json, this.repositoryAdapter(), CiSerializerHelper$.MODULE$.newEncryptingConverter()));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$8 -> FullReleaseId$.MODULE$.apply((String)x$8).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2(), this.getReleaseOption$default$3()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$9))));
    }

    private void archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10.getDependencies()).asScala())).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$11)));
        dependencies.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$decorateRelease$3(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$7, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$7.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$7, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$7, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$8(WorkDir x$1) {
        WorkDirContext.setWorkDir((WorkDir)x$1);
    }

    public static final /* synthetic */ void $anonfun$archiveDependencies$2(ArchivingService $this, Release release$8, RetryContext context) {
        if (context.getRetryCount() > 0) {
            $this.logger().warn((Function0 & Serializable)() -> "Retrying archival of dependencies for [" + release$8.getId() + "]. Error: " + context.getLastThrowable() + ".");
        }
        $this.archiveAllOutgoingDependencies(release$8);
        $this.archiveAllIncomingDependencies(release$8.getId());
    }

    public static final /* synthetic */ boolean $anonfun$archiveReportingRecords$2(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String referencingReleaseId = (String)tuple2._1();
            scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
            $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$7 -> x$7.getId())));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$9) {
        String string = x$9.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$11) {
        return !x$11.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentRepository commentRepository, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentRepository = commentRepository;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        ArchivedReleaseDeserialization.$init$(this);
        Logging.$init$((Logging)this);
        ArchivedReleaseReader.$init$(this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
        this.retryTemplate = new RetryTemplateBuilder().fixedBackoff(30000L).maxAttempts(5).build();
    }
}

