/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.v1.CategoryApi;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CategoryForm;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CategoryService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\u0005\n\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)\u0011\u0007\u0001C\u0001e!)q\u0007\u0001C!q!)q\r\u0001C!Q\")!\u000f\u0001C!g\")A\u0010\u0001C!{\ny1)\u0019;fO>\u0014\u00180\u00119j\u00136\u0004HN\u0003\u0002\u000b\u0017\u0005!\u0011.\u001c9m\u0015\taQ\"\u0001\u0002wc)\u0011abD\u0001\u0004CBL'B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u0010\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1qJ\u00196fGR\u0004\"\u0001I\u0011\u000e\u0003-I!AI\u0006\u0003\u0017\r\u000bG/Z4pef\f\u0005/[\u0001\u0010G\u0006$XmZ8ssN+'O^5dKB\u0011Q\u0005K\u0007\u0002M)\u0011qeD\u0001\bg\u0016\u0014h/[2f\u0013\tIcEA\bDCR,wm\u001c:z'\u0016\u0014h/[2f\u0003-\u0001XM]7jgNLwN\\:\u0011\u00051zS\"A\u0017\u000b\u00059z\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005Aj#!\u0005)fe6L7o]5p]\u000eCWmY6fe\u00061A(\u001b8jiz\"2aM\u001b7!\t!\u0004!D\u0001\n\u0011\u0015\u00193\u00011\u0001%\u0011\u0015Q3\u00011\u0001,\u0003Q\u0019X-\u0019:dQ\u000e\u000bG/Z4pe&,7\u000fU1hKR!\u0011H\u0013*[!\rQ4)R\u0007\u0002w)\u0011A(P\u0001\u0007I>l\u0017-\u001b8\u000b\u0005yz\u0014\u0001\u00023bi\u0006T!\u0001Q!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AQ\u0001\u0004_J<\u0017B\u0001#<\u0005\u0011\u0001\u0016mZ3\u0011\u0005\u0019CU\"A$\u000b\u0005qz\u0011BA%H\u0005!\u0019\u0015\r^3h_JL\b\"B&\u0005\u0001\u0004a\u0015aD2bi\u0016<wN]=GS2$XM]:\u0011\u00055\u0003V\"\u0001(\u000b\u0005=[\u0011A\u00024jYR,'/\u0003\u0002R\u001d\ny1)\u0019;fO>\u0014\u0018PR5mi\u0016\u00148\u000fC\u0003T\t\u0001\u0007A+\u0001\u0003qC\u001e,\u0007CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&aA%oi\")1\f\u0002a\u0001)\u0006q!/Z:vYR\u001c\b+\u001a:QC\u001e,\u0007F\u0001\u0003^!\tqV-D\u0001`\u0015\t\u0001\u0017-\u0001\u0006b]:|G/\u0019;j_:T!AY2\u0002\u000f5,GO]5dg*\u0011AmE\u0001\tG>$\u0017\r[1mK&\u0011am\u0018\u0002\u0006)&lW\rZ\u0001\fC\u0012$7)\u0019;fO>\u0014\u0018\u0010\u0006\u0002FS\")!.\u0002a\u0001W\u0006a1-\u0019;fO>\u0014\u0018PR8s[B\u0011An\\\u0007\u0002[*\u0011anC\u0001\u0006M>\u0014Xn]\u0005\u0003a6\u0014AbQ1uK\u001e|'/\u001f$pe6D#!B/\u0002\u001dU\u0004H-\u0019;f\u0007\u0006$XmZ8ssR\u0019Q\t^=\t\u000bU4\u0001\u0019\u0001<\u0002\u000b\rLW+\u001b3\u0011\u0005a9\u0018B\u0001=\u001a\u0005\u001dIe\u000e^3hKJDQA\u001f\u0004A\u0002\u0015\u000b\u0001bY1uK\u001e|'/\u001f\u0015\u0003\ru\u000ba\u0002Z3mKR,7)\u0019;fO>\u0014\u0018\u0010F\u0002\u007f\u0003\u0007\u0001\"!V@\n\u0007\u0005\u0005aK\u0001\u0003V]&$\b\"B;\b\u0001\u00041\bFA\u0004^Q\r\u0001\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB \u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u0014\u00055!AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class CategoryApiImpl
implements CategoryApi {
    private final CategoryService categoryService;
    private final PermissionChecker permissions;

    public String serviceName() {
        return super.serviceName();
    }

    @PublicApiMember
    public List<Category> searchCategories(CategoryFilters x$1, int x$2, int x$3) {
        return super.searchCategories(x$1, x$2, x$3);
    }

    @Timed
    public Page<Category> searchCategoriesPage(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{BoxesRunTime.boxToLong((long)100L)});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.categoryService.findBy(categoryFilters, (Pageable)pageable);
    }

    @Timed
    public Category addCategory(CategoryForm categoryForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Category category = new Category(categoryForm.getTitle(), categoryForm.isActive());
        return this.categoryService.create(category);
    }

    @Timed
    public Category updateCategory(Integer ciUid, Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        category.setCiUid(ciUid);
        return this.categoryService.update(category);
    }

    @Timed
    public void deleteCategory(Integer ciUid) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.categoryService.delete(Predef$.MODULE$.Integer2int(ciUid));
    }

    public CategoryApiImpl(CategoryService categoryService, PermissionChecker permissions) {
        this.categoryService = categoryService;
        this.permissions = permissions;
    }
}

