/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.v1.CategoryApi;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CategoryForm;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CategoryService;
import com.xebialabs.xlrelease.view.CategoryView;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0005\u000b\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C!s!)\u0011\u000e\u0001C!U\")\u0011\u000e\u0001C!s\")Q\u0010\u0001C!}\"9\u0011Q\u0002\u0001\u0005B\u0005=!aD\"bi\u0016<wN]=Ba&LU\u000e\u001d7\u000b\u0005-a\u0011\u0001B5na2T!!\u0004\b\u0002\u0005Y\f$BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011c\u0001\u0001\u0019AA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB(cU\u0016\u001cG\u000f\u0005\u0002\"E5\tA\"\u0003\u0002$\u0019\tY1)\u0019;fO>\u0014\u00180\u00119j\u0003=\u0019\u0017\r^3h_JL8+\u001a:wS\u000e,\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0011\u0003\u001d\u0019XM\u001d<jG\u0016L!AK\u0014\u0003\u001f\r\u000bG/Z4pef\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006E\u0001\tg\u0016\u001cWO]5us&\u0011\u0011G\f\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u0003)AQ\u0001J\u0002A\u0002\u0015BQaK\u0002A\u00021\nAc]3be\u000eD7)\u0019;fO>\u0014\u0018.Z:QC\u001e,G\u0003\u0002\u001eM)r\u00032a\u000f#G\u001b\u0005a$BA\u001f?\u0003\u0019!w.\\1j]*\u0011q\bQ\u0001\u0005I\u0006$\u0018M\u0003\u0002B\u0005\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012A\u0001U1hKB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nE\u0001\u0005m&,w/\u0003\u0002L\u0011\na1)\u0019;fO>\u0014\u0018PV5fo\")Q\n\u0002a\u0001\u001d\u0006y1-\u0019;fO>\u0014\u0018PR5mi\u0016\u00148\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0019\u00051a-\u001b7uKJL!a\u0015)\u0003\u001f\r\u000bG/Z4pef4\u0015\u000e\u001c;feNDQ!\u0016\u0003A\u0002Y\u000bA\u0001]1hKB\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n\u0019\u0011J\u001c;\t\u000bu#\u0001\u0019\u0001,\u0002\u001dI,7/\u001e7ugB+'\u000fU1hK\"\u0012Aa\u0018\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\f!\"\u00198o_R\fG/[8o\u0015\t!W-A\u0004nKR\u0014\u0018nY:\u000b\u0005\u0019$\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005!\f'!\u0002+j[\u0016$\u0017aC1eI\u000e\u000bG/Z4pef$\"a\u001b9\u0011\u00051tW\"A7\u000b\u0005u\u0002\u0012BA8n\u0005!\u0019\u0015\r^3h_JL\b\"B9\u0006\u0001\u0004\u0011\u0018\u0001D2bi\u0016<wN]=G_Jl\u0007CA:w\u001b\u0005!(BA;\r\u0003\u00151wN]7t\u0013\t9HO\u0001\u0007DCR,wm\u001c:z\r>\u0014X\u000e\u000b\u0002\u0006?R\u00111N\u001f\u0005\u0006w\u001a\u0001\ra[\u0001\tG\u0006$XmZ8ss\"\u0012aaX\u0001\u000fkB$\u0017\r^3DCR,wm\u001c:z)\u0011Yw0!\u0003\t\u000f\u0005\u0005q\u00011\u0001\u0002\u0004\u0005)1-[+jIB\u0019\u0011$!\u0002\n\u0007\u0005\u001d!DA\u0004J]R,w-\u001a:\t\u000bm<\u0001\u0019A6)\u0005\u001dy\u0016A\u00043fY\u0016$XmQ1uK\u001e|'/\u001f\u000b\u0005\u0003#\t9\u0002E\u0002X\u0003'I1!!\u0006Y\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005\u0001\u00021\u0001\u0002\u0004!\u0012\u0001b\u0018\u0015\u0004\u0001\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0002)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\n\u0002\"\tQ1i\u001c8ue>dG.\u001a:")
public class CategoryApiImpl
implements CategoryApi {
    private final CategoryService categoryService;
    private final PermissionChecker permissions;

    public String serviceName() {
        return super.serviceName();
    }

    @PublicApiMember
    public List<CategoryView> searchCategories(CategoryFilters x$1, int x$2, int x$3) {
        return super.searchCategories(x$1, x$2, x$3);
    }

    @Timed
    public Page<CategoryView> searchCategoriesPage(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{BoxesRunTime.boxToLong((long)100L)});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.categoryService.findBy(categoryFilters, (Pageable)pageable);
    }

    @Timed
    public Category addCategory(CategoryForm categoryForm) {
        Category category = new Category(categoryForm.getTitle(), categoryForm.isActive());
        return this.addCategory(category);
    }

    @Timed
    public Category addCategory(Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.categoryService.create(category);
    }

    @Timed
    public Category updateCategory(Integer ciUid, Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        category.setCiUid(ciUid);
        return this.categoryService.update(category);
    }

    @Timed
    public void deleteCategory(Integer ciUid) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.categoryService.delete(Predef$.MODULE$.Integer2int(ciUid));
    }

    public CategoryApiImpl(CategoryService categoryService, PermissionChecker permissions) {
        this.categoryService = categoryService;
        this.permissions = permissions;
    }
}

