/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.license;

import com.xebialabs.license.DummyLicense;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseUtils;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.license.XLRLicenseInstallService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\u0006\f\u0001QA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)\u0001\u0007\u0001C\u0001c!9A\t\u0001b\u0001\n\u0003)\u0005B\u0002)\u0001A\u0003%a\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003W\u0001\u0011%q\u000bC\u0003b\u0001\u0011%!\rC\u0003l\u0001\u0011%ANA\u0010MS\u000e,gn]3E\u0005NKhnY%oSRL\u0017\r\\5{KJ\u001cVM\u001d<jG\u0016T!\u0001D\u0007\u0002\u000f1L7-\u001a8tK*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tQa\u001d7gi)T\u0011\u0001I\u0001\tOJL'P\u001f7fI&\u0011!%\b\u0002\b\u0019><w-\u001b8h\u0003Ua\u0017nY3og\u0016Len\u001d;bY2\u001cVM\u001d<jG\u0016\u0004\"!\n\u0014\u000e\u0003-I!aJ\u0006\u00031ac%\u000bT5dK:\u001cX-\u00138ti\u0006dGnU3sm&\u001cW-\u0001\bmS\u000e,gn]3TKJ4\u0018nY3\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013aB:feZL7-\u001a\u0006\u0003\u0019=I!aL\u0016\u0003\u001d1K7-\u001a8tKN+'O^5dK\u00061A(\u001b8jiz\"2AM\u001a5!\t)\u0003\u0001C\u0003$\u0007\u0001\u0007A\u0005C\u0003)\u0007\u0001\u0007\u0011\u0006\u000b\u0002\u0004mA\u0011qGQ\u0007\u0002q)\u0011\u0011HO\u0001\u000bC:tw\u000e^1uS>t'BA\u001e=\u0003\u001d1\u0017m\u0019;pefT!!\u0010 \u0002\u000b\t,\u0017M\\:\u000b\u0005}\u0002\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019\u0005HA\u0005BkR|w/\u001b:fI\u0006)B*S\"F\u001dN+uLR%M\u000b~+ejQ(E\u0013:;U#\u0001$\u0011\u0005\u001dsU\"\u0001%\u000b\u0005%S\u0015aB2iCJ\u001cX\r\u001e\u0006\u0003\u00172\u000b1A\\5p\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014%\u0003\u000f\rC\u0017M]:fi\u00061B*S\"F\u001dN+uLR%M\u000b~+ejQ(E\u0013:;\u0005%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012a\u0015\t\u0003-QK!!V\f\u0003\tUs\u0017\u000e^\u0001\u001dO\u0016$H*[2f]N,gI]8n\u001b\u0016lwN]=JM\u0016C\u0018n\u001d;t+\u0005A\u0006c\u0001\fZ7&\u0011!l\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q{V\"A/\u000b\u0005yc\u0015\u0001\u00027b]\u001eL!\u0001Y/\u0003\rM#(/\u001b8h\u0003=\u0011X-\u00193MS\u000e,gn]3GS2,GCA.d\u0011\u0015!\u0007\u00021\u0001f\u0003-a\u0017nY3og\u00164\u0015\u000e\\3\u0011\u0005\u0019LW\"A4\u000b\u0005!d\u0015AA5p\u0013\tQwM\u0001\u0003GS2,\u0017\u0001\u0005:fC\u00124\u0015\u000e\\3U_N#(/\u001b8h)\tYV\u000eC\u0003o\u0013\u0001\u0007Q-\u0001\u0003gS2,\u0007fA\u0005qmB\u0019a#]:\n\u0005I<\"A\u0002;ie><8\u000f\u0005\u0002gi&\u0011Qo\u001a\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001fo\u0006\r\u0011Q\u0007\t\u0003q~t!!_?\u0011\u0005i<R\"A>\u000b\u0005q\u001c\u0012A\u0002\u001fs_>$h(\u0003\u0002\u007f/\u00051\u0001K]3eK\u001aL1\u0001YA\u0001\u0015\tqx#M\u0005$\u0003\u000b\ti!a\u000b\u0002\u0010U!\u0011qAA\u0005+\u00059HaBA\u0006'\t\u0007\u0011Q\u0003\u0002\u0002)&!\u0011qBA\t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111C\f\u0002\rQD'o\\<t#\u0011\t9\"!\b\u0011\u0007Y\tI\"C\u0002\u0002\u001c]\u0011qAT8uQ&tw\r\u0005\u0003\u0002 \u0005\u0015bb\u0001\f\u0002\"%\u0019\u00111E\f\u0002\u000fA\f7m[1hK&!\u0011qEA\u0015\u0005%!\u0006N]8xC\ndWMC\u0002\u0002$]\t\u0014bIA\u0017\u0003_\t\t$a\u0005\u000f\u0007Y\ty#C\u0002\u0002\u0014]\tTA\t\f\u0018\u0003g\u0011Qa]2bY\u0006\f$AJ:)\u0007\u0001\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDP\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\"\u0003{\u0011\u0011bQ8na>tWM\u001c;")
public class LicenseDBSyncInitializerService
implements Logging {
    private final XLRLicenseInstallService licenseInstallService;
    private final LicenseService licenseService;
    private final Charset LICENSE_FILE_ENCODING;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LicenseDBSyncInitializerService licenseDBSyncInitializerService = this;
        synchronized (licenseDBSyncInitializerService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Charset LICENSE_FILE_ENCODING() {
        return this.LICENSE_FILE_ENCODING;
    }

    public void initialize() {
        this.logger().trace((Function0 & Serializable)() -> "Initializing license DB sync");
        Option<String> option = this.getLicenseFromMemoryIfExists();
        if (option instanceof Some) {
            Some some = (Some)option;
            String memoryLicenseContent = (String)some.value();
            this.logger().trace((Function0 & Serializable)() -> "License exists on node's filesystem. Storing the license in DB...");
            this.licenseInstallService.storeInDB(memoryLicenseContent);
            this.licenseInstallService.broadcastLicenseRenewal();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Option<String> option2 = this.licenseInstallService.findLicenseInDB();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String dbLicenseContent = (String)some.value();
                this.logger().trace((Function0 & Serializable)() -> "License doesn't exist on node's filesystem. Pulling the existing license from DB...");
                this.licenseInstallService.install(dbLicenseContent);
            } else if (None$.MODULE$.equals(option2)) {
                this.logger().trace((Function0 & Serializable)() -> "License doesn't exist in DB and isn't installed in node's memory. Doing nothing");
            } else {
                throw new MatchError(option2);
            }
            return;
        }
        throw new MatchError(option);
    }

    private Option<String> getLicenseFromMemoryIfExists() {
        License inMemoryLicense = this.licenseService.getLicense();
        if (inMemoryLicense != null && !(inMemoryLicense instanceof DummyLicense)) {
            File licenseFile = new File(XlrConfig$.MODULE$.getInstance().license_location());
            String licenseContent = this.readLicenseFile(licenseFile);
            return new Some((Object)licenseContent);
        }
        return None$.MODULE$;
    }

    private String readLicenseFile(File licenseFile) {
        String string;
        try {
            String data = this.readFileToString(licenseFile);
            string = LicenseUtils.decodeIfNecessary((String)data);
        }
        catch (IOException e) {
            throw new LicenseParseException(String.format("Unable to read license file '%s'", licenseFile), (Throwable)e);
        }
        return string;
    }

    private String readFileToString(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), this.LICENSE_FILE_ENCODING()).replaceAll("\\r\\n?", "\n");
    }

    @Autowired
    public LicenseDBSyncInitializerService(XLRLicenseInstallService licenseInstallService, LicenseService licenseService) {
        this.licenseInstallService = licenseInstallService;
        this.licenseService = licenseService;
        Logging.$init$((Logging)this);
        this.LICENSE_FILE_ENCODING = StandardCharsets.UTF_8;
    }
}

