/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\u0007\u000f\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\u0007\u0001C\u0001k!)!\b\u0001C\u0001w!)a\r\u0001C\u0001O\")a\u000e\u0001C\u0001_\")!\u000f\u0001C\u0001g\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0013\u0001\t\u0013\tYE\u0001\tVg\u0016\u0014Hk\\6f]N+'O^5dK*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#A\u0005yYJ,G.Z1tK*\u00111\u0003F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!F\u0001\u0004G>l7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\t\u0002\r\u00154XM\u001c;t\u0013\ta\u0013F\u0001\u0005Fm\u0016tGOQ;t\u0003M)8/\u001a:U_.,gNU3q_NLGo\u001c:z!\ty#'D\u00011\u0015\t\t\u0004#\u0001\u0006sKB|7/\u001b;pefL!a\r\u0019\u0003'U\u001bXM\u001d+pW\u0016t'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\r1\u0004(\u000f\t\u0003o\u0001i\u0011A\u0004\u0005\u0006M\r\u0001\ra\n\u0005\u0006[\r\u0001\rAL\u0001\u0010GJ,\u0017\r^3Vg\u0016\u0014Hk\\6f]R!AHQ(R!\ti\u0004)D\u0001?\u0015\ty\u0004#\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u0003z\u0012\u0011\"V:feR{7.\u001a8\t\u000b\r#\u0001\u0019\u0001#\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$\u001b\u001b\u0005A%BA%\u0017\u0003\u0019a$o\\8u}%\u00111JG\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L5!)\u0001\u000b\u0002a\u0001\t\u0006IAo\\6f]:{G/\u001a\u0005\u0006%\u0012\u0001\raU\u0001\u000bKb\u0004\u0018N]=ECR,\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011)H/\u001b7\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0005\t\u0006$X\r\u000b\u0002\u00059B\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u000bC:tw\u000e^1uS>t'BA1c\u0003\u001diW\r\u001e:jGNT!a\u0019\u000b\u0002\u0011\r|G-\u00195bY\u0016L!!\u001a0\u0003\u000bQKW.\u001a3\u0002\u001f\u0011,G.\u001a;f+N,'\u000fV8lK:$\"\u0001[6\u0011\u0005eI\u0017B\u00016\u001b\u0005\u0011)f.\u001b;\t\u000b1,\u0001\u0019\u0001\u001f\u0002\u0013U\u001cXM\u001d+pW\u0016t\u0007FA\u0003]\u0003I!W\r\\3uK\u0006cG.V:feR{7.\u001a8\u0015\u0005!\u0004\b\"B\"\u0007\u0001\u0004!\u0005F\u0001\u0004]\u0003\u00111\u0017N\u001c3\u0015\tQ|\u0018\u0011\u0001\t\u0004kvdT\"\u0001<\u000b\u0005}:(B\u0001=z\u0003\u0011!\u0017\r^1\u000b\u0005i\\\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003q\f1a\u001c:h\u0013\tqhO\u0001\u0003QC\u001e,\u0007\"B\"\b\u0001\u0004!\u0005bBA\u0002\u000f\u0001\u0007\u0011QA\u0001\ta\u0006<W-\u00192mKB\u0019Q/a\u0002\n\u0007\u0005%aO\u0001\u0005QC\u001e,\u0017M\u00197fQ\t9A,A\u0006gS:$')_\"j+&$G\u0003BA\t\u0003/\u0001B!GA\ny%\u0019\u0011Q\u0003\u000e\u0003\r=\u0003H/[8o\u0011\u001d\tI\u0002\u0003a\u0001\u00037\tQaY5VS\u0012\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C9\u0016\u0001\u00027b]\u001eLA!!\n\u0002 \t9\u0011J\u001c;fO\u0016\u0014\bF\u0001\u0005]\u0003=1\u0017N\u001c3CsV\u001bXM\u001d+pW\u0016tG\u0003BA\t\u0003[Aa!a\f\n\u0001\u0004!\u0015!\u0003;pW\u0016t\u0007*Y:iQ\tIA,A\ro_RLg-\u001f+pW\u0016t7/\u00112pkR$v.\u0012=qSJ,G#\u00015)\u0005)a\u0016aD;tKJ$vn[3o\u000bbL7\u000f^:\u0015\r\u0005u\u00121IA#!\rI\u0012qH\u0005\u0004\u0003\u0003R\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007.\u0001\r\u0001\u0012\u0005\u0006!.\u0001\r\u0001\u0012\u0015\u0003\u0017q\u000b\u0001\u0004];cY&\u001c\b\u000eV8lK:\u001c%/Z1uK\u0012,e/\u001a8u)\rA\u0017Q\n\u0005\u0006Y2\u0001\r\u0001\u0010")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote, Date expiryDate) {
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RPA());
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        if (expiryDate == null) {
            userToken.expiryDate_$eq(expiryDate);
        } else {
            LocalDateTime localExpiryDate = expiryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            userToken.expiryDate_$eq(Date.from(localExpiryDate.atZone(ZoneId.systemDefault()).toInstant()));
        }
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (Strings.isNotBlank((String)username)) {
            this.userTokenRepository.delete(username);
            this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
            return;
        }
        throw new IllegalArgumentException("Username can't be blank");
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(new UserTokenRepository.ByUsername(username), pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public void notifyTokensAboutToExpire() {
        LocalDateTime localTime = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX).plusDays(1L);
        Date expiryDate = Date.from(localTime.atZone(ZoneId.systemDefault()).toInstant());
        Buffer tokensAboutToExpire = CollectionConverters$.MODULE$.ListHasAsScala(this.userTokenRepository.query(new UserTokenRepository.TokensAboutToExpire(expiryDate), (Pageable)PageRequest.ofSize((int)1024)).getContent()).asScala();
        tokensAboutToExpire.foreach((Function1 & Serializable)userToken -> {
            UserTokenService.$anonfun$notifyTokensAboutToExpire$1(this, userToken);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was found with user[" + username + "] and note[" + tokenNote + "]");
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was not found with user[" + username + "] and note[" + tokenNote + "]");
            return false;
        }
        throw new MatchError(option);
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public static final /* synthetic */ void $anonfun$notifyTokensAboutToExpire$1(UserTokenService $this, UserToken userToken) {
        $this.eventBus.publish((XLReleaseEvent)new UserTokenAboutToExpireEvent(userToken));
        $this.userTokenRepository.updateTokenExpiredNotified(userToken.ciUid());
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        Logging.$init$((Logging)this);
    }
}

