package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.UserToken
import com.xebialabs.xlrelease.repository.UserTokenRepository.QueryOperation
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid
import org.springframework.data.domain.{Page, Pageable}

import java.util.Date

trait UserTokenRepository {

  def create(userToken: UserToken, tokenHash: String): CiUid

  def updateLastUsed(ciUid: CiUid, lastUsed: Date): Boolean

  def updateLastUsedBatch(entries: Map[Integer, Date]): Int

  def updateTokenExpiredNotified(ciUid: CiUid): Unit

  def delete(ciUid: CiUid): Unit

  def delete(username: String): Unit

  def findByCiUid(ciUid: CiUid): Option[UserToken]

  def findByUserAndNote(username: String, tokenNote: String): Option[UserToken]

  def findByUserToken(tokenHash: String): Option[UserToken]

  def query(operation: QueryOperation, pageable: Pageable): Page[UserToken]

}

object UserTokenRepository {
  sealed trait QueryOperation

  case class ByUsername(username: String) extends QueryOperation
  case class TokensAboutToExpire(expiryDate: Date) extends QueryOperation

}
