/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSendSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeAllSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.repository.SSERepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.user.User;
import javax.ws.rs.sse.SseEventSink;
import org.springframework.stereotype.Service;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)!\u0006\u0001C\u0001W!)q\u0006\u0001C\u0001a!)!\t\u0001C\u0001\u0007\")!\t\u0001C\u0001#\")Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00011\")1\f\u0001C\u00019\")a\f\u0001C\u0001?\")Q\r\u0001C\u0001M\")1\u000e\u0001C\u0001Y\nQ1k]3TKJ4\u0018nY3\u000b\u0005=\u0001\u0012aB:feZL7-\u001a\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006i1o]3SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\ti1kU#SKB|7/\u001b;pef\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005\u001dBS\"\u0001\b\n\u0005%r!\u0001\u0005\"s_\u0006$7-Y:u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005\u001d\u0002\u0001\"\u0002\u0010\u0004\u0001\u0004y\u0002\"B\u0013\u0004\u0001\u00041\u0013aE:vEN\u001c'/\u001b2f+N,'\u000fV8TS:\\GCA\u00195!\tI\"'\u0003\u000245\t!QK\\5u\u0011\u0015)D\u00011\u00017\u0003\u0011\u0019\u0018N\\6\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014aA:tK*\u00111\bP\u0001\u0003eNT!!\u0010 \u0002\u0005]\u001c(\"A \u0002\u000b)\fg/\u0019=\n\u0005\u0005C$\u0001D*tK\u00163XM\u001c;TS:\\\u0017\u0001F:vEN\u001c'/\u001b2f)>\u0004\u0018n\u0019+p+N,'\u000f\u0006\u00022\t\")Q)\u0002a\u0001\r\u0006)Ao\u001c9jGB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013\u000e\u000e\u0003)S!a\u0013\f\u0002\rq\u0012xn\u001c;?\u0013\ti%$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u001b)\r\t$k\u0015\u0005\u0006\u000b\u001a\u0001\rA\u0012\u0005\u0006)\u001a\u0001\rAR\u0001\tkN,'O\\1nK\u00061RO\\:vEN\u001c'/\u001b2f)>\u0004\u0018n\u0019+p+N,'\u000f\u0006\u00022/\")Qi\u0002a\u0001\rR\u0019\u0011'\u0017.\t\u000b\u0015C\u0001\u0019\u0001$\t\u000bQC\u0001\u0019\u0001$\u0002'Ut7/\u001e2tGJL'-Z!mYV\u001bXM]:\u0015\u0005Ej\u0006\"B#\n\u0001\u00041\u0015!C:f]\u0012,e/\u001a8u)\u0011\t\u0004-Y2\t\u000b\u0015S\u0001\u0019\u0001$\t\u000b\tT\u0001\u0019\u0001$\u0002\u0013\u00154XM\u001c;OC6,\u0007\"\u00023\u000b\u0001\u00041\u0015a\u00029bs2|\u0017\rZ\u0001\u000fQ\u0006\u001c\u0018i\u0019;jm\u0016,6/\u001a:t)\t9'\u000e\u0005\u0002\u001aQ&\u0011\u0011N\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015)5\u00021\u0001G\u0003\u001dyg.\u0012<f]R$\"!M7\t\u000b9d\u0001\u0019A8\u0002\u000b\u00154XM\u001c;\u0011\u0005A<X\"A9\u000b\u0005I\u001c\u0018AB3wK:$8O\u0003\u0002uk\u0006YA-[:ue&\u0014W\u000f^3e\u0015\t1\b#\u0001\u0004e_6\f\u0017N\\\u0005\u0003qF\u00141\u0003R5tiJL'-\u001e;fIN\u001bV)\u0012<f]RD#\u0001\u0004>\u0011\u0005mlX\"\u0001?\u000b\u0005I\u0004\u0012B\u0001@}\u00059\t5/\u001f8d'V\u00147o\u0019:jE\u0016D3\u0001AA\u0001!\u0011\t\u0019!!\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\tY!!\u0004\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!a\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0014\u0005\u0015!aB*feZL7-\u001a\u0015\u0004\u0001\u0005]\u0001cA>\u0002\u001a%\u0019\u00111\u0004?\u0003\u001b\u00153XM\u001c;MSN$XM\\3s\u0001")
public class SseService {
    private final SSERepository sseRepository;
    private final BroadcastService broadcastService;

    public void subscribeUserToSink(SseEventSink sink) {
        String username = User.AUTHENTICATED_USER.getName();
        this.sseRepository.addUserToSink(username, sink);
    }

    public void subscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.subscribeTopicToUser(topic, username);
    }

    public void subscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSubscribeSSEEvent(topic, username), true);
    }

    public void unsubscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.unsubscribeTopicToUser(topic, username);
    }

    public void unsubscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeSSEEvent(topic, username), true);
    }

    public void unsubscribeAllUsers(String topic) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeAllSSEEvent(topic), true);
    }

    public void sendEvent(String topic, String eventName, String payload) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSendSSEEvent(topic, eventName, payload), true);
    }

    public boolean hasActiveUsers(String topic) {
        return this.sseRepository.getUsers(topic).nonEmpty();
    }

    @AsyncSubscribe
    public void onEvent(DistributedSSEEvent event) {
        DistributedSSEEvent distributedSSEEvent = event;
        if (distributedSSEEvent instanceof DistributedSubscribeSSEEvent) {
            DistributedSubscribeSSEEvent distributedSubscribeSSEEvent = (DistributedSubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedSubscribeSSEEvent.topic();
            String username = distributedSubscribeSSEEvent.user();
            this.sseRepository.addTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeSSEEvent) {
            DistributedUnsubscribeSSEEvent distributedUnsubscribeSSEEvent = (DistributedUnsubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeSSEEvent.topic();
            String username = distributedUnsubscribeSSEEvent.user();
            this.sseRepository.removeTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeAllSSEEvent) {
            DistributedUnsubscribeAllSSEEvent distributedUnsubscribeAllSSEEvent = (DistributedUnsubscribeAllSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeAllSSEEvent.topic();
            this.sseRepository.removeAllUsersFromTopic(topic);
            return;
        }
        if (distributedSSEEvent instanceof DistributedSendSSEEvent) {
            DistributedSendSSEEvent distributedSendSSEEvent = (DistributedSendSSEEvent)distributedSSEEvent;
            String topic = distributedSendSSEEvent.topic();
            String eventName = distributedSendSSEEvent.eventName();
            String payload = distributedSendSSEEvent.payload();
            this.sseRepository.sendEventToSink(topic, eventName, payload);
            return;
        }
        throw new MatchError((Object)distributedSSEEvent);
    }

    public SseService(SSERepository sseRepository, BroadcastService broadcastService) {
        this.sseRepository = sseRepository;
        this.broadcastService = broadcastService;
    }
}

