/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.domain.events.TemplateLogoUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.utils.IdUtils;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.AttachmentSizeLimiter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TemplateMetadataRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.utils.FileContentValidation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.activation.FileTypeMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.jdk.javaapi.OptionConverters;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    private final AttachmentService attachmentService;
    private final ReleaseRepository releaseRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseActorService releaseActorService;
    private final TemplateMetadataRepository templateMetadataRepository;
    private final EventBus eventBus;

    @Autowired
    public UploadService(AttachmentService attachmentService, ReleaseRepository releaseRepository, AttachmentRepository attachmentRepository, ReleaseActorService releaseActorService, TemplateMetadataRepository templateMetadataRepository, EventBus eventBus) {
        this.attachmentService = attachmentService;
        this.releaseRepository = releaseRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseActorService = releaseActorService;
        this.templateMetadataRepository = templateMetadataRepository;
        this.eventBus = eventBus;
    }

    @Timed
    public List<Attachment> addAttachment(String ciId, FileItemIterator fileItems) throws IOException, FileUploadException {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            InputStream stream = item.openStream();
            try {
                InputStream validatedInputStream = (InputStream)FileContentValidation.apply(filename, stream).get();
                try {
                    logger.debug("Attaching {} to {}", (Object)filename, (Object)ciId);
                    attachmentList.add(this.addAttachment(ciId, filename, contentType, validatedInputStream));
                }
                finally {
                    if (validatedInputStream == null) continue;
                    validatedInputStream.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return attachmentList;
    }

    @Timed
    public TemplateLogo addLogo(String ciId, List<FileItem> fileItems) throws IOException {
        TemplateLogo logo = null;
        for (FileItem item : fileItems) {
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            if (!CustomLogoContentType.getAllTypes().contains(contentType)) {
                throw new IllegalArgumentException(String.format("Content type %s not allowed. Allowed content types are: %s", contentType, CustomLogoContentType.getBrowserTypes().toString()));
            }
            InputStream stream = item.getInputStream();
            try {
                InputStream validatedInputStream = (InputStream)FileContentValidation.apply(filename, stream).get();
                try {
                    logo = this.addLogo(ciId, filename, contentType, validatedInputStream);
                }
                finally {
                    if (validatedInputStream == null) continue;
                    validatedInputStream.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return logo;
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) {
        return this.addAttachment(ciId, fileName, FileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, String contentType, InputStream inputStream) {
        logger.debug("Attaching {} to {}", (Object)fileName, (Object)ciId);
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)ciId));
        Task task = null;
        if (!Ids.isReleaseId((String)ciId)) {
            task = release.getTask(ciId);
        }
        Attachment attachment = this.attachmentService.attachToRelease(release, fileName, contentType, inputStream);
        if (task != null) {
            task.getAttachments().add(attachment);
        }
        this.attachmentRepository.insertAttachment(release.getId(), attachment);
        if (null != task) {
            return this.releaseActorService.createAttachmentOnTask(task.getId(), attachment);
        }
        return this.releaseActorService.createAttachmentOnRelease(release.getId(), attachment);
    }

    @Timed
    public TemplateLogo addLogo(String releaseId, String fileName, String contentType, InputStream inputStream) {
        logger.debug("Attaching logo to {}", (Object)releaseId);
        Optional releaseUid = OptionConverters.toJava(this.releaseRepository.getUid(releaseId));
        if (releaseUid.isPresent()) {
            TemplateLogo logo = this.createLogo(releaseId, fileName, contentType, inputStream);
            TemplateLogo createdLogo = this.templateMetadataRepository.createOrUpdateLogo((Integer)releaseUid.get(), logo);
            this.eventBus.publish((XLReleaseEvent)new TemplateLogoUpdatedEvent(releaseId, createdLogo));
            return createdLogo;
        }
        throw new NotFoundException("Repository entity [%s] not found", new Object[]{releaseId});
    }

    private TemplateLogo createLogo(String releaseId, String filename, String contentType, InputStream bytes) {
        AttachmentSizeLimiter limiter = new AttachmentSizeLimiter(TemplateLogo.getDefaultMaxLogoSize(), bytes);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, (InputStream)((Object)limiter));
        String logoId = IdUtils.getUniqueId((Type)Type.valueOf(TemplateLogo.class), (String)releaseId);
        TemplateLogo templateLogo = new TemplateLogo((OverthereFile)file, contentType);
        templateLogo.setId(logoId);
        templateLogo.getExportFilename();
        String releaseTitle = this.releaseRepository.getTitle(releaseId);
        templateLogo.setProperty("parentTitle", (Object)releaseTitle);
        templateLogo.getPortableFilename();
        return templateLogo;
    }
}

