package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty


@Metadata(label = "Internal scheduling settings",
  description = "Depending on your usage profile, changing the internal scheduling of jobs may improve performance." +
    " Consult support before changing this setting.")
class JobSchedulerFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Incubating", isTransient = true, hidden = true, readonly = true) // or that other
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Scheduling strategy", category = "input", nested = true,
    description = "An algorithm that decides if execution jobs are executed immediately or delayed to improve the overall throughput of the system",
  )
  var strategy: JobSchedulerStrategySettings = _

}
