/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.views.ArtifactView;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json", "text/html"})
public class ReleaseArtifactViewsJsonWriter
implements MessageBodyWriter<Collection<ArtifactView>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = AbstractConfigurationItemReaderWriter.getClassFromGenericType(genericType);
        }
        return ArtifactView.class.isAssignableFrom(type);
    }

    public long getSize(Collection<ArtifactView> artifactViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<ArtifactView> artifactViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(artifactViews).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<ArtifactView> artifactViews) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.array();
        for (ArtifactView ArtifactView2 : artifactViews) {
            ReleaseArtifactViewsJsonWriter.writeReleaseArtifactView(writer, ArtifactView2);
        }
        writer.endArray();
        return stringWriter.toString();
    }

    static void writeReleaseArtifactView(JsonWriter writer, ArtifactView artifactView) {
        writer.object();
        writer.key("id").value((Object)IdType.DOMAIN.convertToViewId(artifactView.getId()));
        writer.key("filename").value((Object)artifactView.getFilename());
        writer.key("contentType").value((Object)artifactView.getContentType());
        writer.endObject();
    }
}

