/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.strategies;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.strategies.BackpressuredWaitJobSchedulerStrategy$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@Metadata(label="Blocking backpressure", description="Original blocking backpressure strategy that blocks job execution until release system start responding fast enough")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u000e\u001c\u0001\u0019BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013m\u0002\u0001\u0019!a\u0001\n\u0003a\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!Q\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0017\u0005%\u0001\u00011AA\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013)\u0004BBA\u0013\u0001\u0011\u0005A\u0010C\u0004\u0002*\u0001!\t!a\u000b\t\u0015\u0005E\u0002\u00011AA\u0002\u0013\u0005A\u0007C\u0006\u00024\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0002BCA\u001d\u0001\u0001\u0007\t\u0011)Q\u0005k!1\u00111\n\u0001\u0005\u0002qDq!a\u0014\u0001\t\u0003\t\t\u0006\u0003\u0006\u0002X\u0001\u0001\r\u00111A\u0005\u0002QB1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\\!Q\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015B\u001b\t\r\u0005U\u0004\u0001\"\u0001}\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002:\u0002!\t!a/\t\u000f\u00055\u0007\u0001\"\u0001\u0002<\"9\u0011q\u001a\u0001\u0005\u0002\u0005m&!\f\"bG.\u0004(/Z:tkJ,GmV1ji*{'mU2iK\u0012,H.\u001a:TiJ\fG/Z4z'\u0016$H/\u001b8hg*\u0011A$H\u0001\u000bgR\u0014\u0018\r^3hS\u0016\u001c(B\u0001\u0010 \u0003%\u00198\r[3ek2,'O\u0003\u0002!C\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003E\r\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0011\n1aY8n\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001C:fiRLgnZ:\u000b\u00051z\u0012\u0001\u00034fCR,(/Z:\n\u00059J#\u0001\b&pEN\u001b\u0007.\u001a3vY\u0016\u00148\u000b\u001e:bi\u0016<\u0017pU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"A\r\u0001\u000e\u0003m\t1C]3ta>t7/\u001a+ie\u0016\u001c\bn\u001c7e\u001bN,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0004\u0013:$\u0018a\u0006:fgB|gn]3UQJ,7\u000f[8mI6\u001bx\fJ3r)\ti\u0004\t\u0005\u00027}%\u0011qh\u000e\u0002\u0005+:LG\u000fC\u0004B\u0007\u0005\u0005\t\u0019A\u001b\u0002\u0007a$\u0013'\u0001\u000bsKN\u0004xN\\:f)\"\u0014Xm\u001d5pY\u0012l5\u000f\t\u0015\u0007\t\u0011\u0003\u0016KU*\u0011\u0005\u0015sU\"\u0001$\u000b\u0005\u001dC\u0015A\u0003<bY&$\u0017\r^5p]*\u0011\u0011JS\u0001\u0004CBL'BA&M\u0003\u0019\u0001H.^4j]*\u0011Q*I\u0001\tI\u0016\u0004Hn\\=ji&\u0011qJ\u0012\u0002\u0006%\u0006tw-Z\u0001\b[&t\u0017.\\;n;\u0005!\u0017aB7bq&lW/\\\u000f\u0003OAAc\u0002B+fM\"L7\u000e\u001c8pcJ\u001c(O\u000b\u0002W9B\u0011qKW\u0007\u00021*\u0011\u0011\fS\u0001\u0004k\u0012l\u0017BA.Y\u0005!\u0001&o\u001c9feRL8&A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001B7fi\u0006T!AY\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002e?\n)a-[3mI\u0006)A.\u00192fY\u0006\nq-\u0001\nSKN\u0004xN\\:fAQD'/Z:i_2$\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013A[\u0001#%\u0016\u001c\bo\u001c8tK\u0002\"\bN]3tQ>dG\rI5oA5LG\u000e\\5tK\u000e|g\u000eZ:\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\"\u00035\f1!\r\u00191\u0003!\u0019\u0017\r^3h_JL\u0018%\u00019\u0002\u000b%t\u0007/\u001e;\u0002\u0017%\u001cHK]1og&,g\u000e^\r\u0002\u0003\u00051\u0001.\u001b3eK:D#\u0001B;\u0011\u0005YLX\"A<\u000b\u0005a<\u0014!\u00022fC:\u001c\u0018B\u0001>x\u00051\u0011U-\u00198Qe>\u0004XM\u001d;z\u0003Y9W\r\u001e*fgB|gn]3UQJ,7\u000f[8mI6\u001bH#A\u001b)\u0005\u0015q8\u0002A\u0001\u0017g\u0016$(+Z:q_:\u001cX\r\u00165sKNDw\u000e\u001c3NgR\u0019Q(a\u0001\t\u000f\u00053\u0011\u0011!a\u0001k!\u0012aA`\u0001\u0010g2,W\r\u001d#ve\u0006$\u0018n\u001c8Ng\u0006\u00192\u000f\\3fa\u0012+(/\u0019;j_:l5o\u0018\u0013fcR\u0019Q(!\u0004\t\u000f\u0005C\u0011\u0011!a\u0001k\u0005\u00012\u000f\\3fa\u0012+(/\u0019;j_:l5\u000f\t\u0015\b\u0013\u0011\u0003\u00161\u0003*T;\t\tA\u001fK\t\n+\u0016\f9\u0002[A\u000eW\u0006}an\\9sgJ\f#!!\u0007\u0002\u001dMcW-\u001a9!IV\u0014\u0018\r^5p]\u0006\u0012\u0011QD\u00017'2,W\r\u001d\u0011ekJ\fG/[8oA%t\u0007%\\5mY&\u001cXmY8oIN\u0004\u0013N\u001a\u0011uQJ,7\u000f[8mI\u0002J7\u000f\t:fC\u000eDW\rZ\u0011\u0003\u0003C\tA!\r\u00191a!\u0012\u0011\"^\u0001\u0013O\u0016$8\u000b\\3fa\u0012+(/\u0019;j_:l5\u000f\u000b\u0002\u000b}\u0006\u00112/\u001a;TY\u0016,\u0007\u000fR;sCRLwN\\'t)\ri\u0014Q\u0006\u0005\b\u0003.\t\t\u00111\u00016Q\tYa0\u0001\fsKN\u0004xN\\:f)\"\u0014Xm\u001d5pY\u0012\u0014\u0016\r^5p\u0003i\u0011Xm\u001d9p]N,G\u000b\u001b:fg\"|G\u000e\u001a*bi&|w\fJ3r)\ri\u0014q\u0007\u0005\b\u00036\t\t\u00111\u00016\u0003]\u0011Xm\u001d9p]N,G\u000b\u001b:fg\"|G\u000e\u001a*bi&|\u0007\u0005K\u0004\u000f\tB\u000biDU)\u001e\u0003)A\u0013CD+f\u0003\u0003B\u0017\u0011I6\u0002F9|\u0017O]:sC\t\t\u0019%\u0001\rSKN\u0004xN\\:fAQD'/Z:i_2$\u0007E]1uS>\f#!a\u0012\u0002\u0005M\u0002\u0004F\u0001\bv\u0003e9W\r\u001e*fgB|gn]3UQJ,7\u000f[8mIJ\u000bG/[8)\u0005=q\u0018!G:fiJ+7\u000f]8og\u0016$\u0006N]3tQ>dGMU1uS>$2!PA*\u0011\u001d\t\u0005#!AA\u0002UB#\u0001\u0005@\u0002%]\f'O\\5oORC'/Z:i_2$Wj]\u0001\u0017o\u0006\u0014h.\u001b8h)\"\u0014Xm\u001d5pY\u0012l5o\u0018\u0013fcR\u0019Q(!\u0018\t\u000f\u0005\u0013\u0012\u0011!a\u0001k\u0005\u0019r/\u0019:oS:<G\u000b\u001b:fg\"|G\u000eZ'tA!:1\u0003\u0012)T%\u0006\rTd\u0001\u0003\u0014B$\n2#V3\u0002h!\fYg[A8]>\f(o\u001d:\"\u0005\u0005%\u0014!E,be:Lgn\u001a\u0011uQJ,7\u000f[8mI\u0006\u0012\u0011QN\u0001\"/\u0006\u0014h.\u001b8hAQD'/Z:i_2$\u0007%\u001b8![&dG.[:fG>tGm]\u0011\u0003\u0003c\nQA\u000e\u00191aAB#aE;\u0002+\u001d,GoV1s]&tw\r\u00165sKNDw\u000e\u001c3Ng\"\u0012AC`\u0001\u0016g\u0016$x+\u0019:oS:<G\u000b\u001b:fg\"|G\u000eZ't)\ri\u0014Q\u0010\u0005\b\u0003V\t\t\u00111\u00016Q\t)b0\u0001\u0005tG\",G-\u001e7f)\u0011\t))!,\u0011\t\u0005\u001d\u0015q\u0015\b\u0005\u0003\u0013\u000b\u0019K\u0004\u0003\u0002\f\u0006\u0005f\u0002BAG\u0003?sA!a$\u0002\u001e:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALK\u00051AH]8pizJ\u0011\u0001J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\r\t)kG\u0001\u0015\u0015>\u00147k\u00195fIVdWM]*ue\u0006$XmZ=\n\t\u0005%\u00161\u0016\u0002\u000f'\u000eDW\rZ;mKJ+7/\u001e7u\u0015\r\t)k\u0007\u0005\b\u0003_3\u0002\u0019AAY\u0003\rQwN\u0019\t\u0005\u0003g\u000b),D\u0001\u001e\u0013\r\t9,\b\u0002\u0004\u0015>\u0014\u0017!\u0005:fgB|gn]3UQJ,7\u000f[8mIV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003!!WO]1uS>t'bAAdo\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005-\u0017\u0011\u0019\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00035\u0019H.Z3q\tV\u0014\u0018\r^5p]\u0006\u0001r/\u0019:oS:<G\u000b\u001b:fg\"|G\u000e\u001a\u0015\n\u0001\u0005MW-!7i\u0003;\u00042aVAk\u0013\r\t9\u000e\u0017\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006\u0012\u00111\\\u0001\u0016\u00052|7m[5oO\u0002\u0012\u0017mY6qe\u0016\u001c8/\u001e:fC\t\ty.A:Pe&<\u0017N\\1mA\tdwnY6j]\u001e\u0004#-Y2laJ,7o];sK\u0002\u001aHO]1uK\u001eL\b\u0005\u001e5bi\u0002\u0012Gn\\2lg\u0002RwN\u0019\u0011fq\u0016\u001cW\u000f^5p]\u0002*h\u000e^5mAI,G.Z1tK\u0002\u001a\u0018p\u001d;f[\u0002\u001aH/\u0019:uAI,7\u000f]8oI&tw\r\t4bgR\u0004SM\\8vO\"\u0004")
public class BackpressuredWaitJobSchedulerStrategySettings
extends JobSchedulerStrategySettings {
    @Property(label="Response threshold", description="Response threshold in milliseconds", defaultValue="100", category="input", isTransient=true, hidden=true)
    @Range(minimum=100, maximum=10000)
    private int responseThresholdMs;
    @Property(label="Sleep duration", description="Sleep duration in milliseconds if threshold is reached", defaultValue="1000", category="input", isTransient=true, hidden=true)
    @Range(minimum=500, maximum=10000)
    private int sleepDurationMs;
    @Property(label="Response threshold ratio", description="Response threshold ratio", defaultValue="30", category="input", isTransient=true, hidden=true)
    @Range(minimum=10, maximum=100)
    private int responseThresholdRatio;
    @Property(label="Warning threshold", description="Warning threshold in milliseconds", defaultValue="60000", category="input", isTransient=true, hidden=true)
    @Range(minimum=10000, maximum=300000)
    private int warningThresholdMs;

    public int responseThresholdMs() {
        return this.responseThresholdMs;
    }

    public void responseThresholdMs_$eq(int x$1) {
        this.responseThresholdMs = x$1;
    }

    public int sleepDurationMs() {
        return this.sleepDurationMs;
    }

    public void sleepDurationMs_$eq(int x$1) {
        this.sleepDurationMs = x$1;
    }

    public int responseThresholdRatio() {
        return this.responseThresholdRatio;
    }

    public void responseThresholdRatio_$eq(int x$1) {
        this.responseThresholdRatio = x$1;
    }

    public int warningThresholdMs() {
        return this.warningThresholdMs;
    }

    public void warningThresholdMs_$eq(int x$1) {
        this.warningThresholdMs = x$1;
    }

    @Override
    public Either<Job, Job> schedule(Job job) {
        return BackpressuredWaitJobSchedulerStrategy$.MODULE$.schedule(this, job);
    }

    public FiniteDuration responseThreshold() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.responseThresholdMs())).millis();
    }

    public FiniteDuration sleepDuration() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.sleepDurationMs())).millis();
    }

    public FiniteDuration warningThreshold() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.warningThresholdMs())).millis();
    }

    public int getResponseThresholdMs() {
        return this.responseThresholdMs();
    }

    public int getResponseThresholdRatio() {
        return this.responseThresholdRatio();
    }

    public int getSleepDurationMs() {
        return this.sleepDurationMs();
    }

    public int getWarningThresholdMs() {
        return this.warningThresholdMs();
    }

    public void setResponseThresholdMs(int x$1) {
        this.responseThresholdMs_$eq(x$1);
    }

    public void setResponseThresholdRatio(int x$1) {
        this.responseThresholdRatio_$eq(x$1);
    }

    public void setSleepDurationMs(int x$1) {
        this.sleepDurationMs_$eq(x$1);
    }

    public void setWarningThresholdMs(int x$1) {
        this.warningThresholdMs_$eq(x$1);
    }
}

