package com.xebialabs.xlrelease.repository.query

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.domain.status.TaskStatus.{ABORTED, PLANNED}

import java.util.Date

case class TaskBasicData(
                          ciUid: Int,
                          releaseUid: Int,
                          taskId: String,
                          taskType: Type,
                          title: String,
                          status: TaskStatus,
                          statusLine: String,
                          owner: String,
                          team: String,
                          startDate: Date,
                          endDate: Date,
                          isAutomated: Boolean,
                          locked: Boolean
                        ) {
  // TODO extract taskStatus related operations and share it with Task
  def isDoneInAdvance: Boolean = status != null && status.isDoneInAdvance

  def isUpdatable: Boolean = !isDefunct && !isDoneInAdvance

  def isDefunct: Boolean = isAborted || isDone

  def isAborted: Boolean = status == ABORTED

  def isDone: Boolean = status != null && status.isDone

  def isPlanned: Boolean = status != null && (status == PLANNED)

}
