package com.xebialabs.xlrelease.views;

import com.xebialabs.xlrelease.domain.status.TaskStatus;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.xebialabs.xlrelease.domain.status.TaskStatus.*;
import static java.util.Arrays.asList;

public class TasksFilters {
    private boolean assignedToMe;
    private boolean assignedToMyTeams;
    private boolean assignedToAnybody;
    private String filter;
    private Date from;
    private Date to;
    private List<String> tags = new ArrayList<>();
    private boolean inProgress;
    private boolean failed;
    private boolean pending;
    private boolean planned;
    private String folderId;

    public boolean isAssignedToMe() {
        return assignedToMe;
    }

    public void setAssignedToMe(final boolean assignedToMe) {
        this.assignedToMe = assignedToMe;
    }

    public boolean isAssignedToMyTeams() {
        return assignedToMyTeams;
    }

    public void setAssignedToMyTeams(final boolean assignedToMyTeams) {
        this.assignedToMyTeams = assignedToMyTeams;
    }

    public boolean isAssignedToAnybody() {
        return assignedToAnybody;
    }

    public void setAssignedToAnybody(final boolean assignedToAnybody) {
        this.assignedToAnybody = assignedToAnybody;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(final String filter) {
        this.filter = filter;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(final Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(final Date to) {
        this.to = to;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public boolean withInProgress() {
        return inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean withFailed() {
        return failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean withPending() {
        return pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean withPlanned() {
        return planned;
    }

    public void setPlanned(boolean planned) {
        this.planned = planned;
    }

    public List<TaskStatus> getStatuses() {
        List<TaskStatus> statuses = new ArrayList<>();
        if (withPlanned()) {
            statuses.add(PLANNED);
        }
        if (withPending()) {
            statuses.add(PENDING);
        }
        if (withInProgress()) {
            statuses.addAll(asList(IN_PROGRESS_STATUSES));
        }
        if (withFailed()) {
            statuses.addAll(asList(FAILED_STATUSES));
        }
        return statuses;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }
}
