package com.xebialabs.deployit.plumbing.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

/**
 * Provides redirect to certain URL on authentication success.
 */
public class RedirectToUrlSuccessHandler implements AuthenticationSuccessHandler {

    private final String url;

    public RedirectToUrlSuccessHandler(String url) {
        this.url = url;
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication != null) {
            response.sendRedirect(url);
        }
    }
}
