package com.xebialabs.xlrelease.domain.tasks.userinput;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;

import static com.xebialabs.xlrelease.builder.TaskBuilder.newUserInputTask;

@Component
public class UserInputTaskViewConverter extends BaseTaskViewConverter<UserInputTask> {

    @Override
    public TaskFullView toFullView(final UserInputTask task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setVariables(task.getVariables());
        return v;
    }

    @Override
    protected UserInputTask fromView(final TaskFullView view) {
        return newUserInputTask()
                .withVariables(view.getVariables())
                .build();
    }

    @Override
    protected Class<UserInputTask> getTaskClass() {
        return UserInputTask.class;
    }

}
