package com.xebialabs.xlrelease.service

import akka.actor.ActorRef
import com.xebialabs.xlrelease.actors.UserLastActiveActor.{UpdateLastActive, UpdateTokenLastUsed}
import com.xebialabs.xlrelease.actors.initializer.UserLastActiveActorHolder
import org.springframework.stereotype.Component

@Component
class UserLastActiveActorService(userLastActiveActorHolder: UserLastActiveActorHolder) {
  lazy val actorRef: ActorRef = userLastActiveActorHolder.actorRef()

  def updateLastActive(userId: String): Unit =
    actorRef ! UpdateLastActive(userId)

  def updateTokenLastUsed(tokenId: Integer): Unit =
    actorRef ! UpdateTokenLastUsed(tokenId)

}
