/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.views.PhaseForm;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.converters.PhaseViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/phases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class PhaseResource {
    private ReleaseActorService releaseActorService;
    private TaskAccessService taskAccessService;
    private PermissionChecker permissionChecker;
    private PhaseViewConverter phaseViewConverter;

    @Autowired
    public PhaseResource(ReleaseActorService releaseActorService, TaskAccessService taskAccessService, PermissionChecker permissionChecker, PhaseViewConverter phaseViewConverter) {
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.permissionChecker = permissionChecker;
        this.phaseViewConverter = phaseViewConverter;
    }

    @PUT
    @Timed
    @Path(value="{phaseId:.*Phase[^/-]*}")
    public PhaseFullView update(@PathParam(value="phaseId") @IdParam String phaseId, PhaseForm phaseForm) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)phaseId));
        Phase phase = this.releaseActorService.updatePhase(phaseId, phaseForm.toPhase());
        return this.phaseViewConverter.toFullView(phase, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @DELETE
    @Timed
    @Path(value="{phaseId:.*Phase[^/-]*}")
    public void deletePhase(@PathParam(value="phaseId") @IdParam String phaseId) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom((String)phaseId));
        this.releaseActorService.deletePhase(phaseId);
    }
}

