/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature$;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002^\u0001!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007BB%\u0001\t\u0013\t9MA\tVg\u0016\u0014Hk\\6f]J+7o\\;sG\u0016T!a\u0004\t\u0002\u0011%tG/\u001a:oC2T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g24GG\u001b\u0006\u0002K\u0005AqM]5{u2,G-\u0003\u0002(E\t9Aj\\4hS:<\u0017a\u00039fe6L7o]5p]N\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u0011M,7-\u001e:jifL!AL\u0016\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0007u_.,gnU3sm&\u001cW\r\u0005\u00022i5\t!G\u0003\u00024%\u000591/\u001a:wS\u000e,\u0017BA\u001b3\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0003vg\u0016\u00148\u000f\u0005\u00022q%\u0011\u0011H\r\u0002\u0006+N,'o]\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\tat(D\u0001>\u0015\tq$#A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003\u0001v\u0012Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u00163u\t\u0013\t\u0003\t\u0002i\u0011A\u0004\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006u\u0015\u0001\raO\u0001\u000eO\u0016$Xk]3s)>\\WM\\:\u0015\u0007-cF\u000fE\u0002M+^k\u0011!\u0014\u0006\u0003\u001d>\u000ba\u0001Z8nC&t'B\u0001)R\u0003\u0011!\u0017\r^1\u000b\u0005I\u001b\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003Q\u000b1a\u001c:h\u0013\t1VJ\u0001\u0003QC\u001e,\u0007C\u0001-[\u001b\u0005I&B\u0001(\u0013\u0013\tY\u0016LA\u0005Vg\u0016\u0014Hk\\6f]\")QL\u0002a\u0001=\u0006!\u0001/Y4f!\tYr,\u0003\u0002a9\t\u0019\u0011J\u001c;)\tq\u0013G.\u001c\t\u0003G*l\u0011\u0001\u001a\u0006\u0003K\u001a\f!A]:\u000b\u0005\u001dD\u0017AA<t\u0015\u0005I\u0017a\u00026bW\u0006\u0014H/Y\u0005\u0003W\u0012\u0014A\u0002R3gCVdGOV1mk\u0016\fQA^1mk\u0016\f\u0013A\\\u0001\u0002a!\"A\f\u001d7t!\t\u0019\u0017/\u0003\u0002sI\nQ\u0011+^3ssB\u000b'/Y7\"\u0003uCQ!\u001e\u0004A\u0002y\u000baB]3tk2$8\u000fU3s!\u0006<W\r\u000b\u0003uE2<\u0018%\u0001=\u0002\u0007E\u0002\u0004\u0007\u000b\u0003ua2T\u0018%A;)\u0005\u0019a\bCA2~\u0013\tqHMA\u0002H\u000bRCcABA\u0001Y\u0006\u001d\u0001cA2\u0002\u0004%\u0019\u0011Q\u00013\u0003\tA\u000bG\u000f[\u0011\u0003\u0003\u0013\taaL;tKJ\u001c\bf\u0001\u0004\u0002\u000eA!\u0011qBA\u000f\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011AC1o]>$\u0018\r^5p]*!\u0011qCA\r\u0003\u001diW\r\u001e:jGNT1!a\u0007\u0017\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0010\u0003#\u0011Q\u0001V5nK\u0012\fAcZ3u)>\\WM\\:G_J,6/\u001a:oC6,GcB&\u0002&\u0005%\u0013q\n\u0005\b\u0003O9\u0001\u0019AA\u0015\u0003!)8/\u001a:oC6,\u0007\u0003BA\u0016\u0003sqA!!\f\u00026A\u0019\u0011q\u0006\u000f\u000e\u0005\u0005E\"bAA\u001a1\u00051AH]8pizJ1!a\u000e\u001d\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0007\u000f)\u000f\u0005\u0015\u0012\u0011\t7\u0002HA\u00191-a\u0011\n\u0007\u0005\u0015CMA\u0005QCRD\u0007+\u0019:b[\u0006\u0012\u0011q\u0005\u0005\u0006;\u001e\u0001\rA\u0018\u0015\u0006\u0003\u0013\u0012G.\u001c\u0015\u0006\u0003\u0013\u0002Hn\u001d\u0005\u0006k\u001e\u0001\rA\u0018\u0015\u0006\u0003\u001f\u0012Gn\u001e\u0015\u0006\u0003\u001f\u0002HN\u001f\u0015\u0003\u000fqDcaBA\u0001Y\u0006e\u0013EAA.\u0003EySo]3sg>ZXo]3s]\u0006lW-`\u0001\u0012O\u0016tWM]1uKV\u001bXM\u001d+pW\u0016tG#B,\u0002b\u0005\u0015\u0004bBA\u0014\u0011\u0001\u0007\u0011\u0011\u0006\u0015\b\u0003C\n\t\u0005\\A$\u0011\u001d\t9\u0007\u0003a\u0001\u0003S\nQ\"^:feR{7.\u001a8G_Jl\u0007\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0006M>\u0014Xn\u001d\u0006\u0004\u0003g\u0002\u0012A\u0001<2\u0013\u0011\t9(!\u001c\u0003;\r\u0013X-\u0019;f!\u0016\u00148o\u001c8bY\u0006\u001b7-Z:t)>\\WM\u001c$pe6D3\u0001CA>!\r\u0019\u0017QP\u0005\u0004\u0003\u007f\"'\u0001\u0002)P'RCc\u0001CA\u0001Y\u0006eCcA,\u0002\u0006\"9\u0011qM\u0005A\u0002\u0005%\u0004fA\u0005\u0002|!2\u0011\"!\u0001m\u0003\u000fA3!CA\u0007\u0003=!W\r\\3uKV\u001bXM\u001d+pW\u0016tG\u0003BAI\u0003/\u00032aGAJ\u0013\r\t)\n\b\u0002\u0005+:LG\u000fC\u0004\u0002\u001a*\u0001\r!a'\u0002\u000b\rLW+\u001b3\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u0006!A.\u00198h\u0015\t\t)+\u0001\u0003kCZ\f\u0017\u0002BAU\u0003?\u0013q!\u00138uK\u001e,'\u000fK\u0004\u0002\u0018\u0006\u0005C.!,\"\u0005\u0005e\u0005f\u0001\u0006\u00022B\u00191-a-\n\u0007\u0005UFM\u0001\u0004E\u000b2+E+\u0012\u0015\u0007\u0015\u0005\u0005A.!/\"\u0005\u0005m\u0016AD\u0018vg\u0016\u00148oL>dSVKG- \u0015\u0004\u0015\u00055\u0011!\t<bY&$\u0017\r^3B]\u0012tuN]7bY&TX-V:feR{7.\u001a8G_JlGCBAI\u0003\u0007\f)\rC\u0004\u0002(-\u0001\r!!\u000b\t\u000f\u0005\u001d4\u00021\u0001\u0002jQ91*!3\u0002L\u00065\u0007bBA\u0014\u0019\u0001\u0007\u0011\u0011\u0006\u0005\u0006;2\u0001\rA\u0018\u0005\u0006k2\u0001\rA\u0018\u0015\u0007\u0001\u0005\u0005A.!5\"\u0005\u0005M\u0017aB\u0018u_.,gn\u001d\u0015\u0007\u0001\u0005]G.!8\u0011\u0007\r\fI.C\u0002\u0002\\\u0012\u0014\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003?\f#!!9\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007F\u0002\u0001\u0002f2\fY\u000fE\u0002d\u0003OL1!!;e\u0005!\u0001&o\u001c3vG\u0016\u001cHFAApQ\r\u0001\u0011q\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q_)\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002z\u0006M(AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users/{username}")
    public UserToken generateUserToken(@PathParam(value="username") String username, CreatePersonalAccessTokenForm userTokenForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens generated by administrator are only supported for internal users", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = PersonalAccessTokenFeature$.MODULE$.enabled() || this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP, Atlassian Crowd", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private void validateAndNormalizeUserTokenForm(String username, CreatePersonalAccessTokenForm userTokenForm) {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

