/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.security.authentication.TokenExpiredException;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\n\u0014\u0001yA\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000f%\u0004\u0001\u0019!C\u0005U\"9Q\u000f\u0001a\u0001\n\u00131\bBB@\u0001A\u0003&1\u000eC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003C\u0003A\u0011IAR\u0011\u0019\t\u0019\r\u0001C\u0001U\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d'!\b*fY\u0016\f7/Z!vi\",g\u000e^5dCRLwN\u001c)s_ZLG-\u001a:\u000b\u0005Q)\u0012AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003-]\t\u0001b]3dkJLG/\u001f\u0006\u00031e\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u00011\u0003\u0002\u0001 OE\u0002\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004PE*,7\r\u001e\t\u0003Q=j\u0011!\u000b\u0006\u0003))R!AF\u0016\u000b\u00051j\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u00039\n1a\u001c:h\u0013\t\u0001\u0014F\u0001\fBkRDWM\u001c;jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\u0011t'D\u00014\u0015\t!T'A\u0003tY\u001a$$NC\u00017\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001d4\u0005\u001daunZ4j]\u001e\f1\"^:feN+'O^5dKB\u00111hP\u0007\u0002y)\u0011a#\u0010\u0006\u0003}e\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0001r\u00121\"V:feN+'O^5dK\u0006\u0001Ro]3s)>\\WM\\*feZL7-\u001a\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b^\tqa]3sm&\u001cW-\u0003\u0002H\t\n\u0001Rk]3s)>\\WM\\*feZL7-Z\u0001\u001bkN,'\u000fT1ti\u0006\u001bG/\u001b<f\u0003\u000e$xN]*feZL7-\u001a\t\u0003\u0007*K!a\u0013#\u00035U\u001bXM\u001d'bgR\f5\r^5wK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002!U\u001cXM]$s_V\u00048+\u001a:wS\u000e,\u0007C\u0001(P\u001b\u0005)\u0012B\u0001)\u0016\u0005A)6/\u001a:He>,\boU3sm&\u001cW-A\u000bqe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0011\u0005M3V\"\u0001+\u000b\u0005U;\u0012!\u00049sS:\u001c\u0017\u000e]1mI\u0006$\u0018-\u0003\u0002X)\n)\u0002K]5oG&\u0004\u0018\r\u001c#bi\u0006\u0004&o\u001c<jI\u0016\u0014\u0018A\u00079feN|g.\u00197BG\u000e,7o\u001d+pW\u0016tg)Z1ukJ,\u0007C\u0001.^\u001b\u0005Y&B\u0001/\u0018\u0003!1W-\u0019;ve\u0016\u001c\u0018B\u00010\\\u0005i\u0001VM]:p]\u0006d\u0017iY2fgN$vn[3o\r\u0016\fG/\u001e:f\u0003\u0019a\u0014N\\5u}Q9\u0011m\u00193fM\u001eD\u0007C\u00012\u0001\u001b\u0005\u0019\u0002\"B\u001d\b\u0001\u0004Q\u0004\"B!\b\u0001\u0004\u0011\u0005\"\u0002%\b\u0001\u0004I\u0005\"\u0002'\b\u0001\u0004i\u0005\"B)\b\u0001\u0004\u0011\u0006\"\u0002-\b\u0001\u0004I\u0016!E1vi\"|'/\u001b;jKNl\u0015\r\u001d9feV\t1\u000e\u0005\u0002mg6\tQN\u0003\u0002o_\u00069Q.\u00199qS:<'B\u00019r\u0003%\tW\u000f\u001e5pe&$\u0018P\u0003\u0002sU\u0005!1m\u001c:f\u0013\t!XN\u0001\rHe\u0006tG/\u001a3BkRDwN]5uS\u0016\u001cX*\u00199qKJ\fQ#Y;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s?\u0012*\u0017\u000f\u0006\u0002x{B\u0011\u0001p_\u0007\u0002s*\t!0A\u0003tG\u0006d\u0017-\u0003\u0002}s\n!QK\\5u\u0011\u001dq\u0018\"!AA\u0002-\f1\u0001\u001f\u00132\u0003I\tW\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM\u001d\u0011\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\t\u0005\u0015\u0011Q\u0002\t\u0005\u0003\u000f\tI!D\u0001r\u0013\r\tY!\u001d\u0002\u000f\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u001d\tya\u0003a\u0001\u0003\u000b\tQ\u0001^8lK:DSaCA\n\u0003?\u0001R\u0001_A\u000b\u00033I1!a\u0006z\u0005\u0019!\bN]8xgB!\u0011qAA\u000e\u0013\r\ti\"\u001d\u0002\u0018\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\ftAHA\u0011\u0003o\tI\u0007\u0005\u0003\u0002$\u0005Eb\u0002BA\u0013\u0003[\u00012!a\nz\u001b\t\tICC\u0002\u0002,u\ta\u0001\u0010:p_Rt\u0014bAA\u0018s\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\fzc%\u0019\u0013\u0011HA!\u0003?\n\u0019%\u0006\u0003\u0002<\u0005uRCAA\u0011\t\u001d\ty$\bb\u0001\u0003\u0013\u0012\u0011\u0001V\u0005\u0005\u0003\u0007\n)%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u000fJ\u0018A\u0002;ie><8/\u0005\u0003\u0002L\u0005E\u0003c\u0001=\u0002N%\u0019\u0011qJ=\u0003\u000f9{G\u000f[5oOB!\u00111KA-\u001d\rA\u0018QK\u0005\u0004\u0003/J\u0018a\u00029bG.\fw-Z\u0005\u0005\u00037\niFA\u0005UQJ|w/\u00192mK*\u0019\u0011qK=2\u0013\r\n\t'a\u0019\u0002f\u0005\u001dcb\u0001=\u0002d%\u0019\u0011qI=2\u000b\tB\u00180a\u001a\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\nI\"A\rbkRDWM\u001c;jG\u0006$XM\u0012:p[V\u001bXM\u001d+pW\u0016tG\u0003BA\u0003\u0003_Bq!a\u0004\r\u0001\u0004\t\t#A\u000ebkRDWM\u001c;jG\u0006$XM\u0012:p[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0007\u0003\u000b\t)(!\u001f\t\u000f\u0005]T\u00021\u0001\u0002\"\u0005AQo]3s]\u0006lW\rC\u0004\u0002|5\u0001\r!!\t\u0002\u0011A\f7o]<pe\u0012\f1#\u001a<bYV\fG/Z!vi\"|'/\u001b;jKN$B!!!\u0002 B\"\u00111QAJ!\u0019\t))a#\u0002\u00106\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u001b\u0013\u0001B;uS2LA!!$\u0002\b\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\u0005E\u00151\u0013\u0007\u0001\t-\t)JDA\u0001\u0002\u0003\u0015\t!a&\u0003\u0007}#3'\u0005\u0003\u0002L\u0005e\u0005\u0003BA\u0004\u00037K1!!(r\u0005A9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018\u0010C\u0004\u0002x9\u0001\r!!\t\u0002\u0011M,\b\u000f]8siN$B!!*\u0002,B\u0019\u00010a*\n\u0007\u0005%\u0016PA\u0004C_>dW-\u00198\t\rQy\u0001\u0019AAWa\u0011\ty+a.\u0011\r\u0005\r\u0012\u0011WA[\u0013\u0011\t\u0019,!\u000e\u0003\u000b\rc\u0017m]:\u0011\t\u0005E\u0015q\u0017\u0003\r\u0003s\u000bY+!A\u0001\u0002\u000b\u0005\u00111\u0018\u0002\u0004?\u0012\"\u0014\u0003BA&\u0003{\u00032\u0001_A`\u0013\r\t\t-\u001f\u0002\u0004\u0003:L\u0018\u0001F4fi\u0006+H\u000f[8sSRLWm]'baB,'/\u0001\u000btKR\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM\u001d\u000b\u0004o\u0006%\u0007\"B5\u0012\u0001\u0004Y\u0007f\u0002\u0001\u0002N\u0006e\u00171\u001c\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111[\u0016\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002X\u0006E'!C\"p[B|g.\u001a8u\u0003\u00151\u0018\r\\;fC\t\ti.\u0001\ryY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJ\u0004")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
Logging {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final UserLastActiveActorService userLastActiveActorService;
    private final UserGroupService userGroupService;
    private final PrincipalDataProvider principalDataProvider;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            authentication = token instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService.findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        if (userToken.isExpired()) {
            throw new TokenExpiredException("The token expired on " + DateVariableUtils.printDate((Date)userToken.expiryDate()));
        }
        this.userLastActiveActorService.updateTokenLastUsed(userToken.ciUid());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken(new InternalUser(userToken.username()), token, mappedAuthorities);
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList<SimpleGrantedAuthority> arrayList;
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        try {
            User user = this.userService.read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.personalAccessTokenFeature.enabled()) {
                Set<String> userGroups = this.userGroupService.findGroupsForUser(username);
                ArrayList grantedAuthorities = new ArrayList();
                userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
                arrayList = grantedAuthorities;
            }
            throw throwable;
        }
        ArrayList<SimpleGrantedAuthority> authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider(UserService userService, UserTokenService userTokenService, UserLastActiveActorService userLastActiveActorService, UserGroupService userGroupService, PrincipalDataProvider principalDataProvider, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.userLastActiveActorService = userLastActiveActorService;
        this.userGroupService = userGroupService;
        this.principalDataProvider = principalDataProvider;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

