package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import java.util
import scala.jdk.CollectionConverters._

trait CachedInternalMetadataDecorator[A <: ConfigurationItem, C] extends InternalMetadataDecorator[A] {

  lazy val noCache: DecoratorCache[C] = new DecoratorCache[C](null, null)

  def decorate(ci: A, cache: DecoratorCache[C]): Unit = decorate(Seq(ci).asJavaCollection, cache)

  def decorate(cis: util.Collection[A], cache: DecoratorCache[C]): Unit

  override def decorateWithCache(ci: A, cacheKey: String, cache: DecoratorsCache): Unit = decorate(ci, cache.getDecoratorCache[C](cacheKey))

  override def decorateWithCache(cis: util.Collection[A], cacheKey: String, cache: DecoratorsCache): Unit = decorate(cis, cache.getDecoratorCache[C](cacheKey))
}
