package com.xebialabs.xlrelease.scheduler.storage.spring

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.storage.spring.StorageConfiguration.URI_SCHEME_LOCAL_STORAGE
import com.xebialabs.xlrelease.storage.Storage
import com.xebialabs.xlrelease.storage.local.{LocalStorage, LocalStorageConfig}
import com.xebialabs.xlrelease.storage.service.{DefaultStorageService, StorageService}
import org.springframework.context.annotation.{Bean, Configuration}

import java.nio.file.Paths

@Configuration
class StorageConfiguration(xlrConfig: XlrConfig) {
  private val jobLogDir = xlrConfig.jobLog.directory

  @Bean
  def localLogStorage: LocalStorage = {
    val config = LocalStorageConfig(Paths.get(jobLogDir), uriScheme = URI_SCHEME_LOCAL_STORAGE)
    new LocalStorage(config)
  }

  @Bean
  def storageService(storages: Array[Storage]): StorageService = {
    new DefaultStorageService(storages)
  }
}

object StorageConfiguration {
  final val URI_SCHEME_LOCAL_STORAGE = "xlr-local"
}
