package com.xebialabs.xlrelease.api.utils;

import com.xebialabs.xlrelease.repository.MetadataRepository;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.xebialabs.xlrelease.api.internal.ReleaseServerResource.ANALYTICS_ID;
import static com.xebialabs.xlrelease.api.utils.WordUtils.convertToTitleCase;

public class AccountIdHelper {

    private static final Logger logger = LoggerFactory.getLogger(AccountIdHelper.class);

    public static String generateAccountId(String licensedName, String serverUrl) {
        if (licensedName == null) {
            licensedName = "";
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        String accountName = convertToTitleCase(StringUtils.stripAccents(licensedName)
                .replaceAll("[^a-zA-Z0-9]", " ")
                .replaceAll("(\\d)([A-Za-z])", "$1 $2"));
        String accountEnvironment = DigestUtils.md5Hex(serverUrl).substring(0, 6);
        return accountName + "_" + accountEnvironment;
    }

    public static String getAccountId(MetadataRepository metadataRepository, String licensedName, String serverUrl) {
        String accountId = "";
        try {
            if (metadataRepository.exists(ANALYTICS_ID)) {
                accountId = metadataRepository.getEntry(ANALYTICS_ID);
            } else {
                accountId = generateAccountId(licensedName, serverUrl);
                metadataRepository.create(ANALYTICS_ID, accountId);
            }
        } catch (Exception e) {
            logger.warn("Exception while creating Analytics Identifier", e);
        }
        return accountId;
    }

    public static String updateAccountId(MetadataRepository metadataRepository, String licensedName, String serverUrl) {
        String accountId = generateAccountId(licensedName, serverUrl);
        try {
            if (metadataRepository.exists(ANALYTICS_ID)) {
                metadataRepository.update(ANALYTICS_ID, accountId);
            } else {
                metadataRepository.create(ANALYTICS_ID, accountId);
            }
        } catch (Exception e) {
            logger.warn("Exception while updating Analytics Identifier", e);
        }
        return accountId;
    }
}
