/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.utils;

import com.xebialabs.xlrelease.api.utils.WordUtils;
import com.xebialabs.xlrelease.repository.MetadataRepository;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountIdHelper {
    private static final Logger logger = LoggerFactory.getLogger(AccountIdHelper.class);

    public static String generateAccountId(String licensedName, String serverUrl) {
        if (licensedName == null) {
            licensedName = "";
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        String accountName = WordUtils.convertToTitleCase(StringUtils.stripAccents((String)licensedName).replaceAll("[^a-zA-Z0-9]", " ").replaceAll("(\\d)([A-Za-z])", "$1 $2"));
        String accountEnvironment = DigestUtils.md5Hex((String)serverUrl).substring(0, 6);
        return accountName + "_" + accountEnvironment;
    }

    public static String getAccountId(MetadataRepository metadataRepository, String licensedName, String serverUrl) {
        String accountId = "";
        try {
            if (metadataRepository.exists("analytics_id")) {
                accountId = metadataRepository.getEntry("analytics_id");
            } else {
                accountId = AccountIdHelper.generateAccountId(licensedName, serverUrl);
                metadataRepository.create("analytics_id", accountId);
            }
        }
        catch (Exception e) {
            logger.warn("Exception while creating Analytics Identifier", (Throwable)e);
        }
        return accountId;
    }

    public static String updateAccountId(MetadataRepository metadataRepository, String licensedName, String serverUrl) {
        String accountId = AccountIdHelper.generateAccountId(licensedName, serverUrl);
        try {
            if (metadataRepository.exists("analytics_id")) {
                metadataRepository.update("analytics_id", accountId);
            } else {
                metadataRepository.create("analytics_id", accountId);
            }
        }
        catch (Exception e) {
            logger.warn("Exception while updating Analytics Identifier", (Throwable)e);
        }
        return accountId;
    }
}

