/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authorization;

import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.RunnerAuthenticationToken;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

public class LoginAuthorizationManager<T>
implements AuthorizationManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoginAuthorizationManager.class);
    private final UserProfileService userProfileService;
    private final UserLastActiveActorService userLastActiveActorService;

    public LoginAuthorizationManager(UserProfileService userProfileService, UserLastActiveActorService userLastActiveActorService) {
        this.userProfileService = userProfileService;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
        boolean granted = this.isGranted(authentication.get());
        return new AuthorizationDecision(granted);
    }

    private boolean isGranted(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated() && this.isAuthorized(authentication);
    }

    private boolean isAuthorized(Authentication authentication) {
        String username = authentication.getName();
        logger.debug("Checking if login allowed for [{}]", (Object)username);
        if (authentication instanceof RunnerAuthenticationToken) {
            return true;
        }
        if (XLReleasePermissions.isAdmin((String)username)) {
            this.userLastActiveActorService.updateLastActive("admin");
            return true;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile != null && userProfile.isLoginAllowed()) {
            logger.debug("User [{}] is authorized for login", (Object)username);
            this.onAccessGranted(authentication, userProfile);
            return true;
        }
        logger.error("User [{}] is not authorized for login", (Object)username);
        return false;
    }

    private void onAccessGranted(Authentication authentication, UserProfile userProfile) {
        this.userLastActiveActorService.updateLastActive(userProfile.getCanonicalId());
        Object details = authentication.getDetails();
        String realUserName = userProfile.getName();
        Collection oldAuthorities = authentication.getAuthorities();
        SimpleGrantedAuthority authenticatedUserAuthority = new SimpleGrantedAuthority("authenticated-user");
        Collection newAuthorities = oldAuthorities;
        if (!oldAuthorities.contains(authenticatedUserAuthority)) {
            HashSet<Object> modifiableAuthorities = new HashSet<Object>();
            modifiableAuthorities.add(authenticatedUserAuthority);
            modifiableAuthorities.addAll(oldAuthorities);
            newAuthorities = Collections.unmodifiableCollection(modifiableAuthorities);
        }
        SecurityContext newCtxt = SecurityContextHolder.createEmptyContext();
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oldToken = (OAuth2AuthenticationToken)authentication;
            OAuth2AuthenticationToken newAuthentication = new OAuth2AuthenticationToken(oldToken.getPrincipal(), newAuthorities, oldToken.getAuthorizedClientRegistrationId());
            newAuthentication.setDetails(oldToken.getDetails());
            newCtxt.setAuthentication((Authentication)newAuthentication);
            SecurityContextHolder.setContext((SecurityContext)newCtxt);
            return;
        }
        if (authentication instanceof PersonalAuthenticationToken) {
            PersonalAuthenticationToken oldToken = (PersonalAuthenticationToken)authentication;
            PersonalAuthenticationToken newAuthentication = new PersonalAuthenticationToken(oldToken.getPrincipal(), (String)oldToken.getCredentials(), oldToken.getExpiryDate(), newAuthorities, oldToken.getGlobalPermissions(), oldToken.getConfigurationItemsPermissions(), oldToken.getConfigurationItems());
            newAuthentication.setDetails(oldToken.getDetails());
            newCtxt.setAuthentication((Authentication)newAuthentication);
            SecurityContextHolder.setContext((SecurityContext)newCtxt);
            return;
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)realUserName, authentication.getCredentials(), newAuthorities);
        token.setDetails(details);
        newCtxt.setAuthentication((Authentication)token);
        SecurityContextHolder.setContext((SecurityContext)newCtxt);
    }
}

