/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.content.WelcomeTemplateHandler;
import com.xebialabs.xlrelease.domain.StartWelcomeReleaseEvent;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.events.UserProfileCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.utils.UserProfileValidationConstants;
import com.xebialabs.xlrelease.views.users.UserFilters;
import io.micrometer.core.annotation.Timed;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Option;

@Service
public class UserProfileService {
    public static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users";
    private static final List<String> EXTERNAL_PROVIDER_PROPERTIES = Arrays.asList("email", "fullName", "externalId");
    private static final Logger logger = LoggerFactory.getLogger(UserProfileService.class);
    private final UserProfileRepository userProfileRepository;
    private final PrincipalDataProvider principalDataProvider;
    private final LicenseService licenseService;
    private final SessionService sessionService;
    private final EventBus eventBus;
    private final XlrConfig xlrConfig;

    @Autowired
    public UserProfileService(UserProfileRepository userProfileRepository, PrincipalDataProvider principalDataProvider, LicenseService licenseService, SessionService sessionService, EventBus eventBus, WelcomeTemplateHandler welcomeTemplateHandler, XlrConfig xlrConfig) {
        this.userProfileRepository = userProfileRepository;
        this.principalDataProvider = principalDataProvider;
        this.licenseService = licenseService;
        this.sessionService = sessionService;
        this.eventBus = eventBus;
        this.xlrConfig = xlrConfig;
    }

    public static boolean hasExternalPropertiesChanged(UserProfile original, UserProfile updated) {
        return !original.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> EXTERNAL_PROVIDER_PROPERTIES.contains(pd.getName())).allMatch(pd -> pd.areEqual((ConfigurationItem)original, (ConfigurationItem)updated));
    }

    @Timed
    public List<UserProfile> findAll(Boolean fullProfile) {
        return this.userProfileRepository.findAll(fullProfile);
    }

    @Timed
    public void deleteByUsername(String username) {
        UserProfile profile = this.findByUsername(username);
        String id = this.toCanonicalId(username);
        this.userProfileRepository.delete(id);
        this.principalDataProvider.invalidate(username);
        if (null != profile) {
            this.eventBus.publish((XLReleaseEvent)new UserProfileDeletedEvent(profile));
        } else {
            logger.warn("User profile was not found for username '{}'", (Object)username);
        }
    }

    @Timed
    public int countUserWithLoginAllowed() {
        return this.userProfileRepository.countUserWithLoginAllowed();
    }

    @Timed
    public List<UserProfile> search(String email, String fullName, Boolean loginAllowed, Date lastActiveAfter, Date lastActiveBefore, Long page, Long resultsPerPage) {
        return this.userProfileRepository.customSearch(email, fullName, loginAllowed, lastActiveAfter, lastActiveBefore, (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultsPerPage));
    }

    public Page<UserProfile> searchUserAccounts(UserFilters userFilters, Pageable pageable) {
        return this.userProfileRepository.searchUserProfiles(userFilters, pageable);
    }

    @Timed
    public UserProfile findByUsername(String username) {
        return (UserProfile)this.userProfileRepository.findById(this.toCanonicalId(username)).getOrElse(() -> null);
    }

    @Timed
    public void ensureCreated(String username) {
        this.getOrCreate(username, true);
    }

    @Timed
    public UserProfile discover(String username) {
        return this.getOrCreate(username, false);
    }

    @Timed
    public UserProfile resolveUserProfile(String username) {
        return this.resolveUserProfile(username, true);
    }

    @Timed
    public UserProfile resolveUserProfile(String username, boolean resolveWithDataProvider) {
        UserProfile foundByUsername = this.findByUsername(username);
        if (foundByUsername != null) {
            return foundByUsername;
        }
        if (resolveWithDataProvider) {
            UserData userData = this.principalDataProvider.getUserData(username);
            return new UserProfile(username, userData.getEmail(), userData.getFullName(), true, userData.getExternalId());
        }
        return new UserProfile(username);
    }

    private UserProfile getOrCreate(String username, boolean createIfNotFound) {
        UserProfile existingUserProfile = this.findByUsername(username);
        if (existingUserProfile != null) {
            return existingUserProfile;
        }
        return this.createUserProfile(username, createIfNotFound);
    }

    private UserProfile createUserProfile(String username, boolean createIfNotFound) {
        this.principalDataProvider.invalidate(username);
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound() || createIfNotFound) {
            UserProfile profile = new UserProfile(username, userData.getEmail(), userData.getFullName(), true, userData.getExternalId());
            this.save(profile);
            return profile;
        }
        return null;
    }

    @Timed
    public UserProfile createOrUpdate(String username) {
        UserProfile profile = this.findByUsername(username);
        if (profile != null) {
            UserData userData = this.principalDataProvider.getUserData(username);
            if (userData.isFound()) {
                UserProfile original = CiCloneHelper.cloneCi(profile);
                if (Strings.isNotBlank((String)userData.getEmail())) {
                    profile.setEmail(userData.getEmail());
                }
                if (Strings.isNotBlank((String)userData.getFullName())) {
                    profile.setFullName(userData.getFullName());
                }
                profile.setExternalId(userData.getExternalId());
                if (UserProfileService.hasExternalPropertiesChanged(original, profile)) {
                    logger.debug("Updating user profile for user [{}]", (Object)username);
                    this.updateProfile(profile);
                }
            }
            return profile;
        }
        logger.debug("Creating user profile for user [{}]", (Object)username);
        return this.createUserProfile(username, true);
    }

    @Timed
    public void save(UserProfile profile) {
        this.validate(profile);
        this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        if (this.userProfileRepository.exists(profile.getCanonicalId())) {
            this.userProfileRepository.update(Collections.singletonList(profile));
            this.eventBus.publish((XLReleaseEvent)new UserProfileUpdatedEvent(profile));
        } else {
            this.userProfileRepository.create(profile);
            this.eventBus.publish((XLReleaseEvent)new UserProfileCreatedEvent(profile));
            this.eventBus.publish((XLReleaseEvent)new StartWelcomeReleaseEvent(profile.getName(), UserInfoResolver.getFullNameOrUsernameOf(profile.getName(), profile.getFullName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timed
    public void updateProfile(UserProfile ... profiles) {
        for (UserProfile userProfile : profiles) {
            this.validate(userProfile);
            this.revokeLoginAllowedAccordingTo(userProfile, this.licenseService.getLicense());
        }
        try {
            this.userProfileRepository.update(Arrays.asList(profiles));
        }
        finally {
            for (UserProfile userProfile : profiles) {
                if (!userProfile.isLoginAllowed()) {
                    this.sessionService.disconnect(userProfile.getName());
                }
                this.eventBus.publish((XLReleaseEvent)new UserProfileUpdatedEvent(userProfile));
            }
        }
    }

    @Timed
    public boolean updateLastActive(String canonicalId, Date lastActive) {
        return this.userProfileRepository.updateLastActive(canonicalId, lastActive);
    }

    @Timed
    public int updateLastActiveBatch(Map<String, Date> entries) {
        return this.userProfileRepository.updateLastActiveBatch(entries);
    }

    @Timed
    public void validate(UserProfile profile) {
        Checks.checkArgument((Strings.isBlank((String)profile.getDateFormat()) || UserProfileValidationConstants.ACCEPTED_DATE_FORMATS.contains(profile.getDateFormat()) ? 1 : 0) != 0, (String)"Date format '%s' is not supported", (Object[])new Object[]{profile.getDateFormat()});
        Checks.checkArgument((Strings.isBlank((String)profile.getTimeFormat()) || UserProfileValidationConstants.ACCEPTED_TIME_FORMATS.contains(profile.getTimeFormat()) ? 1 : 0) != 0, (String)"Time format '%s' is not supported", (Object[])new Object[]{profile.getTimeFormat()});
        Checks.checkArgument((profile.getFirstDayOfWeek() == null || UserProfileValidationConstants.ACCEPTED_FIRST_DAY_OF_WEEK_FORMATS.contains(profile.getFirstDayOfWeek()) ? 1 : 0) != 0, (String)"Week start value '%s' is not supported", (Object[])new Object[]{profile.getFirstDayOfWeek()});
        Checks.checkArgument((Strings.isBlank((String)profile.getFullName()) || profile.getFullName().length() <= 255 ? 1 : 0) != 0, (String)"Maximum allowed length for the full name is 255 characters. Provide an entry with fewer characters.", (Object[])new Object[]{profile.getFullName()});
        Checks.checkArgument((Strings.isBlank((String)profile.getEmail()) || profile.getEmail().length() <= 255 ? 1 : 0) != 0, (String)"Maximum allowed length for the email is 255 characters. Provide an entry with fewer characters.", (Object[])new Object[]{profile.getEmail()});
        String emailRegex = this.xlrConfig.userProfile_emailRegex();
        Checks.checkArgument((Strings.isBlank((String)profile.getEmail()) || profile.getEmail().matches(emailRegex) ? 1 : 0) != 0, (String)"The email address '%s' is invalid. Provide a valid email address.", (Object[])new Object[]{profile.getEmail()});
    }

    @VisibleForTesting
    void revokeLoginAllowedAccordingTo(UserProfile profile, License license) {
        if (!profile.isLoginAllowed()) {
            return;
        }
        String maxNumberOfUsers = license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null && Integer.parseInt(maxNumberOfUsers) <= this.countUserWithLoginAllowed()) {
            profile.setLoginAllowed(false);
        }
    }

    private String toCanonicalId(String username) {
        return username.toLowerCase();
    }
}

