package com.xebialabs.xlrelease.views.converters;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.views.ConfigurationView;

@Component
public class ConfigurationItemViewConverter extends BaseConfigurationItemViewConverter {

    @Autowired
    public ConfigurationItemViewConverter(final ConfigurationRepository configurationRepository) {
        super(configurationRepository);
    }

    public Configuration fromView(ConfigurationView configurationView) {
        Configuration configuration = newInstance(configurationView);
        fillItem(configuration, configurationView);

        return configuration;
    }

    public ConfigurationView toAnonymizedView(Configuration configuration) {
        ConfigurationView configurationView = new ConfigurationView();
        configurationView.setId(configuration.getId());
        configurationView.setTitle(configuration.getTitle());
        configurationView.setType(configuration.getType().toString());
        // do not clear the URL of HttpConnection instances as it is used in UI
        Object url = null;
        if (configuration.hasProperty("url")) {
            url = configuration.getProperty("url");
        }
        if (url != null) {
            Map<String, Object> anonymizedProperties = new HashMap<>();
            anonymizedProperties.put("url", url);
            configurationView.setProperties(anonymizedProperties);
        } else {
            configurationView.setProperties(null);
        }

        return configurationView;
    }

    public ConfigurationView toView(Configuration configuration) {
        ConfigurationView configurationView = new ConfigurationView();
        fillView(configurationView, configuration);

        return configurationView;
    }
}
