package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.status.PhaseStatus
import com.xebialabs.xlrelease.domain.{Phase, Release}

trait PhaseRepository {

  def findById(id: String): Phase

  def findByIdWithoutDecorators(id: String): Phase

  def create(release: Release, phase: Phase): Phase

  def delete(release: Release, phase: Phase): Phase

  def update(release: Release, original: Phase, updated: Phase): Phase

  def move(release: Release, movedPhase: Phase): Phase

  def getTitle(phaseId: String): String

  def getStatus(phaseId: String): PhaseStatus

  def registerPersistenceInterceptor(persistenceInterceptor: PersistenceInterceptor[Phase]): Unit

  def updateProperties(phase: Phase): Boolean

  def batchInsertProperties(phases: Set[Phase], releaseUid: Int): Unit

  def batchUpdateProperties(phases: Set[Phase]): Int

}



