package com.xebialabs.xlrelease.service.sse

import com.xebialabs.xlrelease.service.SseService
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.stereotype.Service

import jakarta.ws.rs.sse.SseEventSink

@Service
@ConditionalOnProperty(name = Array("xl.features.sse.enabled"), havingValue = "false")
class DummySseService extends SseService {

  override def subscribeUserToSink(sink: SseEventSink): Unit = ()

  override def subscribeTopicToUser(topic: String): Unit = ()

  override def subscribeTopicToUser(topic: String, username: String): Unit = ()

  override def unsubscribeTopicToUser(topic: String): Unit = ()

  override def unsubscribeTopicToUser(topic: String, username: String): Unit = ()

  override def unsubscribeAllUsers(topic: String): Unit = ()

  override def sendEvent(topic: String, eventName: String, payload: String): Unit = ()
}
