/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseFailedEvent;
import com.xebialabs.xlrelease.domain.events.ReleasePausedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseResumedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseRetriedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFailingEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u0006\f\u0001YA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!)\u0011\b\u0001C\u0001u!)A\n\u0001C\u0005\u001b\")!\u000b\u0001C\u0005'\"9q\rAI\u0001\n\u0013A\u0007\"B:\u0001\t\u0013!\b\"\u0002=\u0001\t\u0013I(\u0001G\"sK\u0006$XMU3mK\u0006\u001cX\rV1tW\"\u000bg\u000e\u001a7fe*\u0011A\"D\u0001\tQ\u0006tG\r\\3sg*\u0011abD\u0001\u0007KZ,g\u000e^:\u000b\u0005A\t\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u00112#A\u0005yK\nL\u0017\r\\1cg*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0013\u0001C4sSjTH.\u001a3\n\u0005\u0011z\"a\u0002'pO\u001eLgnZ\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S=\ta!Y2u_J\u001c\u0018BA\u0016)\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u00039!\u0018m]6SKB|7/\u001b;pef\u0004\"AL\u0019\u000e\u0003=R!\u0001M\b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00023_\tqA+Y:l%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\bF\u00026oa\u0002\"A\u000e\u0001\u000e\u0003-AQ!J\u0002A\u0002\u0019BQ\u0001L\u0002A\u00025\nqc\u001c8SK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;\u0015\u0005mr\u0004C\u0001\r=\u0013\ti\u0014D\u0001\u0003V]&$\b\"B \u0005\u0001\u0004\u0001\u0015!B3wK:$\bCA!F\u001b\u0005\u0011%B\u0001\bD\u0015\t!u\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003\r\n\u0013QCU3mK\u0006\u001cX-\u0012=fGV$\u0018n\u001c8Fm\u0016tG\u000f\u000b\u0002\u0005\u0011B\u0011\u0011JS\u0007\u0002\u001b%\u00111*\u0004\u0002\n'V\u00147o\u0019:jE\u0016\fQ\u0003[1oI2,'+\u001a7fCN,W\t_3dkR,G\r\u0006\u0002<\u001d\")q(\u0002a\u0001\u001fB\u0011\u0011\tU\u0005\u0003#\n\u0013ACU3mK\u0006\u001cX-\u0012=fGV$X\rZ#wK:$\u0018a\u0003:fY\u0016\f7/\u001a'j].$2\u0001V0f!\t)FL\u0004\u0002W5B\u0011q+G\u0007\u00021*\u0011\u0011,F\u0001\u0007yI|w\u000e\u001e \n\u0005mK\u0012A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\r\t\u000b\u00014\u0001\u0019A1\u0002\u000fI,G.Z1tKB\u0011!mY\u0007\u0002\u0007&\u0011Am\u0011\u0002\b%\u0016dW-Y:f\u0011\u001d1g\u0001%AA\u0002Q\u000bQB]3mK\u0006\u001cXm\u0015;biV\u001c\u0018!\u0006:fY\u0016\f7/\u001a'j].$C-\u001a4bk2$HEM\u000b\u0002S*\u0012AK[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001]\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025U\u0004H-\u0019;f!\u0006\u0014XM\u001c;UCN\\7\u000b^1ukNd\u0015N\\3\u0015\u0007m*h\u000fC\u0003a\u0011\u0001\u0007\u0011\rC\u0003x\u0011\u0001\u0007A+\u0001\u0004ti\u0006$Xo]\u0001\u0014SN\u001c%/Z1uKJ+G.Z1tKR\u000b7o\u001b\u000b\u0003uv\u0004\"\u0001G>\n\u0005qL\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006}&\u0001\r\u0001V\u0001\u0007i\u0006\u001c8.\u00133)\u0007\u0001\t\t\u0001\u0005\u0003\u0002\u0004\u0005EQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002\f\u00055\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005=\u0011aA8sO&!\u00111CA\u0003\u0005\u001d\u0019VM\u001d<jG\u0016D3\u0001AA\f!\rI\u0015\u0011D\u0005\u0004\u00037i!!D#wK:$H*[:uK:,'\u000f")
public class CreateReleaseTaskHandler
implements Logging {
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CreateReleaseTaskHandler createReleaseTaskHandler = this;
        synchronized (createReleaseTaskHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onReleaseExecutionEvent(ReleaseExecutionEvent event) {
        Option parentTaskId = Option$.MODULE$.apply((Object)event.release().getStartedFromTaskId());
        if (parentTaskId.exists((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskHandler.$anonfun$onReleaseExecutionEvent$1(this, id)))) {
            ReleaseExecutionEvent releaseExecutionEvent = event;
            if (releaseExecutionEvent instanceof ReleaseStartedEvent) {
                ReleaseStartedEvent releaseStartedEvent = (ReleaseStartedEvent)releaseExecutionEvent;
                Release release = releaseStartedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleasePausedEvent) {
                ReleasePausedEvent releasePausedEvent = (ReleasePausedEvent)releaseExecutionEvent;
                Release release = releasePausedEvent.release();
                this.updateParentTaskStatusLine(release, "Paused");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseResumedEvent) {
                ReleaseResumedEvent releaseResumedEvent = (ReleaseResumedEvent)releaseExecutionEvent;
                Release release = releaseResumedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseFailedEvent) {
                ReleaseFailedEvent releaseFailedEvent = (ReleaseFailedEvent)releaseExecutionEvent;
                Release release = releaseFailedEvent.release();
                this.updateParentTaskStatusLine(release, "Failed");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseStartedFailingEvent) {
                ReleaseStartedFailingEvent releaseStartedFailingEvent = (ReleaseStartedFailingEvent)releaseExecutionEvent;
                Release release = releaseStartedFailingEvent.release();
                this.updateParentTaskStatusLine(release, "Failing");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseRetriedEvent) {
                ReleaseRetriedEvent releaseRetriedEvent = (ReleaseRetriedEvent)releaseExecutionEvent;
                Release release = releaseRetriedEvent.release();
                this.updateParentTaskStatusLine(release, "");
                return;
            }
            if (releaseExecutionEvent instanceof ReleaseExecutedEvent) {
                ReleaseExecutedEvent releaseExecutedEvent = (ReleaseExecutedEvent)releaseExecutionEvent;
                this.handleReleaseExecuted(releaseExecutedEvent);
                return;
            }
            throw new MatchError((Object)releaseExecutionEvent);
        }
    }

    private void handleReleaseExecuted(ReleaseExecutedEvent event) {
        ReleaseExecutedEvent releaseExecutedEvent = event;
        if (releaseExecutedEvent instanceof ReleaseAbortedEvent) {
            ReleaseAbortedEvent releaseAbortedEvent = (ReleaseAbortedEvent)releaseExecutedEvent;
            Release release = releaseAbortedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$2(parentTask))).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$3(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (releaseExecutedEvent instanceof ReleaseCompletedEvent) {
            ReleaseCompletedEvent releaseCompletedEvent = (ReleaseCompletedEvent)releaseExecutedEvent;
            Release release = releaseCompletedEvent.release();
            String parentTaskId = release.getStartedFromTaskId();
            Try$.MODULE$.apply((Function0 & Serializable)() -> (CreateReleaseTask)$this.taskRepository.findById(parentTaskId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).withFilter((Function1 & Serializable)parentTask -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$5(parentTask))).foreach((Function1 & Serializable)parentTask -> {
                CreateReleaseTaskHandler.$anonfun$handleReleaseExecuted$6(this, release, parentTaskId, parentTask);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)releaseExecutedEvent);
    }

    private String releaseLink(Release release, String releaseStatus) {
        Object status = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(releaseStatus)) ? releaseStatus + ":" : "";
        return "[" + (String)status + " " + release.getTitle() + "](#/releases/" + IdType.DOMAIN.convertToViewId(release.getId()) + ")";
    }

    private String releaseLink$default$2() {
        return "";
    }

    private void updateParentTaskStatusLine(Release release, String status) {
        String parentTaskId = release.getStartedFromTaskId();
        if (parentTaskId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parentTaskId))) {
            String msg = String.valueOf(this.releaseLink(release, status));
            this.releaseActorService.updateTaskStatusLine(parentTaskId, msg);
            return;
        }
    }

    private boolean isCreateReleaseTask(String taskId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.taskRepository.getType(taskId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String taskType = (String)success.value();
            return Type.valueOf(CreateReleaseTask.class).equals((Object)Type.valueOf((String)taskType));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$onReleaseExecutionEvent$1(CreateReleaseTaskHandler $this, String id) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(id)) && $this.isCreateReleaseTask(id);
    }

    public static final /* synthetic */ boolean $anonfun$handleReleaseExecuted$2(CreateReleaseTask parentTask) {
        return parentTask.getWaitForRelease() && !parentTask.getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$3(CreateReleaseTaskHandler $this, Release release$1, String parentTaskId$1, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$1, $this.releaseLink$default$2()) + " was aborted.";
        $this.releaseActorService.failTaskAsync(parentTaskId$1, msg, User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$handleReleaseExecuted$5(CreateReleaseTask parentTask) {
        return parentTask.getWaitForRelease() && !parentTask.getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$handleReleaseExecuted$6(CreateReleaseTaskHandler $this, Release release$2, String parentTaskId$2, CreateReleaseTask parentTask) {
        String msg = "Release " + $this.releaseLink(release$2, $this.releaseLink$default$2()) + " was completed.";
        $this.releaseActorService.markTaskAsDoneAsync(TaskStatus.COMPLETED, parentTaskId$2, msg, User.SYSTEM);
    }

    public CreateReleaseTaskHandler(ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

