package com.xebialabs.xlrelease.security.authentication.policy

import com.xebialabs.deployit.plumbing.authentication.InternalUser
import com.xebialabs.xlrelease.security.UserGroupService
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ExternalUserGroupMembershipCreationPolicy(userGroupService: UserGroupService)
  extends UserGroupMembershipCreationPolicy {

  override def order(): Int = 20

  override def policyApplies(authentication: Authentication): Boolean = {
    null != authentication &&
      null != authentication.getPrincipal &&
      !authentication.getPrincipal.isInstanceOf[InternalUser]
  }

  override def updateUserGroupMembership(authentication: Authentication): Unit = {
    val username = authentication.getName
    val groups = authentication.getAuthorities.asScala.map(_.getAuthority).toSet
    userGroupService.updateGroupsMembershipForUser(username, groups)
  }
}
