package com.xebialabs.xlrelease.actors.cluster;

import com.xebialabs.xlrelease.actors.cluster.ClusterMemberHeartbeatActor.{Beat, Start, Stop}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.pekko.spring.SpringActor
import org.apache.pekko.actor.{Actor, ActorLogging, Cancellable}

import scala.concurrent.duration.DurationInt;

@SpringActor
class ClusterMemberHeartbeatActor(xlrConfig: XlrConfig,
                                  clusterMembersService: ClusterMembersService) extends Actor with ActorLogging {

  override def receive: Receive = waitingForStart

  private def waitingForStart: Receive = {
    case Start() =>
      log.info("Starting cluster member heartbeat")
      val schedulerCancel: Cancellable = context.system.scheduler
        .scheduleAtFixedRate(
          1.second,
          xlrConfig.pekko.discovery.jdbcDiscovery.heartbeatInterval,
          self,
          Beat()
        )(context.dispatcher)
      context.become(started(schedulerCancel))
  }

  private def started(cancelableScheduler: Cancellable): Receive = {
    case Stop() =>
      log.info("Stopping cluster member heartbeat")
      cancelableScheduler.cancel()
      context.become(waitingForStart)
    case Beat() =>
      clusterMembersService.registerSelf()
    case Start() =>
      log.debug("Heartbeat already started, ignoring Start message")
  }


}

object ClusterMemberHeartbeatActor {
  trait LivenessEvents

  case class Start() extends LivenessEvents

  case class Stop() extends LivenessEvents

  case class Beat() extends LivenessEvents
}