package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.repository.{Ids, ReleaseRepository, TaskRepository}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class DueSoonAndOverdueService @Autowired()(releaseRepository: ReleaseRepository,
                                            taskRepository: TaskRepository,
                                            releaseActorService: ReleaseActorService) extends Logging {

  def notifyAboutOverdueTasks(): Unit = {
    logger.debug("Finding overdue tasks")
    taskRepository.findOverdueTaskIds().groupBy(Ids.releaseIdFrom).foreach { case (releaseId, taskIds) =>
      logger.debug(s"Found overdue tasks: ${taskIds.mkString(",")}")
      releaseActorService.notifyOverdueTasks(releaseId, taskIds: _*)
    }
  }


  def notifyAboutOverdueReleases(): Unit = {
    logger.debug("Finding overdue releases")
    releaseRepository.findOverdueReleaseIds().foreach { releaseId =>
      logger.debug(s"Found overdue release: $releaseId")
      releaseActorService.notifyOverdue(releaseId)
    }
  }

  def notifyAboutDueSoonTasks(): Unit = {
    logger.debug("Finding due soon tasks")
    taskRepository.findDueSoonTaskIds().groupBy(Ids.releaseIdFrom).foreach { case (releaseId, taskIds) =>
      logger.debug(s"Found due soon tasks: ${taskIds.mkString(",")}")
      releaseActorService.notifyDueSoonTasks(releaseId, taskIds:_*)
    }
  }
}
