/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.XlrFormatFactory;
import com.xebialabs.deployit.plumbing.serialization.MetadataIncludingCiConverter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import javax.ws.rs.core.MediaType;

public abstract class AbstractConfigurationItemReaderWriter {
    protected static final String LEVEL = "level";
    protected XlrFormatFactory formats;
    protected Repository repository;

    public AbstractConfigurationItemReaderWriter(RepositoryFactory repositoryFactory, XlrFormatFactory formats) {
        this.repository = repositoryFactory.create();
        this.formats = formats;
    }

    protected ConfigurationItemConverter createConverter() {
        return new MetadataIncludingCiConverter();
    }

    protected int getCiRefsFromLevel() {
        int level = 0;
        Object levelParam = RequestLocal.getMap().get(LEVEL);
        if (levelParam != null) {
            level = (Integer)levelParam;
        }
        return level;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = AbstractConfigurationItemReaderWriter.getClassFromGenericType(genericType);
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    static Class<?> getClassFromGenericType(Type genericType) {
        Type declaredType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        Class type = declaredType instanceof WildcardType ? (Class)((WildcardType)declaredType).getUpperBounds()[0] : (Class)declaredType;
        return type;
    }
}

