/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.api.v1.PhaseApi;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TaskApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class XLReleaseServiceHolder {
    private static RepositoryService repositoryService;
    private static Map<String, ? extends ApiService> apiServiceMap;

    private XLReleaseServiceHolder() {
    }

    public static void init(RepositoryService repositoryService, List<? extends ApiService> apiServiceList) {
        XLReleaseServiceHolder.repositoryService = repositoryService;
        apiServiceMap = apiServiceList.stream().collect(Collectors.toMap(ApiService::serviceName, Function.identity()));
    }

    public static List<? extends ApiService> getApiServices() {
        return apiServiceMap.values().stream().collect(Collectors.toList());
    }

    public static RepositoryService getRepositoryService() {
        return repositoryService;
    }

    public static TaskApi getTaskApi() {
        return (TaskApi)apiServiceMap.get("taskApi");
    }

    public static PhaseApi getPhaseApi() {
        return (PhaseApi)apiServiceMap.get("phaseApi");
    }

    public static ReleaseApi getReleaseApi() {
        return (ReleaseApi)apiServiceMap.get("releaseApi");
    }

    public static TemplateApi getTemplateApi() {
        return (TemplateApi)apiServiceMap.get("templateApi");
    }

    public static ConfigurationApi getConfigurationApi() {
        return (ConfigurationApi)apiServiceMap.get("configurationApi");
    }

    static {
        apiServiceMap = Collections.emptyMap();
    }
}

