/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.SecurityResource;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import com.xebialabs.xlrelease.views.RoleView;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePrincipalsResource {
    private SecurityResource securityResource;
    private PermissionChecker permissionChecker;
    private RoleService roleService;
    private DtoWriter dtoWriter = new DtoWriter();
    private UserViewConverter userViewConverter;

    @Autowired
    public RolePrincipalsResource(SecurityResource securityResource, PermissionChecker permissionChecker, RoleService roleService, UserViewConverter userViewConverter) {
        this.securityResource = securityResource;
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.userViewConverter = userViewConverter;
    }

    @GET
    @Timed
    @Path(value="names")
    public List<String> readRoleNames() {
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return assignments.stream().map(assignment -> assignment.getRole().getName()).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="principals")
    public List<RolePrincipalsView> readRolePrincipals() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List<RolePrincipals> assignments = this.getRolePrincipalsList();
        return assignments.stream().map(this::getRolePrincipalsView).collect(Collectors.toList());
    }

    private RolePrincipalsView getRolePrincipalsView(RolePrincipals rolePrincipal) {
        RoleView roleview = new RoleView(rolePrincipal.getRole());
        List<UserView> rolePrincipalsView = this.userViewConverter.toUserView(rolePrincipal.getPrincipals());
        return new RolePrincipalsView(roleview, rolePrincipalsView);
    }

    @PUT
    @Timed
    @Path(value="principals")
    public void setGlobalRolePermissions(List<RolePrincipalsView> rolePrincipalsViews) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List rolePrincipals = rolePrincipalsViews.stream().map(RolePrincipalsView::toRolePrincipals).collect(Collectors.toList());
        this.securityResource.writeRolePrincipals(rolePrincipals);
    }

    private List<RolePrincipals> getRolePrincipalsList() {
        List multimap = this.roleService.readRoleAssignments();
        return this.dtoWriter.writeRoleAssignments(multimap);
    }
}

