/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class TaskAccess
extends BaseConfigurationItem {
    public static final String TASK_ACCESS_PATH = "Configuration/taskAccess";
    @Property(required=false)
    private boolean isAllowedToAll;
    @Property(required=false)
    private List<String> roles = Lists.newArrayList();

    public TaskAccess() {
    }

    public TaskAccess(String taskType, boolean isAllowedToAll, List<String> roles) {
        Preconditions.checkArgument((boolean)this.isTaskAccessValid(isAllowedToAll, roles), (Object)"Roles must be empty when task access is allowed to all");
        this.id = TaskAccess.getTaskAccessId(taskType);
        this.roles = roles;
        this.isAllowedToAll = isAllowedToAll;
    }

    private boolean isTaskAccessValid(boolean isAllowedToAll, List<String> roles) {
        return !isAllowedToAll || roles.isEmpty();
    }

    public static String getTaskAccessId(String taskType) {
        return "Configuration/taskAccess/" + taskType;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean isAllowedToAll() {
        return this.isAllowedToAll;
    }

    public void setAllowedToAll(boolean isAllowedToAll) {
        this.isAllowedToAll = isAllowedToAll;
    }
}

